/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.icao;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.eidparser.lds.DataGroup;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVOutputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import com.fis.ekyc.nfc.build_in.scuba.util.Hex;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DG12File
extends DataGroup {
    private static final long serialVersionUID = -1979367459379125674L;
    private static final int TAG_LIST_TAG = 92;
    public static final int ISSUING_AUTHORITY_TAG = 24345;
    public static final int DATE_OF_ISSUE_TAG = 24358;
    public static final int NAME_OF_OTHER_PERSON_TAG = 24346;
    public static final int ENDORSEMENTS_AND_OBSERVATIONS_TAG = 24347;
    public static final int TAX_OR_EXIT_REQUIREMENTS_TAG = 24348;
    public static final int IMAGE_OF_FRONT_TAG = 24349;
    public static final int IMAGE_OF_REAR_TAG = 24350;
    public static final int DATE_AND_TIME_OF_PERSONALIZATION_TAG = 24405;
    public static final int PERSONALIZATION_SYSTEM_SERIAL_NUMBER_TAG = 24406;
    public static final int CONTENT_SPECIFIC_CONSTRUCTED_TAG = 160;
    public static final int COUNT_TAG = 2;
    private static final String SDF = "yyyyMMdd";
    private static final String SDTF = "yyyyMMddhhmmss";
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private String issuingAuthority;
    private String dateOfIssue;
    private List<String> namesOfOtherPersons;
    private String endorsementsAndObservations;
    private String taxOrExitRequirements;
    private byte[] imageOfFront;
    private byte[] imageOfRear;
    private String dateAndTimeOfPersonalization;
    private String personalizationSystemSerialNumber;
    private List<Integer> tagPresenceList;

    public DG12File(String string2, Date object, List<String> list, String string3, String string4, byte[] byArray, byte[] byArray2, Date object2, String string5) {
        object = object == null ? null : new SimpleDateFormat(SDF).format((Date)object);
        object2 = object2 == null ? null : new SimpleDateFormat(SDTF).format((Date)object2);
        this(string2, (String)object, list, string3, string4, byArray, byArray2, (String)object2, string5);
    }

    public DG12File(String object, String string2, List<String> list, String string3, String string4, byte[] byArray, byte[] byArray2, String string5, String string6) {
        super(108);
        this.issuingAuthority = object;
        this.dateOfIssue = string2;
        if (list == null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        } else {
            ArrayList<String> arrayList;
            object = arrayList;
            arrayList = new ArrayList<String>(list);
        }
        DG12File dG12File = this;
        dG12File.namesOfOtherPersons = object;
        dG12File.endorsementsAndObservations = string3;
        dG12File.taxOrExitRequirements = string4;
        dG12File.imageOfFront = byArray;
        dG12File.imageOfRear = byArray2;
        dG12File.dateAndTimeOfPersonalization = string5;
        dG12File.personalizationSystemSerialNumber = string6;
    }

    public DG12File(InputStream inputStream) {
        super(108, inputStream);
    }

    private void readField(int n, TLVInputStream tLVInputStream) {
        int n2;
        block24: {
            block23: {
                block19: {
                    block20: {
                        block21: {
                            byte[] byArray;
                            block22: {
                                n2 = tLVInputStream.readTag();
                                if (n2 != 160) break block19;
                                TLVInputStream tLVInputStream2 = tLVInputStream;
                                tLVInputStream2.readLength();
                                n = tLVInputStream2.readTag();
                                if (n != 2) break block20;
                                n = tLVInputStream.readLength();
                                if (n != 1) break block21;
                                byArray = tLVInputStream.readValue();
                                if (byArray == null || byArray.length != 1) break block22;
                                int n3 = byArray[0] & 0xFF;
                                for (n2 = 0; n2 < n3; ++n2) {
                                    int n4 = tLVInputStream.readTag();
                                    if (n4 == 24346) {
                                        TLVInputStream tLVInputStream3 = tLVInputStream;
                                        tLVInputStream3.readLength();
                                        this.parseNameOfOtherPerson(tLVInputStream3.readValue());
                                        continue;
                                    }
                                    throw new IllegalArgumentException(h.a(n4, h.a.a(24346, b.b.a("Expected "), ", found ")));
                                }
                                break block23;
                            }
                            throw new IllegalArgumentException(b.b.a("Number of content specific fields should be encoded in single byte, found ").append(Arrays.toString(byArray)).toString());
                        }
                        throw new IllegalArgumentException(a.a("Expected length 1 count length, found ", n));
                    }
                    throw new IllegalArgumentException(h.a(n, h.a.a(2, b.b.a("Expected "), ", found ")));
                }
                if (n2 != n) break block24;
                TLVInputStream tLVInputStream4 = tLVInputStream;
                tLVInputStream4.readLength();
                byte[] byArray = tLVInputStream4.readValue();
                if (n2 != 24358) {
                    if (n2 != 24405) {
                        if (n2 != 24406) {
                            switch (n2) {
                                default: {
                                    throw new IllegalArgumentException(h.a(n2, b.b.a("Unknown field tag in DG12: ")));
                                }
                                case 24350: {
                                    this.parseImageOfRear(byArray);
                                    break;
                                }
                                case 24349: {
                                    this.parseImageOfFront(byArray);
                                    break;
                                }
                                case 24348: {
                                    this.parseTaxOrExitRequirements(byArray);
                                    break;
                                }
                                case 24347: {
                                    this.parseEndorsementsAndObservations(byArray);
                                    break;
                                }
                                case 24346: {
                                    this.parseNameOfOtherPerson(byArray);
                                    break;
                                }
                                case 24345: {
                                    this.parseIssuingAuthority(byArray);
                                    break;
                                }
                            }
                        } else {
                            this.parsePersonalizationSystemSerialNumber(byArray);
                        }
                    } else {
                        this.parseDateAndTimeOfPersonalization(byArray);
                    }
                } else {
                    this.parseDateOfIssue(byArray);
                }
            }
            return;
        }
        throw new IllegalArgumentException(h.a(n2, h.a.a(n, b.b.a("Expected "), ", but found ")));
    }

    private void parsePersonalizationSystemSerialNumber(byte[] byArray) {
        try {
            this.personalizationSystemSerialNumber = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.personalizationSystemSerialNumber = new String(byArray).trim();
        }
    }

    private void parseDateAndTimeOfPersonalization(byte[] byArray) {
        try {
            this.dateAndTimeOfPersonalization = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
        }
    }

    private void parseImageOfFront(byte[] byArray) {
        this.imageOfFront = byArray;
    }

    private void parseImageOfRear(byte[] byArray) {
        this.imageOfRear = byArray;
    }

    private void parseTaxOrExitRequirements(byte[] byArray) {
        try {
            this.taxOrExitRequirements = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.taxOrExitRequirements = new String(byArray).trim();
        }
    }

    private void parseEndorsementsAndObservations(byte[] byArray) {
        try {
            this.endorsementsAndObservations = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.endorsementsAndObservations = new String(byArray).trim();
        }
    }

    private synchronized void parseNameOfOtherPerson(byte[] byArray) {
        String string2;
        Object object;
        if (this.namesOfOtherPersons == null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
            this.namesOfOtherPersons = object;
        }
        DG12File dG12File = this;
        object = string2;
        try {
            string2 = new String(byArray, "UTF-8");
            dG12File.namesOfOtherPersons.add(((String)object).trim());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.namesOfOtherPersons.add(new String(byArray).trim());
        }
    }

    private void parseDateOfIssue(byte[] byArray) {
        if (byArray != null) {
            if (byArray.length == 8) {
                try {
                    this.dateOfIssue = new String(byArray, "UTF-8").trim();
                    return;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
                }
            }
            LOGGER.warning("DG12 date of issue is not in expected ccyymmdd ASCII format");
            if (byArray.length == 4) {
                this.dateOfIssue = Hex.bytesToHexString(byArray).trim();
                return;
            }
            throw new IllegalArgumentException("Wrong date format");
        }
        throw new IllegalArgumentException("Wrong date format");
    }

    private void parseIssuingAuthority(byte[] byArray) {
        try {
            this.issuingAuthority = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.issuingAuthority = new String(byArray).trim();
        }
    }

    @Override
    public void readContent(InputStream inputStream) {
        if (inputStream instanceof TLVInputStream) {
            inputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream;
            TLVInputStream tLVInputStream2 = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
            inputStream = tLVInputStream2;
        }
        if (((TLVInputStream)inputStream).readTag() == 92) {
            Iterator iterator;
            ArrayList<Integer> arrayList;
            ByteArrayInputStream byteArrayInputStream;
            int n = ((TLVInputStream)inputStream).readLength();
            int n2 = 0;
            int n3 = n / 2;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
            byteArrayInputStream = new ByteArrayInputStream(((TLVInputStream)inputStream).readValue());
            ArrayList<Integer> arrayList2 = arrayList;
            arrayList = new ArrayList<Integer>(n3 + 1);
            while (n2 < n) {
                ArrayList<Integer> arrayList3 = arrayList2;
                int n4 = n2;
                n2 = new TLVInputStream(byteArrayInputStream2).readTag();
                n3 = n4 + TLVUtil.getTagLength(n2);
                arrayList3.add(n2);
                n2 = n3;
            }
            try {
                iterator = arrayList2.iterator();
            }
            catch (Throwable throwable) {
                byteArrayInputStream2.close();
                throw throwable;
            }
            while (true) {
                if (!iterator.hasNext()) break;
                this.readField((Integer)iterator.next(), (TLVInputStream)inputStream);
                continue;
                break;
            }
            byteArrayInputStream2.close();
            return;
        }
        throw new IllegalArgumentException("Expected tag list in DG12");
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        DataOutputStream dataOutputStream;
        Iterator iterator;
        if (outputStream instanceof TLVOutputStream) {
            outputStream = (TLVOutputStream)outputStream;
        } else {
            TLVOutputStream tLVOutputStream;
            iterator = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream(outputStream);
            outputStream = iterator;
        }
        ((TLVOutputStream)outputStream).writeTag(92);
        iterator = this.getTagPresenceList();
        DataOutputStream dataOutputStream2 = dataOutputStream;
        dataOutputStream = new DataOutputStream(outputStream);
        Object object = iterator.iterator();
        while (object.hasNext()) {
            dataOutputStream2.writeShort(object.next());
        }
        dataOutputStream2.flush();
        ((TLVOutputStream)outputStream).writeValueEnd();
        iterator = iterator.iterator();
        block9: while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (n != 24358) {
                if (n != 24405) {
                    if (n != 24406) {
                        switch (n) {
                            default: {
                                throw new IllegalArgumentException(h.a(n, b.b.a("Unknown field tag in DG12: ")));
                            }
                            case 24350: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                ((TLVOutputStream)outputStream).writeValue(this.imageOfRear);
                                continue block9;
                            }
                            case 24349: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                ((TLVOutputStream)outputStream).writeValue(this.imageOfFront);
                                continue block9;
                            }
                            case 24348: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                ((TLVOutputStream)outputStream).writeValue(this.taxOrExitRequirements.trim().getBytes("UTF-8"));
                                continue block9;
                            }
                            case 24347: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                ((TLVOutputStream)outputStream).writeValue(this.endorsementsAndObservations.trim().getBytes("UTF-8"));
                                continue block9;
                            }
                            case 24346: {
                                if (this.namesOfOtherPersons == null) {
                                    ArrayList<String> arrayList;
                                    ArrayList<String> arrayList2 = arrayList;
                                    arrayList = new ArrayList<String>();
                                    this.namesOfOtherPersons = arrayList2;
                                }
                                OutputStream outputStream2 = outputStream;
                                OutputStream outputStream3 = outputStream;
                                ((TLVOutputStream)outputStream3).writeTag(160);
                                ((TLVOutputStream)outputStream3).writeTag(2);
                                ((TLVOutputStream)outputStream2).write(this.namesOfOtherPersons.size());
                                ((TLVOutputStream)outputStream2).writeValueEnd();
                                Iterator<String> iterator2 = this.namesOfOtherPersons.iterator();
                                while (iterator2.hasNext()) {
                                    OutputStream outputStream4 = outputStream;
                                    object = iterator2.next();
                                    ((TLVOutputStream)outputStream4).writeTag(24346);
                                    ((TLVOutputStream)outputStream4).writeValue(((String)object).trim().getBytes("UTF-8"));
                                }
                                ((TLVOutputStream)outputStream).writeValueEnd();
                                continue block9;
                            }
                            case 24345: 
                        }
                        ((TLVOutputStream)outputStream).writeTag(n);
                        ((TLVOutputStream)outputStream).writeValue(this.issuingAuthority.trim().getBytes("UTF-8"));
                        continue;
                    }
                    ((TLVOutputStream)outputStream).writeTag(n);
                    ((TLVOutputStream)outputStream).writeValue(this.personalizationSystemSerialNumber.trim().getBytes("UTF-8"));
                    continue;
                }
                ((TLVOutputStream)outputStream).writeTag(n);
                ((TLVOutputStream)outputStream).writeValue(this.dateAndTimeOfPersonalization.getBytes("UTF-8"));
                continue;
            }
            ((TLVOutputStream)outputStream).writeTag(n);
            ((TLVOutputStream)outputStream).writeValue(this.dateOfIssue.getBytes("UTF-8"));
        }
    }

    public List<Integer> getTagPresenceList() {
        ArrayList<Integer> arrayList;
        List<Object> list = this.tagPresenceList;
        if (list != null) {
            return list;
        }
        list = arrayList;
        this.tagPresenceList = new ArrayList<Integer>(10);
        if (this.issuingAuthority != null) {
            list.add(24345);
        }
        if (this.dateOfIssue != null) {
            this.tagPresenceList.add(24358);
        }
        if ((list = this.namesOfOtherPersons) != null && !list.isEmpty()) {
            this.tagPresenceList.add(24346);
        }
        if (this.endorsementsAndObservations != null) {
            this.tagPresenceList.add(24347);
        }
        if (this.taxOrExitRequirements != null) {
            this.tagPresenceList.add(24348);
        }
        if (this.imageOfFront != null) {
            this.tagPresenceList.add(24349);
        }
        if (this.imageOfRear != null) {
            this.tagPresenceList.add(24350);
        }
        if (this.dateAndTimeOfPersonalization != null) {
            this.tagPresenceList.add(24405);
        }
        if (this.personalizationSystemSerialNumber != null) {
            this.tagPresenceList.add(24406);
        }
        return this.tagPresenceList;
    }

    public String getIssuingAuthority() {
        return this.issuingAuthority;
    }

    public String getDateOfIssue() {
        return this.dateOfIssue;
    }

    public List<String> getNamesOfOtherPersons() {
        return this.namesOfOtherPersons;
    }

    public String getEndorsementsAndObservations() {
        return this.endorsementsAndObservations;
    }

    public String getTaxOrExitRequirements() {
        return this.taxOrExitRequirements;
    }

    public byte[] getImageOfFront() {
        return this.imageOfFront;
    }

    public byte[] getImageOfRear() {
        return this.imageOfRear;
    }

    public String getDateAndTimeOfPersonalization() {
        return this.dateAndTimeOfPersonalization;
    }

    public String getPersonalizationSystemSerialNumber() {
        return this.personalizationSystemSerialNumber;
    }

    @Override
    public int getTag() {
        return 108;
    }

    @Override
    public String toString() {
        CharSequence charSequence = b.b.a("DG12File [");
        Object object = serializable.issuingAuthority;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.dateOfIssue;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.namesOfOtherPersons;
        object = object != null && !object.isEmpty() ? serializable.namesOfOtherPersons : "";
        charSequence = charSequence.append(object).append(", ");
        object = serializable.endorsementsAndObservations;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.taxOrExitRequirements;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.imageOfFront == null ? "" : b.a(b.b.a("image ("), serializable.imageOfFront.length, ")");
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.imageOfRear == null ? "" : b.a(b.b.a("image ("), serializable.imageOfRear.length, ")");
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.dateAndTimeOfPersonalization;
        if (object == null) {
            object = "";
        }
        DG12File dG12File = serializable;
        Serializable serializable = charSequence.append((String)object).append(", ");
        charSequence = dG12File.personalizationSystemSerialNumber;
        if (charSequence == null) {
            charSequence = "";
        }
        return d.a.a((StringBuilder)serializable, (String)charSequence, "]");
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == dG12File2) {
            return true;
        }
        if (!object.getClass().equals(dG12File2.getClass())) {
            return false;
        }
        DG12File dG12File = dG12File2;
        DG12File dG12File2 = (DG12File)object;
        return dG12File.toString().equals(dG12File2.toString());
    }

    public int hashCode() {
        return this.toString().hashCode() * 13 + 112;
    }
}

