/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.icao;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.scuba.data.Country;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ICAOCountry
extends Country {
    private static final long serialVersionUID = 2942942609311086138L;
    private static final Logger LOGGER;
    public static final ICAOCountry DE;
    public static final ICAOCountry GBD;
    public static final ICAOCountry GBN;
    public static final ICAOCountry GBO;
    public static final ICAOCountry GBP;
    public static final ICAOCountry GBS;
    public static final ICAOCountry XXA;
    public static final ICAOCountry XXB;
    public static final ICAOCountry XXC;
    public static final ICAOCountry XXX;
    public static final ICAOCountry EUE;
    public static final ICAOCountry UNO;
    public static final ICAOCountry UNA;
    public static final ICAOCountry UNK;
    public static final ICAOCountry XBA;
    public static final ICAOCountry XIM;
    public static final ICAOCountry XCC;
    public static final ICAOCountry XCO;
    public static final ICAOCountry XEC;
    public static final ICAOCountry XPO;
    public static final ICAOCountry XOM;
    private static final ICAOCountry[] VALUES;
    private String name;
    private String nationality;
    private String alpha2Code;
    private String alpha3Code;

    private ICAOCountry() {
    }

    private ICAOCountry(String string2, String string3, String string4) {
        String string5 = string4;
        this(string2, string3, string5, string5);
    }

    private ICAOCountry(String string2, String string3, String string4, String string5) {
        this.alpha2Code = string2;
        this.alpha3Code = string3;
        this.name = string4;
        this.nationality = string5;
    }

    public static Country getInstance(String string2) {
        ICAOCountry[] iCAOCountryArray = VALUES;
        int n = VALUES.length;
        for (int k = 0; k < n; ++k) {
            ICAOCountry iCAOCountry = iCAOCountryArray[k];
            if (!iCAOCountry.alpha3Code.equals(string2)) continue;
            return iCAOCountry;
        }
        try {
            return Country.getInstance(string2);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Unknown country", exception);
            throw new IllegalArgumentException(i.a("Illegal ICAO country alpha 3 code ", string2));
        }
    }

    static {
        ICAOCountry iCAOCountry;
        ICAOCountry iCAOCountry2;
        ICAOCountry iCAOCountry3;
        ICAOCountry iCAOCountry4;
        ICAOCountry iCAOCountry5;
        ICAOCountry iCAOCountry6;
        ICAOCountry iCAOCountry7;
        ICAOCountry iCAOCountry8;
        ICAOCountry iCAOCountry9;
        ICAOCountry iCAOCountry10;
        ICAOCountry iCAOCountry11;
        ICAOCountry iCAOCountry12;
        ICAOCountry iCAOCountry13;
        ICAOCountry iCAOCountry14;
        ICAOCountry iCAOCountry15;
        ICAOCountry iCAOCountry16;
        ICAOCountry iCAOCountry17;
        ICAOCountry iCAOCountry18;
        ICAOCountry iCAOCountry19;
        ICAOCountry iCAOCountry20;
        ICAOCountry iCAOCountry21;
        LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
        ICAOCountry iCAOCountry22 = iCAOCountry21;
        DE = new ICAOCountry("DE", "D<<", "Germany", "German");
        ICAOCountry iCAOCountry23 = iCAOCountry20;
        GBD = new ICAOCountry("GB", "GBD", "British Dependent territories citizen");
        ICAOCountry iCAOCountry24 = iCAOCountry19;
        GBN = new ICAOCountry("GB", "GBN", "British National (Overseas)");
        ICAOCountry iCAOCountry25 = iCAOCountry18;
        GBO = new ICAOCountry("GB", "GBO", "British Overseas citizen");
        ICAOCountry iCAOCountry26 = iCAOCountry17;
        GBP = new ICAOCountry("GB", "GBP", "British Protected person");
        ICAOCountry iCAOCountry27 = iCAOCountry16;
        GBS = new ICAOCountry("GB", "GBS", "British Subject");
        ICAOCountry iCAOCountry28 = iCAOCountry15;
        XXA = new ICAOCountry("XX", "XXA", "Stateless person", "Stateless");
        ICAOCountry iCAOCountry29 = iCAOCountry14;
        XXB = new ICAOCountry("XX", "XXB", "Refugee", "Refugee");
        ICAOCountry iCAOCountry30 = iCAOCountry13;
        XXC = new ICAOCountry("XX", "XXC", "Refugee (other)", "Refugee (other)");
        ICAOCountry iCAOCountry31 = iCAOCountry12;
        XXX = new ICAOCountry("XX", "XXX", "Unspecified", "Unspecified");
        ICAOCountry iCAOCountry32 = iCAOCountry11;
        EUE = new ICAOCountry("EU", "EUE", "Europe", "European");
        ICAOCountry iCAOCountry33 = iCAOCountry10;
        UNO = new ICAOCountry("UN", "UNO", "United Nations Organization");
        ICAOCountry iCAOCountry34 = iCAOCountry9;
        UNA = new ICAOCountry("UN", "UNA", "United Nations Agency");
        ICAOCountry iCAOCountry35 = iCAOCountry8;
        UNK = new ICAOCountry("UN", "UNK", "United Nations Interim Administration Mission in Kosovo");
        ICAOCountry iCAOCountry36 = iCAOCountry7;
        XBA = new ICAOCountry("XX", "XBA", "African Development Bank (ADB)");
        ICAOCountry iCAOCountry37 = iCAOCountry6;
        XIM = new ICAOCountry("XX", "XIM", "African Export-Import Bank (AFREXIM bank)");
        ICAOCountry iCAOCountry38 = iCAOCountry5;
        XCC = new ICAOCountry("XC", "XCC", "Carribean Community or one of its emissaries (CARICOM)");
        ICAOCountry iCAOCountry39 = iCAOCountry4;
        XCO = new ICAOCountry("XX", "XCO", "Common Market for Eastern an Southern Africa (COMESA)");
        ICAOCountry iCAOCountry40 = iCAOCountry3;
        XEC = new ICAOCountry("XX", "XEC", "Economic Community of West African States (ECOWAS)");
        ICAOCountry iCAOCountry41 = iCAOCountry2;
        XPO = new ICAOCountry("XP", "XPO", "International Criminal Police Organization (INTERPOL)");
        ICAOCountry iCAOCountry42 = iCAOCountry;
        XOM = new ICAOCountry("XO", "XOM", "Sovereign Military Order of Malta or one of its emissaries");
        VALUES = new ICAOCountry[]{iCAOCountry22, iCAOCountry23, iCAOCountry24, iCAOCountry25, iCAOCountry26, iCAOCountry27, iCAOCountry28, iCAOCountry29, iCAOCountry30, iCAOCountry31, iCAOCountry32, iCAOCountry33, iCAOCountry34, iCAOCountry35, iCAOCountry36, iCAOCountry37, iCAOCountry38, iCAOCountry39, iCAOCountry40, iCAOCountry41, iCAOCountry42};
    }

    @Override
    public int valueOf() {
        return -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNationality() {
        return this.nationality;
    }

    @Override
    public String toAlpha2Code() {
        return this.alpha2Code;
    }

    @Override
    public String toAlpha3Code() {
        return this.alpha3Code;
    }
}

