/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.protocol;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.eidparser.APDULevelPACECapable;
import com.fis.ekyc.nfc.build_in.eidparser.AccessKeySpec;
import com.fis.ekyc.nfc.build_in.eidparser.BACKeySpec;
import com.fis.ekyc.nfc.build_in.eidparser.CardServiceProtocolException;
import com.fis.ekyc.nfc.build_in.eidparser.PACEKeySpec;
import com.fis.ekyc.nfc.build_in.eidparser.PACESecretKeySpec;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import com.fis.ekyc.nfc.build_in.eidparser.lds.PACEInfo;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.AESSecureMessagingWrapper;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.DESedeSecureMessagingWrapper;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.PACECAMResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.PACEGMMappingResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.PACEGMWithDHMappingResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.PACEGMWithECDHAgreement;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.PACEGMWithECDHMappingResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.PACEIMMappingResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.PACEMappingResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.PACEResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.SecureMessagingWrapper;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.APDUWrapper;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.CardServiceException;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVOutputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import com.fis.ekyc.nfc.build_in.scuba.util.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PACEProtocol {
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private static final Provider BC_PROVIDER = Util.getBouncyCastleProvider();
    private static final byte[] IV_FOR_PACE_CAM_DECRYPTION = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final byte[] C0_LENGTH_128 = new byte[]{-90, 104, -119, 42, 124, 65, -29, -54, 115, -97, 64, -80, 87, -40, 89, 4};
    private static final byte[] C1_LENGTH_128 = new byte[]{-92, -31, 54, -84, 114, 95, 115, -117, 1, -63, -10, 2, 23, -63, -120, -83};
    private static final byte[] C0_LENGTH_256 = new byte[]{-44, 99, -42, 82, 52, 18, 78, -9, -119, 112, 84, -104, 109, -54, 10, 23, 78, 40, -33, 117, -116, -70, -96, 63, 36, 6, 22, 65, 77, 90, 22, 118};
    private static final byte[] C1_LENGTH_256 = new byte[]{84, -67, 114, 85, -16, -86, -8, 49, -66, -61, 66, 63, -49, 57, -42, -101, 108, -65, 6, 102, 119, -48, -6, -82, 90, -83, -39, -99, -8, -27, 53, 23};
    private APDULevelPACECapable service;
    private SecureMessagingWrapper wrapper;
    private int maxTranceiveLengthForSecureMessaging;
    private int maxTranceiveLengthForProtocol;
    private boolean shouldCheckMAC;
    private Random random;

    @Deprecated
    public PACEProtocol(APDULevelPACECapable aPDULevelPACECapable, SecureMessagingWrapper secureMessagingWrapper, int n, boolean bl) {
        this(aPDULevelPACECapable, secureMessagingWrapper, 256, n, bl);
    }

    public PACEProtocol(APDULevelPACECapable aPDULevelPACECapable, SecureMessagingWrapper secureMessagingWrapper, int n, int n2, boolean bl) {
        SecureRandom secureRandom;
        ((PACEProtocol)((Object)secureRandom2)).service = aPDULevelPACECapable;
        ((PACEProtocol)((Object)secureRandom2)).wrapper = secureMessagingWrapper;
        ((PACEProtocol)((Object)secureRandom2)).maxTranceiveLengthForProtocol = n;
        ((PACEProtocol)((Object)secureRandom2)).maxTranceiveLengthForSecureMessaging = n2;
        ((PACEProtocol)((Object)secureRandom2)).shouldCheckMAC = bl;
        SecureRandom secureRandom2 = secureRandom;
        secureRandom = new SecureRandom();
        v1.random = secureRandom2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private PACEResult doPACE(AccessKeySpec var1_6, SecretKey var2_7, String var3_8, AlgorithmParameterSpec var4_9, BigInteger var5_10) {
        block34: {
            block33: {
                block32: {
                    v0 = var3_8;
                    var6_12 = PACEInfo.toMappingType(v0);
                    var7_13 = PACEInfo.toKeyAgreementAlgorithm(v0);
                    var8_14 = PACEInfo.toCipherAlgorithm(v0);
                    var9_15 = PACEInfo.toDigestAlgorithm(v0);
                    var10_16 = PACEInfo.toKeyLength(v0);
                    this.checkConsistency(var7_13, var8_14, var9_15, var10_16, (AlgorithmParameterSpec)var4_9);
                    var11_17 = Cipher.getInstance(var8_14 + "/CBC/NoPadding");
                    var12_18 = 1;
                    if (!(var2_7 /* !! */  instanceof PACESecretKeySpec)) break block32;
                    var12_18 = ((PACESecretKeySpec)var2_7 /* !! */ ).getKeyReference();
                }
                if (var5_10 == null) {
                    var5_10 = null;
                } else {
                    var5_10 = Util.i2os((BigInteger)var5_10);
                }
                v1 = this;
                v2 = v1;
                v3 = v1;
                v4 = var3_8;
                v5 = var6_12;
                this.service.sendMSESetATMutualAuth(this.wrapper, (String)var3_8, var12_18, (byte[])var5_10);
                var2_7 /* !! */  = this.doPACEStep2(var6_12, var7_13, (AlgorithmParameterSpec)var4_9, this.doPACEStep1(var2_7 /* !! */ , (Cipher)var11_17), (Cipher)var11_17);
                var3_8 = var2_7 /* !! */ .getEphemeralParameters();
                var4_9 = this.doPACEStep3GenerateKeyPair(var7_13, (AlgorithmParameterSpec)var3_8);
                var3_8 = this.doPACEStep3ExchangePublicKeys(var4_9.getPublic(), (AlgorithmParameterSpec)var3_8);
                v6 = this.doPACEStep3KeyAgreement(var7_13, var4_9.getPrivate(), (PublicKey)var3_8);
                var5_10 = v6;
                v7 = var8_14;
                v8 = var10_16;
                var5_10 = Util.deriveKey((byte[])var5_10, var8_14, var10_16, 1);
                var11_17 = Util.deriveKey(v6, v7, v8, 2);
                var12_19 = v2.doPACEStep4(v4, v5, (KeyPair)var4_9, (PublicKey)var3_8, (SecretKey)var11_17);
                var13_20 = null;
                try {
                    var14_21 = v3.wrapper;
                    if (var14_21 != null) break block33;
                    var14_22 = 0L;
                }
                catch (GeneralSecurityException var0_1) {
                    throw new CardServiceProtocolException("Security exception in secure messaging establishment", 4, var0_1);
                }
            }
            var14_22 = var14_21.getSendSequenceCounter();
            if (!var8_14.startsWith("DESede")) ** GOTO lbl67
            v9 = this;
            var14_23 = v10;
            v11 = this;
            v12 = v11;
            var15_24 = v11.maxTranceiveLengthForSecureMessaging;
            var16_25 = v12.shouldCheckMAC;
            v10 = new DESedeSecureMessagingWrapper((SecretKey)var5_10, (SecretKey)var11_17, var15_24, var16_25, 0L);
            v9.wrapper = var14_23;
            break block34;
lbl67:
            // 1 sources

            if (!var8_14.startsWith("AES")) ** GOTO lbl81
            v13 = this;
            var16_26 = v14;
            v15 = this;
            v16 = v15;
            var17_27 = v15.maxTranceiveLengthForSecureMessaging;
            var18_28 = v16.shouldCheckMAC;
            v14 = new AESSecureMessagingWrapper((SecretKey)var5_10, (SecretKey)var11_17, var17_27, var18_28, var14_22);
            v13.wrapper = var16_26;
            break block34;
lbl81:
            // 1 sources

            PACEProtocol.LOGGER.warning("Unsupported cipher algorithm " + var8_14);
        }
        if (PACEInfo.MappingType.CAM.equals((Object)var6_12)) {
            if (var12_19 == null) {
                PACEProtocol.LOGGER.warning("Encrypted Chip Authentication data is null");
            }
            v17 = Cipher.getInstance("AES/CBC/NoPadding");
            v18 = var5_10;
            var5_10 = v19;
            try {
                v19 = new IvParameterSpec(PACEProtocol.IV_FOR_PACE_CAM_DECRYPTION);
                v17.init(2, (Key)v18, (AlgorithmParameterSpec)var5_10);
                var13_20 = Util.unpad(v17.doFinal(var12_19));
            }
            catch (GeneralSecurityException var5_11) {
                PACEProtocol.LOGGER.log(Level.WARNING, "Could not decrypt Chip Authentication data", var5_11);
            }
            this = this.wrapper;
            return new PACECAMResult(var1_6, var7_13, var8_14, var9_15, var10_16, (PACEMappingResult)var2_7 /* !! */ , (KeyPair)var4_9, (PublicKey)var3_8, var12_19, var13_20, (SecureMessagingWrapper)this);
        }
        this = this.wrapper;
        return new PACEResult(var1_6, var6_12, var7_13, var8_14, var9_15, var10_16, (PACEMappingResult)var2_7 /* !! */ , (KeyPair)var4_9, (PublicKey)var3_8, (SecureMessagingWrapper)this);
        catch (GeneralSecurityException var0_2) {
            throw new CardServiceProtocolException("Security exception during secure messaging key derivation", 3, var0_2);
        }
        catch (Exception var0_3) {
            throw new CardServiceProtocolException("PCD side error in static PACE key derivation step", 0, var0_3);
        }
        catch (CardServiceException var0_4) {
            throw new CardServiceProtocolException("PICC side error in static PACE key derivation step", 0, var0_4);
        }
        catch (GeneralSecurityException var0_5) {
            throw new CardServiceProtocolException("PCD side error in static cipher construction during key derivation step", 0, var0_5);
        }
    }

    public static SecretKey deriveStaticPACEKey(AccessKeySpec accessKeySpec, String string2) {
        AccessKeySpec accessKeySpec2 = accessKeySpec;
        String string3 = string2;
        string2 = PACEInfo.toCipherAlgorithm(string3);
        int n = PACEInfo.toKeyLength(string3);
        byte[] byArray = PACEProtocol.computeKeySeedForPACE(accessKeySpec2);
        byte by = 0;
        if (accessKeySpec2 instanceof PACEKeySpec) {
            by = ((PACEKeySpec)accessKeySpec).getKeyReference();
        }
        return Util.deriveKey(byArray, string2, n, null, 3, by);
    }

    public static byte[] computeKeySeedForPACE(AccessKeySpec object) {
        if (object != null) {
            if (object instanceof BACKeySpec) {
                object = (BACKeySpec)object;
                String string2 = object.getDocumentNumber();
                String string3 = object.getDateOfBirth();
                object = object.getDateOfExpiry();
                if (string3 != null && string3.length() == 6) {
                    if (object != null && ((String)object).length() == 6) {
                        if (string2 != null) {
                            return PACEProtocol.computeKeySeedForPACE(PACEProtocol.fixDocumentNumber(string2), string3, (String)object);
                        }
                        throw new IllegalArgumentException(i.a("Wrong document number. Found ", string2));
                    }
                    throw new IllegalArgumentException(i.a("Wrong date format used for date of expiry. Expected yyMMdd, found ", (String)object));
                }
                throw new IllegalArgumentException(i.a("Wrong date format used for date of birth. Expected yyMMdd, found ", string3));
            }
            if (object instanceof PACEKeySpec) {
                return ((PACEKeySpec)object).getKey();
            }
            LOGGER.warning("JMRTD doesn't recognize this type of access key, best effort key derivation!");
            return object.getKey();
        }
        throw new IllegalArgumentException("Access key cannot be null");
    }

    public static ECParameterSpec mapNonceGMWithECDH(byte[] object, java.security.spec.ECPoint object2, ECParameterSpec object3) {
        ECFieldFp eCFieldFp;
        EllipticCurve ellipticCurve;
        byte[] byArray = object;
        ECParameterSpec eCParameterSpec = object3;
        object = eCParameterSpec.getGenerator();
        EllipticCurve ellipticCurve2 = eCParameterSpec.getCurve();
        BigInteger bigInteger = ellipticCurve2.getA();
        BigInteger bigInteger2 = ellipticCurve2.getB();
        BigInteger bigInteger3 = ((ECFieldFp)ellipticCurve2.getField()).getP();
        BigInteger bigInteger4 = eCParameterSpec.getOrder();
        int n = eCParameterSpec.getCofactor();
        java.security.spec.ECPoint eCPoint = Util.add(Util.multiply(Util.os2i(byArray), (java.security.spec.ECPoint)object, (ECParameterSpec)object3), (java.security.spec.ECPoint)object2, (ECParameterSpec)object3);
        object = eCPoint;
        if (!Util.toBouncyCastleECPoint(eCPoint, (ECParameterSpec)object3).isValid()) {
            LOGGER.info("ephemeralGenerator is not a valid point");
        }
        object2 = ellipticCurve;
        object3 = eCFieldFp;
        eCFieldFp = new ECFieldFp(bigInteger3);
        ellipticCurve = new EllipticCurve((ECField)object3, bigInteger, bigInteger2);
        return new ECParameterSpec((EllipticCurve)object2, (java.security.spec.ECPoint)object, bigInteger4, n);
    }

    public static DHParameterSpec mapNonceGMWithDH(byte[] object, BigInteger bigInteger, DHParameterSpec dHParameterSpec) {
        DHParameterSpec dHParameterSpec2 = dHParameterSpec;
        BigInteger bigInteger2 = dHParameterSpec2.getP();
        object = dHParameterSpec2.getG().modPow(Util.os2i(object), bigInteger2).multiply(bigInteger).mod(bigInteger2);
        return new DHParameterSpec(bigInteger2, (BigInteger)object, dHParameterSpec.getL());
    }

    public static AlgorithmParameterSpec mapNonceIMWithECDH(byte[] object, byte[] object2, String object3, ECParameterSpec eCParameterSpec) {
        byte[] byArray = object;
        byte[] byArray2 = object2;
        ECParameterSpec eCParameterSpec2 = eCParameterSpec;
        object = Util.getPrime(eCParameterSpec2);
        object2 = eCParameterSpec2.getOrder();
        int n = eCParameterSpec2.getCofactor();
        BigInteger bigInteger = eCParameterSpec2.getCurve().getA();
        BigInteger bigInteger2 = eCParameterSpec2.getCurve().getB();
        object3 = PACEProtocol.icartPointEncode(Util.os2i(PACEProtocol.pseudoRandomFunction(byArray, byArray2, (BigInteger)object, (String)object3)), eCParameterSpec);
        return new ECParameterSpec(new EllipticCurve(new ECFieldFp((BigInteger)object), bigInteger, bigInteger2), (java.security.spec.ECPoint)object3, (BigInteger)object2, n);
    }

    public static AlgorithmParameterSpec mapNonceIMWithDH(byte[] object, byte[] byArray, String string2, DHParameterSpec dHParameterSpec) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = dHParameterSpec.getG();
        if (bigInteger2 != null && !bigInteger2.equals(bigInteger = BigInteger.ONE)) {
            DHParameterSpec dHParameterSpec2 = dHParameterSpec;
            bigInteger2 = dHParameterSpec2.getP();
            BigInteger bigInteger3 = dHParameterSpec2 instanceof PACEInfo.DHCParameterSpec ? ((PACEInfo.DHCParameterSpec)dHParameterSpec).getQ() : bigInteger;
            object = Util.os2i(PACEProtocol.pseudoRandomFunction(object, byArray, bigInteger2, string2)).modPow(bigInteger2.subtract(bigInteger).divide(bigInteger3), bigInteger2);
            return new DHParameterSpec(bigInteger2, (BigInteger)object, dHParameterSpec.getL());
        }
        throw new IllegalArgumentException("Invalid generator: " + bigInteger2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] pseudoRandomFunction(byte[] byArray, byte[] object, BigInteger bigInteger, String string2) {
        Throwable throwable2222222;
        block16: {
            Object object2;
            ByteArrayOutputStream byteArrayOutputStream;
            SecretKeySpec secretKeySpec;
            IvParameterSpec ivParameterSpec;
            byte[] byArray2;
            byte[] byArray3;
            if (byArray == null) throw new IllegalArgumentException("Null nonce");
            if (object == null) throw new IllegalArgumentException("Null nonce");
            int n = byArray.length * 8;
            int n2 = ((byte[])object).length * 8;
            if (n != 128) {
                if (n != 192) {
                    if (n != 256) throw new IllegalArgumentException(f.a("Unknown length ", n, ", was expecting 128, 192, or 256"));
                }
                byArray3 = C0_LENGTH_256;
                byArray2 = C1_LENGTH_256;
            } else {
                byArray3 = C0_LENGTH_128;
                byArray2 = C1_LENGTH_128;
            }
            String string3 = string2;
            Object object3 = b.a(string3);
            Object object4 = string3.endsWith("/CBC/NoPadding") ? "" : "/CBC/NoPadding";
            Object object5 = object3 = Cipher.getInstance(((StringBuilder)object3).append((String)object4).toString());
            int n3 = ((Cipher)object5).getBlockSize();
            object4 = ivParameterSpec;
            ivParameterSpec = new IvParameterSpec(new byte[n3]);
            Object object6 = secretKeySpec;
            secretKeySpec = new SecretKeySpec((byte[])object, string2);
            ((Cipher)object5).init(1, (Key)object6, (AlgorithmParameterSpec)object4);
            object6 = ((Cipher)object3).doFinal(byArray);
            object = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            int n4 = 0;
            while (true) {
                if (n4 * n >= bigInteger.bitLength() + 64) break;
                Object object7 = object;
                Object object8 = object3;
                byte[] byArray4 = byArray2;
                Object object9 = object3;
                byte[] byArray5 = byArray3;
                Object object10 = object3;
                int n5 = 1;
                int n6 = 0;
                {
                    byte[] byArray6;
                    Object object11;
                    catch (Throwable throwable2222222) {
                        break block16;
                    }
                    catch (Exception exception) {}
                    {
                        Object object12 = object;
                        object11 = object12;
                        LOGGER.log(Level.WARNING, "Could not write to stream", exception);
                        byArray6 = Util.i2os(Util.os2i(((ByteArrayOutputStream)object12).toByteArray()).mod(bigInteger));
                    }
                    try {
                        ((ByteArrayOutputStream)object11).close();
                        return byArray6;
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.FINE, "Could not close stream", iOException);
                    }
                    return byArray6;
                }
                {
                    ((Cipher)object10).init(n5, (Key)new SecretKeySpec((byte[])object6, n6, n2 / 8, string2), (AlgorithmParameterSpec)object4);
                    object6 = ((Cipher)object9).doFinal(byArray5);
                    ((OutputStream)object7).write(((Cipher)object8).doFinal(byArray4));
                    ++n4;
                    continue;
                }
                break;
            }
            {
                Object object13 = object;
                object2 = object13;
                object6 = Util.i2os(Util.os2i(((ByteArrayOutputStream)object13).toByteArray()).mod(bigInteger));
            }
            try {
                ((ByteArrayOutputStream)object2).close();
                return object6;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, "Could not close stream", iOException);
            }
            return object6;
        }
        try {
            ((ByteArrayOutputStream)object).close();
            throw throwable2222222;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Could not close stream", iOException);
        }
        throw throwable2222222;
    }

    public static java.security.spec.ECPoint icartPointEncode(BigInteger object, ECParameterSpec eCParameterSpec) {
        BigInteger bigInteger = Util.getPrime(eCParameterSpec);
        if (BigInteger.valueOf(3L).equals(bigInteger.mod(BigInteger.valueOf(4L)))) {
            ECParameterSpec eCParameterSpec2 = eCParameterSpec;
            int n = eCParameterSpec2.getCofactor();
            Object object2 = eCParameterSpec2.getCurve().getA();
            BigInteger bigInteger2 = eCParameterSpec2.getCurve().getB();
            BigInteger bigInteger3 = ((BigInteger)object).modPow(BigInteger.valueOf(2L), bigInteger).negate().mod(bigInteger);
            BigInteger bigInteger4 = bigInteger3.add(bigInteger3.modPow(BigInteger.valueOf(2L), bigInteger)).mod(bigInteger);
            BigInteger bigInteger5 = BigInteger.ONE;
            BigInteger bigInteger6 = bigInteger5.add(bigInteger4);
            BigInteger bigInteger7 = bigInteger.subtract(bigInteger5).subtract(bigInteger5);
            bigInteger4 = bigInteger2.negate().multiply(bigInteger6).multiply(((BigInteger)object2).multiply(bigInteger4).modPow(bigInteger7, bigInteger)).mod(bigInteger);
            bigInteger3 = bigInteger3.multiply(bigInteger4).mod(bigInteger);
            object2 = bigInteger4.modPow(BigInteger.valueOf(3L), bigInteger).add(((BigInteger)object2).multiply(bigInteger4)).add(bigInteger2).mod(bigInteger);
            object = ((BigInteger)object).modPow(BigInteger.valueOf(3L), bigInteger).multiply((BigInteger)object2).mod(bigInteger);
            bigInteger2 = bigInteger.add(bigInteger5).multiply(BigInteger.valueOf(4L).modInverse(bigInteger)).mod(bigInteger);
            bigInteger2 = ((BigInteger)object2).modPow(bigInteger.subtract(bigInteger5).subtract(bigInteger2), bigInteger);
            if (bigInteger2.modPow(BigInteger.valueOf(2L), bigInteger).multiply((BigInteger)object2).mod(bigInteger).equals(bigInteger5)) {
                java.security.spec.ECPoint eCPoint;
                object = eCPoint;
                eCPoint = new java.security.spec.ECPoint(bigInteger4, bigInteger2.multiply((BigInteger)object2).mod(bigInteger));
            } else {
                java.security.spec.ECPoint eCPoint;
                object2 = eCPoint;
                eCPoint = new java.security.spec.ECPoint(bigInteger3, bigInteger2.multiply((BigInteger)object).mod(bigInteger));
                object = object2;
            }
            if (n == 1) {
                return Util.normalize((java.security.spec.ECPoint)object, eCParameterSpec);
            }
            ECPoint eCPoint = Util.toBouncyCastleECPoint((java.security.spec.ECPoint)object, eCParameterSpec);
            eCPoint.multiply(BigInteger.valueOf(n));
            return Util.fromBouncyCastleECPoint(eCPoint);
        }
        throw new InvalidParameterException("Cannot encode point because p != 3 (mod 4)");
    }

    public static PublicKey updateParameterSpec(PublicKey serializable, PrivateKey object) {
        Object object2 = serializable.getAlgorithm();
        String string2 = object.getAlgorithm();
        if (!"EC".equals(object2) && !"ECDH".equals(object2)) {
            if ("DH".equals(object2)) {
                if ("DH".equals(string2)) {
                    serializable = (DHPublicKey)serializable;
                    Object object3 = object = ((DHPrivateKey)object).getParams();
                    serializable = serializable.getY();
                    object = ((DHParameterSpec)object3).getP();
                    object2 = ((DHParameterSpec)object3).getG();
                    return KeyFactory.getInstance("DH").generatePublic(new DHPublicKeySpec((BigInteger)serializable, (BigInteger)object, (BigInteger)object2));
                }
                throw new NoSuchAlgorithmException("Unsupported key type public: " + (String)object2 + ", private: " + string2);
            }
            throw new NoSuchAlgorithmException("Unsupported key type public: " + (String)object2 + ", private: " + string2);
        }
        if (!"EC".equals(string2) && !"ECDH".equals(string2)) {
            throw new NoSuchAlgorithmException("Unsupported key type public: " + (String)object2 + ", private: " + string2);
        }
        return KeyFactory.getInstance("EC", BC_PROVIDER).generatePublic(new ECPublicKeySpec(((ECPublicKey)serializable).getW(), ((ECPrivateKey)object).getParams()));
    }

    public static byte[] generateAuthenticationToken(String string2, SecretKey secretKey, PublicKey publicKey) {
        String string3 = string2;
        return PACEProtocol.generateAuthenticationToken(string3, Util.getMac(PACEProtocol.inferMACAlgorithmFromCipherAlgorithm(PACEInfo.toCipherAlgorithm(string3)), secretKey), publicKey);
    }

    public static byte[] computeKeySeedForPACE(String string2) {
        return Util.computeKeySeed(string2, "SHA-1", false);
    }

    public static byte[] encodePublicKeyDataObject(String string2, PublicKey publicKey) {
        return PACEProtocol.encodePublicKeyDataObject(string2, publicKey, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encodePublicKeyDataObject(String object, PublicKey object2, boolean bl) {
        Throwable throwable222222;
        TLVOutputStream tLVOutputStream;
        block16: {
            block15: {
                TLVOutputStream tLVOutputStream2;
                ByteArrayOutputStream byteArrayOutputStream;
                ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
                byteArrayOutputStream = new ByteArrayOutputStream();
                tLVOutputStream = tLVOutputStream2;
                new TLVOutputStream(byteArrayOutputStream2).writeTag(32585);
                if (object2 instanceof DHPublicKey) {
                    boolean bl2 = bl;
                    DHPublicKey dHPublicKey = (DHPublicKey)object2;
                    DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
                    object2 = dHParameterSpec.getP();
                    bl = dHParameterSpec.getL();
                    BigInteger bigInteger = dHParameterSpec.getG();
                    BigInteger bigInteger2 = dHPublicKey.getY();
                    tLVOutputStream.write(new ASN1ObjectIdentifier((String)object).getEncoded());
                    if (!bl2) {
                        TLVOutputStream tLVOutputStream3 = tLVOutputStream;
                        TLVOutputStream tLVOutputStream4 = tLVOutputStream;
                        tLVOutputStream.writeTag(129);
                        tLVOutputStream4.writeValue(Util.i2os((BigInteger)object2));
                        tLVOutputStream4.writeTag(130);
                        tLVOutputStream3.writeValue(Util.i2os(BigInteger.valueOf((long)bl)));
                        tLVOutputStream3.writeTag(131);
                        tLVOutputStream.writeValue(Util.i2os(bigInteger));
                    }
                    tLVOutputStream.writeTag(132);
                    tLVOutputStream.writeValue(Util.i2os(bigInteger2));
                } else {
                    if (!(object2 instanceof ECPublicKey)) break block15;
                    ECPublicKey eCPublicKey = (ECPublicKey)object2;
                    object2 = eCPublicKey.getParams();
                    BigInteger bigInteger = Util.getPrime((AlgorithmParameterSpec)object2);
                    EllipticCurve ellipticCurve = ((ECParameterSpec)object2).getCurve();
                    BigInteger bigInteger3 = ellipticCurve.getA();
                    BigInteger bigInteger4 = ellipticCurve.getB();
                    java.security.spec.ECPoint eCPoint = ((ECParameterSpec)object2).getGenerator();
                    BigInteger bigInteger5 = ((ECParameterSpec)object2).getOrder();
                    int n = ((ECParameterSpec)object2).getCofactor();
                    java.security.spec.ECPoint eCPoint2 = eCPublicKey.getW();
                    tLVOutputStream.write(new ASN1ObjectIdentifier((String)object).getEncoded());
                    if (!bl) {
                        TLVOutputStream tLVOutputStream5 = tLVOutputStream;
                        java.security.spec.ECPoint eCPoint3 = eCPoint;
                        TLVOutputStream tLVOutputStream6 = tLVOutputStream;
                        TLVOutputStream tLVOutputStream7 = tLVOutputStream;
                        tLVOutputStream.writeTag(129);
                        tLVOutputStream7.writeValue(Util.i2os(bigInteger));
                        tLVOutputStream7.writeTag(130);
                        tLVOutputStream6.writeValue(Util.i2os(bigInteger3));
                        tLVOutputStream6.writeTag(131);
                        tLVOutputStream.writeValue(Util.i2os(bigInteger4));
                        object = eCPoint3.getAffineX();
                        bigInteger = eCPoint3.getAffineY();
                        tLVOutputStream5.writeTag(132);
                        tLVOutputStream5.write(Util.i2os((BigInteger)object));
                        tLVOutputStream5.write(Util.i2os(bigInteger));
                        tLVOutputStream5.writeValueEnd();
                        tLVOutputStream5.writeTag(133);
                        tLVOutputStream.writeValue(Util.i2os(bigInteger5));
                    }
                    tLVOutputStream.writeTag(134);
                    tLVOutputStream.writeValue(Util.ecPoint2OS(eCPoint2, ((ECParameterSpec)object2).getCurve().getField().getFieldSize()));
                    if (!bl) {
                        tLVOutputStream.writeTag(135);
                        tLVOutputStream.writeValue(Util.i2os(BigInteger.valueOf(n)));
                    }
                }
                TLVOutputStream tLVOutputStream8 = tLVOutputStream;
                TLVOutputStream tLVOutputStream9 = tLVOutputStream8;
                tLVOutputStream8.writeValueEnd();
                tLVOutputStream8.flush();
                try {
                    tLVOutputStream9.close();
                    return byteArrayOutputStream2.toByteArray();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "Error closing stream", iOException);
                }
                return byteArrayOutputStream2.toByteArray();
            }
            try {
                throw new InvalidKeyException("Unsupported public key: " + object2.getClass().getCanonicalName());
            }
            catch (Throwable throwable222222) {
                break block16;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Exception", iOException);
                throw new IllegalStateException("Error in encoding public key");
            }
        }
        try {
            tLVOutputStream.close();
            throw throwable222222;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error closing stream", iOException);
        }
        throw throwable222222;
    }

    public static byte[] encodePublicKeyForSmartCard(PublicKey publicKey) {
        if (publicKey != null) {
            if (publicKey instanceof ECPublicKey) {
                ByteArrayOutputStream byteArrayOutputStream;
                publicKey = (ECPublicKey)publicKey;
                ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
                try {
                    byteArrayOutputStream2();
                    byteArrayOutputStream.write(Util.ecPoint2OS(publicKey.getW(), publicKey.getParams().getCurve().getField().getFieldSize()));
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream2.close();
                    return byArray;
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Internal error writing to memory", iOException);
                }
            }
            if (publicKey instanceof DHPublicKey) {
                return Util.i2os(((DHPublicKey)publicKey).getY());
            }
            throw new InvalidKeyException(b.a("Unsupported public key: ").append(publicKey.getClass().getCanonicalName()).toString());
        }
        throw new IllegalArgumentException("Cannot encode null public key");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PublicKey decodePublicKeyFromSmartCard(byte[] object, AlgorithmParameterSpec algorithmParameterSpec) {
        AlgorithmParameterSpec algorithmParameterSpec2;
        if (algorithmParameterSpec2 == null) {
            throw new IllegalArgumentException("Params cannot be null");
        }
        try {
            if (algorithmParameterSpec2 instanceof ECParameterSpec) {
                java.security.spec.ECPoint eCPoint = Util.os2ECPoint(object);
                algorithmParameterSpec2 = (ECParameterSpec)algorithmParameterSpec2;
                return Util.getPublicKey("EC", new ECPublicKeySpec(eCPoint, (ECParameterSpec)algorithmParameterSpec2));
            }
            if (algorithmParameterSpec2 instanceof DHParameterSpec) {
                BigInteger bigInteger = Util.os2i(object);
                AlgorithmParameterSpec algorithmParameterSpec3 = algorithmParameterSpec2 = (DHParameterSpec)algorithmParameterSpec2;
                BigInteger bigInteger2 = ((DHParameterSpec)algorithmParameterSpec3).getP();
                return Util.getPublicKey("DH", new DHPublicKeySpec(bigInteger, bigInteger2, ((DHParameterSpec)algorithmParameterSpec3).getG()));
            }
            throw new IllegalArgumentException("Expected ECParameterSpec or DHParameterSpec, found " + algorithmParameterSpec2.getClass().getCanonicalName());
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOGGER.log(Level.WARNING, "Exception", generalSecurityException);
            throw new IllegalArgumentException(generalSecurityException);
        }
    }

    private static byte[] generateAuthenticationToken(String object, Mac object2, PublicKey publicKey) {
        object = ((Mac)object2).doFinal(PACEProtocol.encodePublicKeyDataObject((String)object, publicKey));
        byte[] byArray = new byte[8];
        object2 = byArray;
        System.arraycopy(object, 0, object2, 0, 8);
        return byArray;
    }

    private static String fixDocumentNumber(String string2) {
        StringBuilder stringBuilder;
        string2 = string2.replace('<', ' ').trim().replace(' ', '<');
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string2);
        while (stringBuilder2.length() < 9) {
            stringBuilder2.append('<');
        }
        return stringBuilder2.toString();
    }

    private static byte[] computeKeySeedForPACE(String string2, String string3, String string4) {
        return Util.computeKeySeed(string2, string3, string4, "SHA-1", false);
    }

    private void checkConsistency(String string2, String string3, String string4, int n, AlgorithmParameterSpec algorithmParameterSpec) {
        if (string2 != null) {
            if (!"ECDH".equalsIgnoreCase(string2) && !"DH".equalsIgnoreCase(string2)) {
                throw new IllegalArgumentException(g.a("Unsupported agreement algorithm, expected \"ECDH\" or \"DH\", found \"", string2, "\""));
            }
            if (string3 != null) {
                if (!"DESede".equalsIgnoreCase(string3) && !"AES".equalsIgnoreCase(string3)) {
                    throw new IllegalArgumentException(g.a("Unsupported cipher algorithm, expected \"DESede\" or \"AES\", found \"", string3, "\""));
                }
                if (!("SHA-1".equalsIgnoreCase(string4) || "SHA1".equalsIgnoreCase(string4) || "SHA-256".equalsIgnoreCase(string4) || "SHA256".equalsIgnoreCase(string4))) {
                    throw new IllegalArgumentException(g.a("Unsupported cipher algorithm, expected \"SHA-1\" or \"SHA-256\", found \"", string4, "\""));
                }
                if (n != 128 && n != 192 && n != 256) {
                    throw new IllegalArgumentException(a.a("Unsupported key length, expected 128, 192, or 256, found ", n));
                }
                if ("ECDH".equalsIgnoreCase(string2) && !(algorithmParameterSpec instanceof ECParameterSpec)) {
                    throw new IllegalArgumentException("Expected ECParameterSpec for agreement algorithm \"" + string2 + "\", found " + algorithmParameterSpec.getClass().getCanonicalName());
                }
                if ("DH".equalsIgnoreCase(string2) && !(algorithmParameterSpec instanceof DHParameterSpec)) {
                    throw new IllegalArgumentException("Expected DHParameterSpec for agreement algorithm \"" + string2 + "\", found " + algorithmParameterSpec.getClass().getCanonicalName());
                }
                return;
            }
            throw new IllegalArgumentException("Unknown cipher algorithm");
        }
        throw new IllegalArgumentException("Unknown agreement algorithm");
    }

    private static String inferMACAlgorithmFromCipherAlgorithm(String string2) {
        if (string2 != null) {
            if (string2.startsWith("DESede")) {
                return "ISO9797ALG3WITHISO7816-4PADDING";
            }
            if (string2.startsWith("AES")) {
                return "AESCMAC";
            }
            throw new InvalidAlgorithmParameterException(g.a("Cannot infer MAC algorithm from cipher algorithm \"", string2, "\""));
        }
        throw new IllegalArgumentException("Cannot infer MAC algorithm from cipher algorithm null");
    }

    public PACEResult doPACE(AccessKeySpec accessKeySpec, String string2, AlgorithmParameterSpec algorithmParameterSpec, BigInteger bigInteger) {
        try {
            AccessKeySpec accessKeySpec2 = accessKeySpec;
            return this.doPACE(accessKeySpec2, PACEProtocol.deriveStaticPACEKey(accessKeySpec2, string2), string2, algorithmParameterSpec, bigInteger);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CardServiceProtocolException("PCD side error in key derivation step", 0, generalSecurityException);
        }
    }

    public byte[] doPACEStep1(SecretKey object, Cipher cipher) {
        IvParameterSpec ivParameterSpec;
        Cipher cipher2 = cipher;
        Cipher cipher3 = cipher2;
        Cipher cipher4 = cipher2;
        PACEProtocol pACEProtocol = object2;
        byte[] byArray = new byte[]{};
        Object object2 = TLVUtil.unwrapDO(128, pACEProtocol.service.sendGeneralAuthenticate(((PACEProtocol)object2).wrapper, byArray, 256, false));
        SecretKey secretKey = object;
        object = ivParameterSpec;
        try {
            ivParameterSpec = new IvParameterSpec(new byte[cipher.getBlockSize()]);
            cipher3.init(2, (Key)secretKey, (AlgorithmParameterSpec)object);
            return cipher4.doFinal((byte[])object2);
        }
        catch (CardServiceException cardServiceException) {
            throw new CardServiceProtocolException("PICC side exception in tranceiving nonce step", 1, cardServiceException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CardServiceProtocolException("PCD side exception in tranceiving nonce step", 1, generalSecurityException);
        }
    }

    public PACEMappingResult doPACEStep2(PACEInfo.MappingType mappingType, String string2, AlgorithmParameterSpec algorithmParameterSpec, byte[] byArray, Cipher cipher) {
        int n = 1.$SwitchMap$com$fis$ekyc$nfc$build_in$eidparser$lds$PACEInfo$MappingType[mappingType.ordinal()];
        if (n != 1 && n != 2) {
            if (n == 3) {
                return this.doPACEStep2IM(string2, algorithmParameterSpec, byArray, cipher);
            }
            throw new CardServiceProtocolException("Unsupported mapping type " + (Object)((Object)mappingType), 2);
        }
        return this.doPACEStep2GM(string2, algorithmParameterSpec, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public PACEGMMappingResult doPACEStep2GM(String object, AlgorithmParameterSpec algorithmParameterSpec, byte[] byArray) {
        PACEProtocol pACEProtocol = object3;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance((String)object, BC_PROVIDER);
        keyPairGenerator.initialize(algorithmParameterSpec);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Object object2 = keyPair.getPrivate();
        byte[] byArray2 = TLVUtil.wrapDO(129, PACEProtocol.encodePublicKeyForSmartCard(keyPair.getPublic()));
        PACEProtocol pACEProtocol2 = object3;
        Object object3 = pACEProtocol2.wrapper;
        int n = pACEProtocol2.maxTranceiveLengthForProtocol;
        object3 = PACEProtocol.decodePublicKeyFromSmartCard(TLVUtil.unwrapDO(130, pACEProtocol.service.sendGeneralAuthenticate((APDUWrapper)object3, byArray2, n, false)), algorithmParameterSpec);
        if ("ECDH".equals(object)) {
            PACEGMWithECDHAgreement pACEGMWithECDHAgreement = new PACEGMWithECDHAgreement();
            pACEGMWithECDHAgreement.init((PrivateKey)object2);
            object = pACEGMWithECDHAgreement.doPhase((PublicKey)object3);
            object2 = PACEProtocol.mapNonceGMWithECDH(byArray, (java.security.spec.ECPoint)object, (ECParameterSpec)algorithmParameterSpec);
            return new PACEGMWithECDHMappingResult(algorithmParameterSpec, byArray, (PublicKey)object3, keyPair, (java.security.spec.ECPoint)object, (AlgorithmParameterSpec)object2);
        }
        if (!"DH".equals(object)) throw new IllegalArgumentException("Unsupported parameters for mapping nonce, expected \"ECDH\" / ECParameterSpec or \"DH\" / DHParameterSpec, found \"" + (String)object + "\" /" + algorithmParameterSpec.getClass().getCanonicalName());
        byte[] byArray3 = byArray;
        AlgorithmParameterSpec algorithmParameterSpec2 = algorithmParameterSpec;
        KeyAgreement keyAgreement = KeyAgreement.getInstance((String)object);
        KeyAgreement keyAgreement2 = keyAgreement;
        keyAgreement.init((Key)object2);
        keyAgreement.doPhase((Key)object3, true);
        byte[] byArray4 = keyAgreement2.generateSecret();
        object = byArray4;
        try {
            object2 = Util.os2i(byArray4);
            object2 = PACEProtocol.mapNonceGMWithDH(byArray3, (BigInteger)object2, (DHParameterSpec)algorithmParameterSpec2);
            return new PACEGMWithDHMappingResult(algorithmParameterSpec, byArray, (PublicKey)object3, keyPair, (byte[])object, (AlgorithmParameterSpec)object2);
        }
        catch (Exception exception) {
            throw new CardServiceProtocolException("PCD side error in mapping nonce step", 2, exception);
        }
        catch (CardServiceException cardServiceException) {
            throw new CardServiceProtocolException("PICC side exception in mapping nonce step", 2, cardServiceException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PACEIMMappingResult doPACEStep2IM(String object, AlgorithmParameterSpec algorithmParameterSpec, byte[] byArray, Cipher cipher) {
        Object object2;
        byte[] byArray2;
        try {
            PACEProtocol pACEProtocol = object2;
            byArray2 = new byte[byArray.length];
            pACEProtocol.random.nextBytes(byArray2);
            byte[] byArray3 = TLVUtil.wrapDO(129, byArray2);
            PACEProtocol pACEProtocol2 = object2;
            object2 = pACEProtocol2.wrapper;
            int n = pACEProtocol2.maxTranceiveLengthForProtocol;
            pACEProtocol.service.sendGeneralAuthenticate((APDUWrapper)object2, byArray3, n, false);
        }
        catch (CardServiceException cardServiceException) {
            throw new CardServiceProtocolException("PICC side exception in mapping nonce step", 2, cardServiceException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CardServiceProtocolException("PCD side error in mapping nonce step", 2, generalSecurityException);
        }
        {
            if ("ECDH".equals(object)) {
                object2 = cipher.getAlgorithm();
                object = (ECParameterSpec)algorithmParameterSpec;
                object2 = PACEProtocol.mapNonceIMWithECDH(byArray, byArray2, (String)object2, (ECParameterSpec)object);
                return new PACEIMMappingResult(algorithmParameterSpec, byArray, byArray2, (AlgorithmParameterSpec)object2);
            }
            if ("DH".equals(object)) {
                object2 = cipher.getAlgorithm();
                object = (DHParameterSpec)algorithmParameterSpec;
                object2 = PACEProtocol.mapNonceIMWithDH(byArray, byArray2, (String)object2, (DHParameterSpec)object);
                return new PACEIMMappingResult(algorithmParameterSpec, byArray, byArray2, (AlgorithmParameterSpec)object2);
            }
            throw new IllegalArgumentException("Unsupported parameters for mapping nonce, expected \"ECDH\" / ECParameterSpec or \"DH\" / DHParameterSpec, found \"" + (String)object + "\" /" + algorithmParameterSpec.getClass().getCanonicalName());
        }
    }

    public KeyPair doPACEStep3GenerateKeyPair(String string2, AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string2, BC_PROVIDER);
            keyPairGenerator.initialize(algorithmParameterSpec);
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CardServiceProtocolException("PCD side error during generation of PCD key pair", 3, generalSecurityException);
        }
    }

    public PublicKey doPACEStep3ExchangePublicKeys(PublicKey object, AlgorithmParameterSpec algorithmParameterSpec) {
        block8: {
            PublicKey publicKey = object;
            PACEProtocol pACEProtocol = object2;
            object = TLVUtil.wrapDO(131, PACEProtocol.encodePublicKeyForSmartCard((PublicKey)object));
            APDULevelPACECapable aPDULevelPACECapable = pACEProtocol.service;
            PACEProtocol pACEProtocol2 = object2;
            PACEProtocol pACEProtocol3 = pACEProtocol2;
            Object object2 = pACEProtocol2.wrapper;
            int n = pACEProtocol3.maxTranceiveLengthForProtocol;
            object2 = PACEProtocol.decodePublicKeyFromSmartCard(TLVUtil.unwrapDO(132, aPDULevelPACECapable.sendGeneralAuthenticate((APDUWrapper)object2, (byte[])object, n, false)), algorithmParameterSpec);
            if (publicKey.equals(object2)) break block8;
            return object2;
        }
        try {
            throw new CardServiceProtocolException("PCD's public key and PICC's public key are the same in key agreement step!", 3);
        }
        catch (Exception exception) {
            throw new CardServiceProtocolException("PCD side exception in key agreement step", 3, exception);
        }
        catch (CardServiceException cardServiceException) {
            throw new CardServiceProtocolException("PICC side exception in key agreement step", 3, cardServiceException);
        }
    }

    public byte[] doPACEStep3KeyAgreement(String string2, PrivateKey privateKey, PublicKey publicKey) {
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance(string2, BC_PROVIDER);
        }
        catch (Exception exception) {
            throw new CardServiceProtocolException("PCD side error during key agreement", 3, exception);
        }
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(PACEProtocol.updateParameterSpec(publicKey, privateKey), true);
        return keyAgreement.generateSecret();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] doPACEStep4(String var1_6, PACEInfo.MappingType var2_11, KeyPair var3_12, PublicKey var4_13, SecretKey var5_14) {
        block26: {
            block27: {
                var4_13 = TLVUtil.wrapDO(133, PACEProtocol.generateAuthenticationToken((String)var1_6, var5_14, (PublicKey)var4_13));
                this = this.service.sendGeneralAuthenticate(this.wrapper, (byte[])var4_13, 256, true);
                {
                    catch (Exception var0_5) {
                        throw new CardServiceProtocolException("PCD side exception in authentication token generation step", 4, var0_5);
                    }
                }
                var4_13 = v0;
                v0 = new TLVInputStream(new ByteArrayInputStream((byte[])this));
                var0_1 = v0.readTag();
                if (var0_1 != 134) {
                    PACEProtocol.LOGGER.warning("Was expecting tag 0x86, found: " + Integer.toHexString(var0_1));
                }
                v1 = var1_6;
                v2 = var5_14;
                v3 = var3_12;
                v4 = var4_13;
                v5 = v4;
                v4.readLength();
                this = v5.readValue();
                v6 = PACEProtocol.generateAuthenticationToken((String)v1, v2, v3.getPublic());
                var1_6 = v6;
                if (!Arrays.equals(v6, (byte[])this)) break block26;
                if (var2_11 == PACEInfo.MappingType.CAM) break block27;
                this = null;
                try {
                    var4_13.close();
                    return this;
                }
                catch (IOException var1_7) {
                    PACEProtocol.LOGGER.log(Level.FINE, "Exception closing stream", var1_7);
                }
                return this;
            }
            var0_2 = var4_13.readTag();
            if (var0_2 == 138) ** GOTO lbl41
            PACEProtocol.LOGGER.warning("Was expecting tag 0x8A, found: " + Integer.toHexString(var0_2));
lbl41:
            // 2 sources

            v7 = var4_13;
            v8 = v7;
            v9 = v7;
            v7.readLength();
            this = v9.readValue();
            try {
                v8.close();
                return this;
            }
            catch (IOException var1_8) {
                PACEProtocol.LOGGER.log(Level.FINE, "Exception closing stream", var1_8);
            }
            return this;
        }
        try {
            throw new GeneralSecurityException("PICC authentication token mismatch, expectedPICCToken = " + Hex.bytesToHexString((byte[])var1_6) + ", piccToken = " + Hex.bytesToHexString((byte[])this));
        }
        catch (Throwable var0_3) {
            ** GOTO lbl71
        }
        catch (IOException var0_4) {
            PACEProtocol.LOGGER.log(Level.WARNING, "Could not parse step 4 response", var0_4);
            this = null;
            try {
                var4_13.close();
                return this;
            }
            catch (IOException var1_9) {
                PACEProtocol.LOGGER.log(Level.FINE, "Exception closing stream", var1_9);
            }
            return this;
lbl71:
            // 1 sources

            try {
                var4_13.close();
                throw var0_3;
            }
            catch (IOException var1_10) {
                PACEProtocol.LOGGER.log(Level.FINE, "Exception closing stream", var1_10);
            }
            throw var0_3;
        }
    }
}

