/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.smartcards;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.APDUEvent;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.APDUListener;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.CommandAPDU;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.ResponseAPDU;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CardService {
    public static final int SESSION_STOPPED_STATE = 0;
    public static final int SESSION_STARTED_STATE = 1;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.nfc.build_in.scuba");
    private static final Map<String, String> objectToServiceMap = new HashMap<String, String>();
    private Collection<APDUListener> apduListeners;
    public int state;

    public CardService() {
        HashSet hashSet;
        HashSet hashSet2 = hashSet;
        hashSet = new HashSet();
        v1.apduListeners = hashSet2;
        v1.state = 0;
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public static CardService getInstance(Object object) {
        if (object != null) {
            String string2 = object.getClass().getCanonicalName();
            for (Object object2 : objectToServiceMap.entrySet()) {
                Class<?> clazz = Class.forName(object2.getKey());
                {
                    catch (ClassNotFoundException classNotFoundException) {
                        LOGGER.log(Level.FINEST, "Could not find class, trying next one", classNotFoundException);
                        continue;
                    }
                }
                Object object3 = object;
                object2 = object2.getValue();
                if (!clazz.isInstance(object3)) continue;
                try {
                    return (CardService)Class.forName((String)object2).getConstructor(clazz).newInstance(object);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(exception);
                }
            }
            throw new IllegalArgumentException(g.a("Could not find a CardService for object of class \"", string2, "\""));
        }
        throw new IllegalArgumentException();
    }

    static {
        objectToServiceMap.put("javax.smartcardio.CardTerminal", "com.fis.ekyc.nfc.build_in.scuba.smartcards.TerminalCardService");
        objectToServiceMap.put("sun.security.smartcardio.TerminalImpl", "com.fis.ekyc.nfc.build_in.scuba.smartcards.TerminalCardService");
        objectToServiceMap.put("android.nfc.tech.IsoDep", "com.fis.ekyc.nfc.build_in.scuba.smartcards.IsoDepCardService");
    }

    public void addAPDUListener(APDUListener aPDUListener) {
        Collection<APDUListener> collection = ((CardService)((Object)collection)).apduListeners;
        if (collection != null && aPDUListener != null) {
            collection.add(aPDUListener);
        }
    }

    public void removeAPDUListener(APDUListener aPDUListener) {
        Collection<APDUListener> collection = ((CardService)((Object)collection)).apduListeners;
        if (collection != null) {
            collection.remove(aPDUListener);
        }
    }

    public Collection<APDUListener> getAPDUListeners() {
        return Collections.unmodifiableCollection(this.apduListeners);
    }

    public void notifyExchangedAPDU(APDUEvent aPDUEvent) {
        Collection<APDUListener> collection = ((CardService)((Object)iterator)).apduListeners;
        if (collection != null && !collection.isEmpty()) {
            Iterator<APDUListener> iterator = ((CardService)((Object)iterator)).apduListeners.iterator();
            while (iterator.hasNext()) {
                ((APDUListener)iterator.next()).exchangedAPDU(aPDUEvent);
            }
            return;
        }
    }

    public boolean isExtendedAPDULengthSupported() {
        return false;
    }

    public abstract void open();

    public abstract boolean isOpen();

    public abstract ResponseAPDU transmit(CommandAPDU var1);

    public abstract byte[] getATR();

    public abstract void close();

    public abstract boolean isConnectionLost(Exception var1);
}

