/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.tlv;

import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputState;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TLVInputStream
extends InputStream {
    private static final int MAX_BUFFER_LENGTH = 65535;
    private final InputStream originalInputStream;
    private DataInputStream inputStream;
    private int bufferSize;
    private TLVInputState state;
    private TLVInputState markedState;

    public TLVInputStream(InputStream inputStream) {
        TLVInputState tLVInputState;
        block7: {
            block6: {
                ((TLVInputStream)((Object)tLVInputState2)).bufferSize = 0;
                try {
                    if (inputStream instanceof BufferedInputStream) break block6;
                }
                catch (IOException iOException) {}
                if (!(inputStream instanceof ByteArrayInputStream)) break block7;
            }
            ((TLVInputStream)((Object)tLVInputState2)).bufferSize = inputStream.available();
        }
        ((TLVInputStream)((Object)tLVInputState2)).originalInputStream = inputStream;
        if (inputStream instanceof DataInputStream) {
            inputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream;
            DataInputStream dataInputStream2 = dataInputStream;
            dataInputStream = new DataInputStream(inputStream);
            inputStream = dataInputStream2;
        }
        TLVInputStream tLVInputStream = tLVInputState2;
        tLVInputStream.inputStream = inputStream;
        TLVInputState tLVInputState2 = tLVInputState;
        tLVInputState = new TLVInputState();
        tLVInputStream.state = tLVInputState2;
        tLVInputStream.markedState = null;
    }

    private long skipValue() {
        if (this.state.isAtStartOfTag()) {
            return 0L;
        }
        if (this.state.isAtStartOfLength()) {
            return 0L;
        }
        TLVInputStream tLVInputStream = this;
        return tLVInputStream.skip(tLVInputStream.state.getValueBytesLeft());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readTag() {
        if (!this.state.isAtStartOfTag() && !this.state.isProcessingValue()) {
            throw new IllegalStateException("Not at start of tag");
        }
        int n = this.inputStream.readUnsignedByte();
        int n2 = 1;
        while (true) {
            if (n != 0 && n != 255) {
                if ((n & 0x1F) == 31) {
                    int n3;
                    int n4 = this.inputStream.readUnsignedByte();
                    while (true) {
                        n3 = n4;
                        ++n2;
                        if ((n3 & 0x80) != 128) break;
                        n = n << 8 | n3 & 0x7F;
                        n4 = this.inputStream.readUnsignedByte();
                    }
                    n = n << 8 | n3 & 0x7F;
                }
                this.state.setTagProcessed(n, n2);
                return n;
            }
            n = this.inputStream.readUnsignedByte();
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readLength() {
        int n;
        int n2;
        block6: {
            if (!this.state.isAtStartOfLength()) throw new IllegalStateException("Not at start of length");
            n2 = this.inputStream.readUnsignedByte();
            n = 1;
            if ((n2 & 0x80) == 0) break block6;
            n2 &= 0x7F;
            int n3 = 0;
            int n4 = n3;
            n3 = n;
            n = n4;
            for (int k = 0; k < n2; ++k) {
                int n5 = n;
                n = this.inputStream.readUnsignedByte();
                ++n3;
                n = n5 << 8 | n;
            }
            int n6 = n;
            n = n3;
            n2 = n6;
        }
        this.state.setLengthProcessed(n2, n);
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] readValue() {
        if (!this.state.isProcessingValue()) throw new IllegalStateException("Not yet processing value!");
        int n = this.state.getLength();
        byte[] byArray = new byte[n];
        TLVInputStream tLVInputStream = this;
        tLVInputStream.inputStream.readFully(byArray);
        tLVInputStream.state.updateValueBytesProcessed(n);
        return byArray;
    }

    public void skipToTag(int n) {
        while (true) {
            int n2;
            block5: {
                block7: {
                    block6: {
                        if (this.state.isAtStartOfTag()) break block5;
                        if (!this.state.isAtStartOfLength()) break block6;
                        TLVInputStream tLVInputStream = this;
                        tLVInputStream.readLength();
                        if (!TLVUtil.isPrimitive(tLVInputStream.state.getTag())) break block5;
                        break block7;
                    }
                    if (!TLVUtil.isPrimitive(this.state.getTag())) break block5;
                }
                this.skipValue();
            }
            if ((n2 = this.readTag()) == n) {
                return;
            }
            if (!TLVUtil.isPrimitive(n2)) continue;
            TLVInputStream tLVInputStream = this;
            n2 = tLVInputStream.readLength();
            if ((int)tLVInputStream.skipValue() < n2) break;
        }
    }

    @Override
    public int available() {
        return ((InputStream)this.inputStream).available();
    }

    @Override
    public int read() {
        int n = ((InputStream)this.inputStream).read();
        if (n < 0) {
            return -1;
        }
        this.state.updateValueBytesProcessed(1);
        return n;
    }

    @Override
    public long skip(long l) {
        if (l <= 0L) {
            return 0L;
        }
        l = ((InputStream)this.inputStream).skip(l);
        this.state.updateValueBytesProcessed((int)l);
        return l;
    }

    @Override
    public synchronized void mark(int n) {
        TLVInputStream tLVInputStream = this;
        ((InputStream)tLVInputStream.inputStream).mark(n);
        tLVInputStream.markedState = (TLVInputState)tLVInputStream.state.clone();
    }

    @Override
    public boolean markSupported() {
        return ((InputStream)this.inputStream).markSupported();
    }

    @Override
    public synchronized void reset() {
        if (this.markSupported()) {
            TLVInputStream tLVInputStream = this;
            ((InputStream)tLVInputStream.inputStream).reset();
            tLVInputStream.state = tLVInputStream.markedState;
            tLVInputStream.markedState = null;
            return;
        }
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void close() {
        ((InputStream)this.inputStream).close();
    }

    public String toString() {
        return this.state.toString();
    }
}

