/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.tlv;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import com.fis.ekyc.nfc.build_in.scuba.util.Hex;
import h.a;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Stack;

class TLVOutputState
implements Cloneable {
    private Stack<TLVStruct> state;
    private boolean isAtStartOfTag;
    private boolean isAtStartOfLength;
    private boolean isReadingValue;

    public TLVOutputState() {
        Stack stack;
        Cloneable cloneable = stack;
        stack = new Stack();
        v1.state = cloneable;
        v1.isAtStartOfTag = true;
        v1.isAtStartOfLength = false;
        v1.isReadingValue = false;
    }

    private TLVOutputState(Stack<TLVStruct> stack, boolean bl, boolean bl2, boolean bl3) {
        this.state = stack;
        this.isAtStartOfTag = bl;
        this.isAtStartOfLength = bl2;
        this.isReadingValue = bl3;
    }

    public boolean isAtStartOfTag() {
        return this.isAtStartOfTag;
    }

    public boolean isAtStartOfLength() {
        return this.isAtStartOfLength;
    }

    public boolean isProcessingValue() {
        return this.isReadingValue;
    }

    public int getTag() {
        if (!((AbstractCollection)this.state).isEmpty()) {
            return this.state.peek().getTag();
        }
        throw new IllegalStateException("Tag not yet read.");
    }

    public int getLength() {
        if (!((AbstractCollection)this.state).isEmpty()) {
            int n = this.state.peek().getLength();
            if (n >= 0) {
                return n;
            }
            throw new IllegalStateException("Length not yet knwon.");
        }
        throw new IllegalStateException("Length not yet known.");
    }

    public int getValueBytesProcessed() {
        return this.state.peek().getValueBytesProcessed();
    }

    public int getValueBytesLeft() {
        if (!((AbstractCollection)((TLVOutputState)cloneable).state).isEmpty()) {
            Cloneable cloneable = ((TLVOutputState)cloneable).state.peek();
            return ((TLVStruct)cloneable).getLength() - ((TLVStruct)cloneable).getValueBytesProcessed();
        }
        throw new IllegalStateException("Length of value is unknown.");
    }

    public void setTagProcessed(int n) {
        TLVStruct tLVStruct;
        TLVStruct tLVStruct2 = tLVStruct;
        tLVStruct = new TLVStruct(n);
        if (!((AbstractCollection)this.state).isEmpty()) {
            byte[] byArray = TLVUtil.getTagAsBytes(n);
            this.state.peek().write(byArray, 0, byArray.length);
        }
        this.state.push(tLVStruct2);
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = true;
        this.isReadingValue = false;
    }

    public void setDummyLengthProcessed() {
        TLVOutputState tLVOutputState = this;
        tLVOutputState.isAtStartOfTag = false;
        tLVOutputState.isAtStartOfLength = false;
        tLVOutputState.isReadingValue = true;
    }

    public boolean isDummyLengthSet() {
        if (((AbstractCollection)this.state).isEmpty()) {
            return false;
        }
        return this.state.peek().isLengthSet() ^ true;
    }

    public void setLengthProcessed(int n) {
        if (n >= 0) {
            TLVOutputState tLVOutputState = this;
            TLVStruct tLVStruct = tLVOutputState.state.pop();
            if (!((AbstractCollection)tLVOutputState.state).isEmpty()) {
                byte[] byArray = TLVUtil.getLengthAsBytes(n);
                this.state.peek().write(byArray, 0, byArray.length);
            }
            tLVStruct.setLength(n);
            this.state.push(tLVStruct);
            this.isAtStartOfTag = false;
            this.isAtStartOfLength = false;
            this.isReadingValue = true;
            return;
        }
        throw new IllegalArgumentException(f.a("Cannot set negative length (length = ", n, ")."));
    }

    public void updatePreviousLength(int n) {
        if (((AbstractCollection)this.state).isEmpty()) {
            return;
        }
        TLVStruct tLVStruct = this.state.peek();
        if (tLVStruct.isLengthSet && tLVStruct.getLength() == n) {
            return;
        }
        TLVStruct tLVStruct2 = tLVStruct;
        tLVStruct2.setLength(n);
        if (tLVStruct2.getValueBytesProcessed() == tLVStruct.getLength()) {
            this.state.pop();
            byte[] byArray = TLVUtil.getLengthAsBytes(n);
            byte[] byArray2 = tLVStruct.getValue();
            this.updateValueBytesProcessed(byArray, 0, byArray.length);
            this.updateValueBytesProcessed(byArray2, 0, byArray2.length);
            this.isAtStartOfTag = true;
            this.isAtStartOfLength = false;
            this.isReadingValue = false;
        }
    }

    public void updateValueBytesProcessed(byte[] byArray, int n, int n2) {
        if (((AbstractCollection)((TLVOutputState)object).state).isEmpty()) {
            return;
        }
        TLVStruct tLVStruct = ((TLVOutputState)object).state.peek();
        int n3 = tLVStruct.getLength() - tLVStruct.getValueBytesProcessed();
        if (n2 <= n3) {
            TLVStruct tLVStruct2 = tLVStruct;
            tLVStruct2.write(byArray, n, n2);
            if (tLVStruct2.getValueBytesProcessed() == tLVStruct.getLength()) {
                TLVOutputState tLVOutputState = object;
                TLVStruct tLVStruct3 = tLVStruct;
                ((TLVOutputState)object).state.pop();
                Object object = tLVStruct3.getValue();
                int n4 = tLVStruct3.getLength();
                tLVOutputState.updateValueBytesProcessed((byte[])object, 0, n4);
                tLVOutputState.isAtStartOfTag = true;
                tLVOutputState.isAtStartOfLength = false;
                tLVOutputState.isReadingValue = false;
            } else {
                TLVOutputState tLVOutputState = object;
                tLVOutputState.isAtStartOfTag = false;
                tLVOutputState.isAtStartOfLength = false;
                tLVOutputState.isReadingValue = true;
            }
            return;
        }
        throw new IllegalArgumentException("Cannot process " + n2 + " bytes! Only " + n3 + " bytes left in this TLV object " + tLVStruct);
    }

    public byte[] getValue() {
        if (!((AbstractCollection)this.state).isEmpty()) {
            return this.state.peek().getValue();
        }
        throw new IllegalStateException("Cannot get value yet.");
    }

    public Object clone() {
        TLVOutputState tLVOutputState = cloneable;
        Cloneable cloneable = (Stack)((Object)tLVOutputState.state).clone();
        boolean bl = tLVOutputState.isAtStartOfTag;
        boolean bl2 = tLVOutputState.isAtStartOfLength;
        boolean bl3 = tLVOutputState.isReadingValue;
        return new TLVOutputState((Stack<TLVStruct>)cloneable, bl, bl2, bl3);
    }

    public String toString() {
        return ((Object)this.state).toString();
    }

    public boolean canBeWritten() {
        Iterator iterator = ((AbstractCollection)((TLVOutputState)((Object)iterator)).state).iterator();
        while (iterator.hasNext()) {
            if (((TLVStruct)iterator.next()).isLengthSet()) continue;
            return false;
        }
        return true;
    }

    public class TLVStruct
    implements Cloneable {
        private int tag;
        private int length;
        private boolean isLengthSet;
        private ByteArrayOutputStream value;

        public TLVStruct(int n) {
            ByteArrayOutputStream byteArrayOutputStream;
            ((TLVStruct)((Object)byteArrayOutputStream2)).tag = n;
            ((TLVStruct)((Object)byteArrayOutputStream2)).length = Integer.MAX_VALUE;
            ((TLVStruct)((Object)byteArrayOutputStream2)).isLengthSet = false;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            v1.value = byteArrayOutputStream2;
        }

        public void setLength(int n) {
            TLVStruct tLVStruct = this;
            tLVStruct.length = n;
            tLVStruct.isLengthSet = true;
        }

        public int getTag() {
            return this.tag;
        }

        public int getLength() {
            return this.length;
        }

        public boolean isLengthSet() {
            return this.isLengthSet;
        }

        public int getValueBytesProcessed() {
            return this.value.size();
        }

        public byte[] getValue() {
            return this.value.toByteArray();
        }

        public void write(byte[] byArray, int n, int n2) {
            this.value.write(byArray, n, n2);
        }

        public Object clone() {
            ByteArrayOutputStream byteArrayOutputStream;
            TLVStruct tLVStruct;
            TLVStruct tLVStruct2 = tLVStruct;
            TLVStruct tLVStruct3 = this;
            Object object = tLVStruct3.TLVOutputState.this;
            tLVStruct2(tLVStruct3.tag);
            tLVStruct.length = this.length;
            Object object2 = object = byteArrayOutputStream;
            ((ByteArrayOutputStream)object2)();
            tLVStruct2.value = object2;
            try {
                byteArrayOutputStream.write(this.value.toByteArray());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return tLVStruct2;
        }

        public String toString() {
            TLVStruct tLVStruct = object;
            byte[] byArray = tLVStruct.value.toByteArray();
            StringBuilder stringBuilder = b.b.a("[TLVStruct ");
            stringBuilder = a.a(tLVStruct.tag, stringBuilder, ", ");
            Object object = tLVStruct.isLengthSet ? Integer.valueOf(((TLVStruct)object).length) : "UNDEFINED";
            return b.a(stringBuilder.append(object).append(", ").append(Hex.bytesToHexString(byArray)).append("("), byArray.length, ") ]");
        }
    }
}

