/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.liveness;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.liveness.LivenessHandler;
import vn.kalapa.ekyc.liveness.LivenessSession;
import vn.kalapa.ekyc.liveness.LivenessSessionStatus;
import vn.kalapa.ekyc.managers.KLPFaceDetectorListener;
import vn.kalapa.ekyc.utils.Common;

public final class LivenessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long LIVENESS_MAX_TIME = 60000L;
    private static final long PROCESS_INTERVAL = 33L;
    @NotNull
    private final Context context;
    @NotNull
    private final Common.LIVENESS_VERSION livenessSessionType;
    @NotNull
    private final KLPFaceDetectorListener faceDetectorListener;
    private final int rotationAngle;
    @NotNull
    private LivenessSession livenessSession;
    private boolean isStop;
    private long startTime;
    private long lastProcessTime;
    @NotNull
    private LivenessSessionStatus sessionStatus;
    @NotNull
    private String sessionAction;
    @NotNull
    private final LinkedBlockingQueue<Pair<Bitmap, Bitmap>> processingQueue;
    @NotNull
    private final CoroutineScope processingScope;

    public LivenessHandler(@NotNull Context context, @NotNull Common.LIVENESS_VERSION lIVENESS_VERSION, @NotNull KLPFaceDetectorListener kLPFaceDetectorListener, int n) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)lIVENESS_VERSION), (String)"livenessSessionType");
        Intrinsics.checkNotNullParameter((Object)kLPFaceDetectorListener, (String)"faceDetectorListener");
        this.context = context;
        this.livenessSessionType = lIVENESS_VERSION;
        this.faceDetectorListener = kLPFaceDetectorListener;
        this.rotationAngle = n;
        this.livenessSession = new LivenessSession(lIVENESS_VERSION);
        this.startTime = System.currentTimeMillis();
        this.sessionStatus = LivenessSessionStatus.UNVERIFIED;
        this.sessionAction = "";
        this.processingQueue = new LinkedBlockingQueue(2);
        this.processingScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getDefault().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.startProcessingWorker();
    }

    public /* synthetic */ LivenessHandler(Context context, Common.LIVENESS_VERSION lIVENESS_VERSION, KLPFaceDetectorListener kLPFaceDetectorListener, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        this(context, lIVENESS_VERSION, kLPFaceDetectorListener, n);
    }

    private final void startProcessingWorker() {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            public int label;
            private /* synthetic */ Object L$0;
            public final /* synthetic */ LivenessHandler this$0;
            {
                this.this$0 = livenessHandler;
                super(2, continuation);
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block8: {
                    block7: {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        var3_3 = this.label;
                        if (var3_3 != 0) {
                            if (var3_3 != 1) {
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            v0 = var1_1;
                            var1_1 = (CoroutineScope)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)v0);
                                break block7;
                            }
                            catch (Exception v1) {
                                break block8;
                            }
                        }
                        ResultKt.throwOnFailure((Object)var1_1);
                        var1_1 = (CoroutineScope)this.L$0;
                    }
lbl16:
                    // 2 sources

                    while (true) {
                        if (CoroutineScopeKt.isActive((CoroutineScope)var1_1)) ** GOTO lbl-1000
                        return Unit.INSTANCE;
lbl-1000:
                        // 1 sources

                        {
                            var3_4 = (Pair)LivenessHandler.access$getProcessingQueue$p(this.this$0).poll(100L, TimeUnit.MILLISECONDS);
                            if (var3_4 == null) continue;
                        }
                        {
                            var3_4 = (Bitmap)var3_4.component1();
                            v2 = this;
                            v2.L$0 = var1_1;
                            v2.label = 1;
                            if (LivenessHandler.access$processFrameInternal(this.this$0, (Bitmap)var3_4, (Continuation)this) != var2_2) continue;
                            return var2_2;
                        }
                        break;
                    }
                }
                Log.e((String)"LivenessHandler", (String)("Error processing frame: " + v1.getMessage()));
                ** while (true)
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)this.processingScope, null, null, (Function2)function22, (int)3, null);
    }

    private final Object processFrameInternal(Bitmap bitmap, Continuation<? super Unit> continuation) {
        long l;
        ((LivenessHandler)object).lastProcessTime = l = System.currentTimeMillis();
        boolean bl = l - ((LivenessHandler)object).startTime > 60000L;
        if (!(((LivenessHandler)object).isStop || ((LivenessHandler)object).livenessSession.isFinished() || bl)) {
            Object object = BuildersKt.withContext((CoroutineContext)Dispatchers.getDefault(), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((LivenessHandler)object, bitmap, null){
                public int label;
                public final /* synthetic */ LivenessHandler this$0;
                public final /* synthetic */ Bitmap $frame;
                {
                    this.this$0 = livenessHandler;
                    this.$frame = bitmap;
                    super(2, continuation);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    if (this.label == 0) {
                        processFrameInternal.2 v0 = this;
                        ResultKt.throwOnFailure((Object)object);
                        processFrameInternal.2 v1 = this;
                        int n = LivenessHandler.access$getRotationAngle$p(v1.this$0);
                        LivenessHandler.access$getLivenessSession$p(v0.this$0).process(this.$frame, n, LivenessHandler.access$getFaceDetectorListener$p(v1.this$0));
                        LivenessHandler livenessHandler = v0.this$0;
                        LivenessHandler.access$setSessionStatus$p(livenessHandler, LivenessHandler.access$getLivenessSession$p(livenessHandler).getSessionStatus());
                        LivenessHandler livenessHandler2 = v0.this$0;
                        LivenessHandler.access$setSessionAction$p(livenessHandler2, LivenessHandler.access$getLivenessSession$p(livenessHandler2).getCurrentAction());
                        return Unit.INSTANCE;
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                    var v0 = object2;
                    Object object2 = v0.this$0;
                    return new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                    return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                }
            }, continuation);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        ((LivenessHandler)object).handleSessionEnd(bitmap, bl);
        return Unit.INSTANCE;
    }

    private final void handleSessionEnd(Bitmap bitmap, boolean bl) {
        LivenessHandler livenessHandler = this;
        livenessHandler.sessionStatus = livenessHandler.livenessSession.getSessionStatus();
        livenessHandler.sessionAction = livenessHandler.livenessSession.getCurrentAction();
        if (livenessHandler.livenessSession.isFinished() && this.sessionStatus == LivenessSessionStatus.VERIFIED) {
            if (this.livenessSession.getGotTypicalFace()) {
                this.faceDetectorListener.onFaceDetected(this.livenessSession.getTypicalFrame(), this.livenessSession.getTypicalFace());
            }
        } else if (this.livenessSession.isFinished()) {
            KLPFaceDetectorListener.DefaultImpls.onFaceDetected$default(this.faceDetectorListener, bitmap, null, 2, null);
        } else if (this.sessionStatus == LivenessSessionStatus.EXPIRED || bl) {
            this.faceDetectorListener.onExpired();
        }
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getProcessingQueue$p(LivenessHandler livenessHandler) {
        return livenessHandler.processingQueue;
    }

    public static final /* synthetic */ Object access$processFrameInternal(LivenessHandler livenessHandler, Bitmap bitmap, Continuation continuation) {
        return livenessHandler.processFrameInternal(bitmap, (Continuation<? super Unit>)continuation);
    }

    public static final /* synthetic */ LivenessSession access$getLivenessSession$p(LivenessHandler livenessHandler) {
        return livenessHandler.livenessSession;
    }

    public static final /* synthetic */ int access$getRotationAngle$p(LivenessHandler livenessHandler) {
        return livenessHandler.rotationAngle;
    }

    public static final /* synthetic */ KLPFaceDetectorListener access$getFaceDetectorListener$p(LivenessHandler livenessHandler) {
        return livenessHandler.faceDetectorListener;
    }

    public static final /* synthetic */ void access$setSessionStatus$p(LivenessHandler livenessHandler, LivenessSessionStatus livenessSessionStatus) {
        livenessHandler.sessionStatus = livenessSessionStatus;
    }

    public static final /* synthetic */ void access$setSessionAction$p(LivenessHandler livenessHandler, String string2) {
        livenessHandler.sessionAction = string2;
    }

    public final void stop() {
        LivenessHandler livenessHandler = this;
        livenessHandler.isStop = true;
        CoroutineScopeKt.cancel$default((CoroutineScope)livenessHandler.processingScope, null, (int)1, null);
        livenessHandler.processingQueue.clear();
    }

    public final void renewSession() {
        LivenessHandler livenessHandler = this;
        livenessHandler.processingQueue.clear();
        livenessHandler.livenessSession.renewSession(this.livenessSessionType);
        livenessHandler.sessionStatus = livenessHandler.livenessSession.getSessionStatus();
        livenessHandler.startTime = System.currentTimeMillis();
        livenessHandler.lastProcessTime = 0L;
        livenessHandler.isStop = false;
    }

    public final void processSession(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"frame");
        if (System.currentTimeMillis() - this.lastProcessTime < 33L) {
            return;
        }
        if (this.processingQueue.size() < 2) {
            Bitmap bitmap2 = bitmap;
            this.processingQueue.offer((Pair<Bitmap, Bitmap>)TuplesKt.to((Object)bitmap2, (Object)bitmap2));
        }
    }

    public final void release() {
        LivenessHandler livenessHandler = this;
        livenessHandler.livenessSession.cleanup();
        livenessHandler.stop();
        livenessHandler.processingQueue.clear();
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

