/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.utils;

import android.app.Activity;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.util.SizeF;
import android.util.SparseIntArray;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.core.CameraInfo;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vn.kalapa.ekyc.utils.Helpers;

public final class CameraUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final SparseIntArray ORIENTATIONS = new SparseIntArray();

    static {
        ORIENTATIONS.append(0, 0);
        ORIENTATIONS.append(1, 90);
        ORIENTATIONS.append(2, 180);
        ORIENTATIONS.append(3, 270);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final float getCameraFov(@NotNull CameraInfo object) {
            Float f2;
            CameraInfo cameraInfo = object;
            Intrinsics.checkNotNullParameter((Object)cameraInfo, (String)"cameraInfo");
            Companion companion = Camera2CameraInfo.extractCameraCharacteristics((CameraInfo)cameraInfo);
            Intrinsics.checkNotNullExpressionValue((Object)companion, (String)"extractCameraCharacteristics(cameraInfo)");
            float[] fArray = (float[])companion.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
            object = fArray;
            float f3 = fArray != null && (f2 = ArraysKt.maxOrNull((float[])object)) != null ? f2.floatValue() : 0.0f;
            float f4 = object != null && (object = ArraysKt.minOrNull((float[])object)) != null ? ((Float)object).floatValue() : 0.0f;
            companion = (SizeF)companion.get(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE);
            float f5 = companion != null ? companion.getWidth() : 0.0f;
            float f6 = companion != null ? companion.getHeight() : 0.0f;
            Helpers.Companion companion2 = Helpers.Companion;
            companion2.printLog("cameraInfo maxFocalLength " + f3 + " minFocalLength " + f4 + " sensorWidth " + f5 + " sensorHeight " + f6 + " ");
            float f7 = 2;
            f6 = f7 * (float)Math.atan(f5 / (f7 * f3));
            f4 = f6 * (float)180 / 3.14f;
            companion2.printLog("cameraInfo FOV: " + f6 + " " + f4);
            return f4;
        }

        public final int getRotationCompensation(@NotNull String string2, @NotNull Activity activity, boolean bl) {
            Activity activity2 = activity;
            Intrinsics.checkNotNullParameter((Object)string2, (String)"cameraId");
            Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
            int n = ORIENTATIONS.get(activity2.getWindowManager().getDefaultDisplay().getRotation());
            Object object = activity2.getSystemService("camera");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
            Object object2 = ((CameraManager)object).getCameraCharacteristics(string2).get(CameraCharacteristics.SENSOR_ORIENTATION);
            Intrinsics.checkNotNull((Object)object2);
            int n2 = ((Number)object2).intValue();
            return bl ? (n2 + n) % 360 : (n2 - n + 360) % 360;
        }
    }
}

