/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.os.Build;
import android.preference.PreferenceManager;
import java.util.Locale;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocaleHelper {
    @NotNull
    public static final LocaleHelper INSTANCE = new LocaleHelper();
    @NotNull
    private static final String SELECTED_LANGUAGE = "Locale.Helper.Selected.Language";
    @NotNull
    public static final String ENGLISH = "en";
    @NotNull
    public static final String VIETNAMESE = "vi";
    @NotNull
    public static final String KOREAN = "ko";

    private LocaleHelper() {
    }

    private final String getPersistedData(Context context, String string2) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context).getString(SELECTED_LANGUAGE, string2);
    }

    private final void persist(Context context, String string2) {
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)context).edit();
        editor.putString(SELECTED_LANGUAGE, string2);
        editor.apply();
    }

    private final Context updateResources(Context context, String string2) {
        Locale locale;
        Context context2;
        Context context3;
        try {
            Context context4 = context;
            context3 = context4;
            context2 = context4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return context;
        }
        Locale locale2 = locale;
        Locale.setDefault(new Locale(string2));
        Configuration configuration = new Configuration(context.getResources().getConfiguration());
        configuration.setLocale(locale2);
        context3.createConfigurationContext(configuration);
        return context2;
    }

    private final Context updateResourcesLegacy(Context context, String string2) {
        Locale locale;
        Locale locale2 = locale;
        Locale.setDefault(new Locale(string2));
        string2 = context.getResources();
        Configuration configuration = string2.getConfiguration();
        string2.getConfiguration().locale = locale2;
        if (Build.VERSION.SDK_INT >= 17) {
            Configuration configuration2 = configuration;
            configuration2.setLayoutDirection(locale2);
            configuration2.setLocale(locale2);
        }
        String string3 = string2;
        string3.updateConfiguration(configuration, string3.getDisplayMetrics());
        return context;
    }

    @NotNull
    public final Context onAttach(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        String string2 = Locale.getDefault().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDefault().language");
        return this.setLocale(context, this.getPersistedData(context2, string2));
    }

    @NotNull
    public final Context onAttach(@NotNull Context context, @NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"defaultLanguage");
        return this.setLocale(context, this.getPersistedData(context, string3));
    }

    @Nullable
    public final String getLanguage(@NotNull Context context) {
        LocaleHelper localeHelper = string2;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        String string2 = Locale.getDefault().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDefault().language");
        return localeHelper.getPersistedData(context2, string2);
    }

    @NotNull
    public final Context setLocale(@NotNull Context context, @Nullable String string2) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.persist(context2, string2);
        return this.updateResourcesLegacy(context, string2);
    }

    public final void saveLanguage(@NotNull Context context, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"language");
        this.persist(context, string2);
    }
}

