/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Properties;
import java.math.BigInteger;

public class ASN1Integer
extends ASN1Primitive {
    public static final int SIGN_EXT_SIGNED = -1;
    public static final int SIGN_EXT_UNSIGNED = 255;
    private final byte[] bytes;
    private final int start;

    public static ASN1Integer getInstance(Object object) {
        if (object != null && !(object instanceof ASN1Integer)) {
            if (object instanceof byte[]) {
                try {
                    return (ASN1Integer)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(d.a(exception, b.a("encoding error in getInstance: ")));
                }
            }
            throw new IllegalArgumentException(c.a(object, b.a("illegal object in getInstance: ")));
        }
        return (ASN1Integer)object;
    }

    public static ASN1Integer getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        aSN1Primitive = aSN1Primitive.getObject();
        if (!bl && !(aSN1Primitive instanceof ASN1Integer)) {
            return new ASN1Integer(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
        }
        return ASN1Integer.getInstance(aSN1Primitive);
    }

    public ASN1Integer(long l) {
        ASN1Integer aSN1Integer = this;
        aSN1Integer.bytes = BigInteger.valueOf(l).toByteArray();
        aSN1Integer.start = 0;
    }

    public ASN1Integer(BigInteger bigInteger) {
        ASN1Integer aSN1Integer = this;
        aSN1Integer.bytes = bigInteger.toByteArray();
        aSN1Integer.start = 0;
    }

    public ASN1Integer(byte[] byArray) {
        this(byArray, true);
    }

    public ASN1Integer(byte[] byArray, boolean bl) {
        if (!ASN1Integer.isMalformed(byArray)) {
            byte[] byArray2 = bl ? Arrays.clone(byArray) : byArray;
            this.bytes = byArray2;
            this.start = ASN1Integer.signBytesToSkip(byArray);
            return;
        }
        throw new IllegalArgumentException("malformed integer");
    }

    public static int intValue(byte[] byArray, int n, int n2) {
        int n3 = n;
        n = byArray.length;
        int n4 = Math.max(n3, n - 4);
        n2 = byArray[n4] & n2;
        while (++n4 < n) {
            n2 = n2 << 8 | byArray[n4] & 0xFF;
        }
        return n2;
    }

    public static long longValue(byte[] byArray, int n, int n2) {
        int n3 = n;
        n = byArray.length;
        int n4 = Math.max(n3, n - 8);
        long l = byArray[n4] & n2;
        while (++n4 < n) {
            l = l << 8 | (long)(byArray[n4] & 0xFF);
        }
        return l;
    }

    public static boolean isMalformed(byte[] byArray) {
        int n = byArray.length;
        if (n != 0) {
            if (n != 1) {
                return byArray[0] == byArray[1] >> 7 && !Properties.isOverrideSet("com.fis.ekyc.nfc.build_in.bouncycastle.asn1.allow_unsafe_integer");
            }
            return false;
        }
        return true;
    }

    public static int signBytesToSkip(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = byArray.length - 1;
        while (n2 < n3 && byArray[n2] == byArray[n = n2 + 1] >> 7) {
            n2 = n;
        }
        return n2;
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public boolean hasValue(BigInteger bigInteger) {
        return bigInteger != null && ASN1Integer.intValue(this.bytes, this.start, -1) == bigInteger.intValue() && this.getValue().equals(bigInteger);
    }

    public int intPositiveValueExact() {
        byte[] byArray = this.bytes;
        int n = this.start;
        int n2 = this.bytes.length - n;
        if (n2 <= 4 && (n2 != 4 || (byArray[n] & 0x80) == 0)) {
            return ASN1Integer.intValue(byArray, n, 255);
        }
        throw new ArithmeticException("ASN.1 Integer out of positive int range");
    }

    public int intValueExact() {
        byte[] byArray = this.bytes;
        int n = this.start;
        if (this.bytes.length - n <= 4) {
            return ASN1Integer.intValue(byArray, n, -1);
        }
        throw new ArithmeticException("ASN.1 Integer out of int range");
    }

    public long longValueExact() {
        byte[] byArray = this.bytes;
        int n = this.start;
        if (this.bytes.length - n <= 8) {
            return ASN1Integer.longValue(byArray, n, -1);
        }
        throw new ArithmeticException("ASN.1 Integer out of long range");
    }

    @Override
    public boolean isConstructed() {
        return false;
    }

    @Override
    public int encodedLength() {
        return StreamUtil.calculateBodyLength(this.bytes.length) + 1 + this.bytes.length;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        Object object = ((ASN1Integer)object).bytes;
        aSN1OutputStream.writeEncoded(bl, 2, (byte[])object);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Integer)) {
            return false;
        }
        ASN1Integer aSN1Integer = aSN1Integer2;
        ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Primitive;
        return Arrays.areEqual(aSN1Integer.bytes, aSN1Integer2.bytes);
    }

    public String toString() {
        return this.getValue().toString();
    }
}

