/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.RandomGenerator;

public class DigestRandomGenerator
implements RandomGenerator {
    private static long CYCLE_COUNT = 10L;
    private long stateCounter;
    private long seedCounter;
    private Digest digest;
    private byte[] state;
    private byte[] seed;

    public DigestRandomGenerator(Digest digest) {
        DigestRandomGenerator digestRandomGenerator = this;
        DigestRandomGenerator digestRandomGenerator2 = this;
        this.digest = digest;
        digestRandomGenerator2.seed = new byte[digest.getDigestSize()];
        digestRandomGenerator2.seedCounter = 1L;
        digestRandomGenerator.state = new byte[digest.getDigestSize()];
        digestRandomGenerator.stateCounter = 1L;
    }

    private void cycleSeed() {
        DigestRandomGenerator digestRandomGenerator = this;
        digestRandomGenerator.digestUpdate(digestRandomGenerator.seed);
        long l = digestRandomGenerator.seedCounter;
        digestRandomGenerator.seedCounter = l + 1L;
        digestRandomGenerator.digestAddCounter(l);
        digestRandomGenerator.digestDoFinal(digestRandomGenerator.seed);
    }

    private void generateState() {
        DigestRandomGenerator digestRandomGenerator = this;
        long l = digestRandomGenerator.stateCounter;
        digestRandomGenerator.stateCounter = l + 1L;
        digestRandomGenerator.digestAddCounter(l);
        digestRandomGenerator.digestUpdate(digestRandomGenerator.state);
        digestRandomGenerator.digestUpdate(digestRandomGenerator.seed);
        digestRandomGenerator.digestDoFinal(digestRandomGenerator.state);
        if (digestRandomGenerator.stateCounter % CYCLE_COUNT == 0L) {
            this.cycleSeed();
        }
    }

    private void digestAddCounter(long l) {
        for (int k = 0; k != 8; ++k) {
            this.digest.update((byte)l);
            l >>>= 8;
        }
    }

    private void digestUpdate(byte[] byArray) {
        this.digest.update(byArray, 0, byArray.length);
    }

    private void digestDoFinal(byte[] byArray) {
        this.digest.doFinal(byArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSeedMaterial(byte[] byArray) {
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (this) {
            digestRandomGenerator.digestUpdate(byArray);
            digestRandomGenerator.digestUpdate(digestRandomGenerator.seed);
            digestRandomGenerator.digestDoFinal(digestRandomGenerator.seed);
            // ** MonitorExit[v0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSeedMaterial(long l) {
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (this) {
            digestRandomGenerator.digestAddCounter(l);
            digestRandomGenerator.digestUpdate(digestRandomGenerator.seed);
            digestRandomGenerator.digestDoFinal(digestRandomGenerator.seed);
            // ** MonitorExit[v0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void nextBytes(byte[] byArray) {
        int n = byArray.length;
        this.nextBytes(byArray, 0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextBytes(byte[] byArray, int n, int n2) {
        int n3 = n2;
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (digestRandomGenerator) {
            n2 = 0;
            digestRandomGenerator.generateState();
            int n4 = n + n3;
            while (n != n4) {
                block9: {
                    if (n2 != this.state.length) break block9;
                    this.generateState();
                    n2 = 0;
                }
                byte[] byArray2 = byArray;
                int n5 = n++;
                byte[] byArray3 = this.state;
                int n6 = n2++;
                byArray2[n5] = byArray3[n6];
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }
}

