/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf.DHKEKGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DESParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public abstract class BaseAgreementSpi
extends KeyAgreementSpi {
    private static final Map<String, ASN1ObjectIdentifier> defaultOids;
    private static final Map<String, Integer> keySizes;
    private static final Map<String, String> nameTable;
    private static final Hashtable oids;
    private static final Hashtable des;
    public final String kaAlgorithm;
    public final DerivationFunction kdf;
    public byte[] ukmParameters;

    public BaseAgreementSpi(String string, DerivationFunction derivationFunction) {
        this.kaAlgorithm = string;
        this.kdf = derivationFunction;
    }

    public static String getAlgorithm(String string) {
        if (string.indexOf(91) > 0) {
            String string2 = string;
            return string2.substring(0, string2.indexOf(91));
        }
        if (string.startsWith(NISTObjectIdentifiers.aes.getId())) {
            return "AES";
        }
        if (string.startsWith(GNUObjectIdentifiers.Serpent.getId())) {
            return "Serpent";
        }
        String string3 = nameTable.get(Strings.toUpperCase(string));
        if (string3 != null) {
            return string3;
        }
        return string;
    }

    public static int getKeySize(String string) {
        if (string.indexOf(91) > 0) {
            String string2 = string;
            int n = string2.indexOf(91) + 1;
            return Integer.parseInt(string2.substring(n, string2.indexOf(93)));
        }
        Map<String, Integer> map = keySizes;
        if (!map.containsKey(string = Strings.toUpperCase(string))) {
            return -1;
        }
        return map.get(string);
    }

    public static byte[] trimZeroes(byte[] byArray) {
        int n;
        if (byArray[0] != 0) {
            return byArray;
        }
        for (n = 0; n < byArray.length && byArray[n] == 0; ++n) {
        }
        int n2 = byArray.length - n;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    private byte[] getSharedSecretBytes(byte[] byArray, String object, int n) {
        block4: {
            block5: {
                byte[] byArray2;
                int n2;
                block8: {
                    KDFParameters kDFParameters;
                    block6: {
                        block7: {
                            DHKDFParameters dHKDFParameters;
                            ASN1ObjectIdentifier aSN1ObjectIdentifier;
                            BaseAgreementSpi baseAgreementSpi;
                            DerivationFunction derivationFunction = this.kdf;
                            if (derivationFunction == null) break block4;
                            if (n < 0) break block5;
                            n2 = n / 8;
                            byArray2 = new byte[n2];
                            if (!(derivationFunction instanceof DHKEKGenerator)) break block6;
                            if (object == null) break block7;
                            try {
                                baseAgreementSpi = this;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw new NoSuchAlgorithmException(i.a("no OID for algorithm: ", (String)object));
                            }
                            Object object2 = aSN1ObjectIdentifier;
                            aSN1ObjectIdentifier = new ASN1ObjectIdentifier((String)object);
                            object = dHKDFParameters;
                            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = object2;
                            object2 = this.ukmParameters;
                            dHKDFParameters = new DHKDFParameters(aSN1ObjectIdentifier2, n, byArray, (byte[])object2);
                            baseAgreementSpi.kdf.init((DerivationParameters)object);
                            break block8;
                        }
                        throw new NoSuchAlgorithmException("algorithm OID is null");
                    }
                    object = kDFParameters;
                    kDFParameters = new KDFParameters(byArray, this.ukmParameters);
                    this.kdf.init((DerivationParameters)object);
                }
                this.kdf.generateBytes(byArray2, 0, n2);
                Arrays.clear(byArray);
                return byArray2;
            }
            throw new NoSuchAlgorithmException(i.a("unknown algorithm encountered: ", (String)object));
        }
        if (n > 0) {
            int n3 = n / 8;
            byte[] byArray3 = new byte[n3];
            object = byArray3;
            System.arraycopy(byArray, 0, object, 0, n3);
            Arrays.clear(byArray);
            return byArray3;
        }
        return byArray;
    }

    static {
        Hashtable<String, String> hashtable;
        Hashtable<String, Object> hashtable2;
        HashMap<String, String> hashMap;
        HashMap<String, Integer> hashMap2;
        HashMap<String, ASN1ObjectIdentifier> hashMap3;
        Object object = hashMap3;
        defaultOids = new HashMap<String, ASN1ObjectIdentifier>();
        Object object2 = hashMap2;
        keySizes = new HashMap<String, Integer>();
        Object object3 = hashMap;
        nameTable = new HashMap<String, String>();
        Object object4 = hashtable2;
        oids = new Hashtable<String, Object>();
        Object object5 = hashtable;
        Hashtable<String, Object> hashtable3 = object4;
        HashMap<String, String> hashMap4 = object3;
        HashMap<String, ASN1ObjectIdentifier> hashMap5 = object;
        HashMap<String, Integer> hashMap6 = object2;
        Hashtable<String, String> hashtable4 = object5;
        hashtable4();
        des = hashtable4;
        object = Integers.valueOf(64);
        object2 = Integers.valueOf(128);
        object3 = Integers.valueOf(192);
        object4 = Integers.valueOf(256);
        hashMap6.put("DES", (Integer)object);
        hashMap6.put("DESEDE", (Integer)object3);
        hashMap6.put("BLOWFISH", (Integer)object2);
        hashMap6.put("AES", (Integer)object4);
        hashMap6.put(NISTObjectIdentifiers.id_aes128_ECB.getId(), (Integer)object2);
        hashMap6.put(NISTObjectIdentifiers.id_aes192_ECB.getId(), (Integer)object3);
        hashMap6.put(NISTObjectIdentifiers.id_aes256_ECB.getId(), (Integer)object4);
        hashMap6.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), (Integer)object2);
        hashMap6.put(NISTObjectIdentifiers.id_aes192_CBC.getId(), (Integer)object3);
        object5 = NISTObjectIdentifiers.id_aes256_CBC;
        hashMap6.put(((ASN1ObjectIdentifier)object5).getId(), (Integer)object4);
        hashMap6.put(NISTObjectIdentifiers.id_aes128_CFB.getId(), (Integer)object2);
        hashMap6.put(NISTObjectIdentifiers.id_aes192_CFB.getId(), (Integer)object3);
        hashMap6.put(NISTObjectIdentifiers.id_aes256_CFB.getId(), (Integer)object4);
        hashMap6.put(NISTObjectIdentifiers.id_aes128_OFB.getId(), (Integer)object2);
        hashMap6.put(NISTObjectIdentifiers.id_aes192_OFB.getId(), (Integer)object3);
        hashMap6.put(NISTObjectIdentifiers.id_aes256_OFB.getId(), (Integer)object4);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes128_wrap;
        hashMap6.put(aSN1ObjectIdentifier.getId(), (Integer)object2);
        hashMap6.put(NISTObjectIdentifiers.id_aes192_wrap.getId(), (Integer)object3);
        hashMap6.put(NISTObjectIdentifiers.id_aes256_wrap.getId(), (Integer)object4);
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = NISTObjectIdentifiers.id_aes128_CCM;
        hashMap6.put(aSN1ObjectIdentifier2.getId(), (Integer)object2);
        hashMap6.put(NISTObjectIdentifiers.id_aes192_CCM.getId(), (Integer)object3);
        hashMap6.put(NISTObjectIdentifiers.id_aes256_CCM.getId(), (Integer)object4);
        hashMap6.put(NISTObjectIdentifiers.id_aes128_GCM.getId(), (Integer)object2);
        hashMap6.put(NISTObjectIdentifiers.id_aes192_GCM.getId(), (Integer)object3);
        hashMap6.put(NISTObjectIdentifiers.id_aes256_GCM.getId(), (Integer)object4);
        ASN1ObjectIdentifier aSN1ObjectIdentifier3 = NTTObjectIdentifiers.id_camellia128_wrap;
        hashMap6.put(aSN1ObjectIdentifier3.getId(), (Integer)object2);
        ASN1ObjectIdentifier aSN1ObjectIdentifier4 = NTTObjectIdentifiers.id_camellia192_wrap;
        hashMap6.put(aSN1ObjectIdentifier4.getId(), (Integer)object3);
        ASN1ObjectIdentifier aSN1ObjectIdentifier5 = NTTObjectIdentifiers.id_camellia256_wrap;
        hashMap6.put(aSN1ObjectIdentifier5.getId(), (Integer)object4);
        ASN1ObjectIdentifier aSN1ObjectIdentifier6 = KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap;
        hashMap6.put(aSN1ObjectIdentifier6.getId(), (Integer)object2);
        object2 = PKCSObjectIdentifiers.id_alg_CMS3DESwrap;
        hashMap6.put(((ASN1ObjectIdentifier)object2).getId(), (Integer)object3);
        ASN1ObjectIdentifier aSN1ObjectIdentifier7 = PKCSObjectIdentifiers.des_EDE3_CBC;
        hashMap6.put(aSN1ObjectIdentifier7.getId(), (Integer)object3);
        object3 = OIWObjectIdentifiers.desCBC;
        hashMap6.put(((ASN1ObjectIdentifier)object3).getId(), (Integer)object);
        object = CryptoProObjectIdentifiers.gostR28147_gcfb;
        hashMap6.put(((ASN1ObjectIdentifier)object).getId(), (Integer)object4);
        hashMap6.put(CryptoProObjectIdentifiers.id_Gost28147_89_None_KeyWrap.getId(), (Integer)object4);
        hashMap6.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_KeyWrap.getId(), (Integer)object4);
        ASN1ObjectIdentifier aSN1ObjectIdentifier8 = PKCSObjectIdentifiers.id_hmacWithSHA1;
        hashMap6.put(aSN1ObjectIdentifier8.getId(), Integers.valueOf(160));
        ASN1ObjectIdentifier aSN1ObjectIdentifier9 = PKCSObjectIdentifiers.id_hmacWithSHA256;
        hashMap6.put(aSN1ObjectIdentifier9.getId(), (Integer)object4);
        object4 = PKCSObjectIdentifiers.id_hmacWithSHA384;
        hashMap6.put(((ASN1ObjectIdentifier)object4).getId(), Integers.valueOf(384));
        ASN1ObjectIdentifier aSN1ObjectIdentifier10 = PKCSObjectIdentifiers.id_hmacWithSHA512;
        hashMap6.put(aSN1ObjectIdentifier10.getId(), Integers.valueOf(512));
        hashMap5.put("DESEDE", aSN1ObjectIdentifier7);
        hashMap5.put("AES", (ASN1ObjectIdentifier)object5);
        ASN1ObjectIdentifier aSN1ObjectIdentifier11 = NTTObjectIdentifiers.id_camellia256_cbc;
        hashMap5.put("CAMELLIA", aSN1ObjectIdentifier11);
        ASN1ObjectIdentifier aSN1ObjectIdentifier12 = KISAObjectIdentifiers.id_seedCBC;
        hashMap5.put("SEED", aSN1ObjectIdentifier12);
        hashMap5.put("DES", (ASN1ObjectIdentifier)object3);
        hashMap4.put(MiscObjectIdentifiers.cast5CBC.getId(), "CAST5");
        hashMap4.put(MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC.getId(), "IDEA");
        hashMap4.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_ECB.getId(), "Blowfish");
        hashMap4.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC.getId(), "Blowfish");
        hashMap4.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CFB.getId(), "Blowfish");
        hashMap4.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_OFB.getId(), "Blowfish");
        hashMap4.put(OIWObjectIdentifiers.desECB.getId(), "DES");
        hashMap4.put(((ASN1ObjectIdentifier)object3).getId(), "DES");
        hashMap4.put(OIWObjectIdentifiers.desCFB.getId(), "DES");
        hashMap4.put(OIWObjectIdentifiers.desOFB.getId(), "DES");
        hashMap4.put(OIWObjectIdentifiers.desEDE.getId(), "DESede");
        hashMap4.put(aSN1ObjectIdentifier7.getId(), "DESede");
        hashMap4.put(((ASN1ObjectIdentifier)object2).getId(), "DESede");
        hashMap4.put(PKCSObjectIdentifiers.id_alg_CMSRC2wrap.getId(), "RC2");
        hashMap4.put(aSN1ObjectIdentifier8.getId(), "HmacSHA1");
        hashMap4.put(PKCSObjectIdentifiers.id_hmacWithSHA224.getId(), "HmacSHA224");
        hashMap4.put(aSN1ObjectIdentifier9.getId(), "HmacSHA256");
        hashMap4.put(((ASN1ObjectIdentifier)object4).getId(), "HmacSHA384");
        hashMap4.put(aSN1ObjectIdentifier10.getId(), "HmacSHA512");
        hashMap4.put(NTTObjectIdentifiers.id_camellia128_cbc.getId(), "Camellia");
        hashMap4.put(NTTObjectIdentifiers.id_camellia192_cbc.getId(), "Camellia");
        hashMap4.put(aSN1ObjectIdentifier11.getId(), "Camellia");
        hashMap4.put(aSN1ObjectIdentifier3.getId(), "Camellia");
        hashMap4.put(aSN1ObjectIdentifier4.getId(), "Camellia");
        hashMap4.put(aSN1ObjectIdentifier5.getId(), "Camellia");
        hashMap4.put(aSN1ObjectIdentifier6.getId(), "SEED");
        hashMap4.put(aSN1ObjectIdentifier12.getId(), "SEED");
        hashMap4.put(KISAObjectIdentifiers.id_seedMAC.getId(), "SEED");
        hashMap4.put(((ASN1ObjectIdentifier)object).getId(), "GOST28147");
        hashMap4.put(aSN1ObjectIdentifier.getId(), "AES");
        hashMap4.put(aSN1ObjectIdentifier2.getId(), "AES");
        hashMap4.put(aSN1ObjectIdentifier2.getId(), "AES");
        hashtable3.put("DESEDE", aSN1ObjectIdentifier7);
        hashtable3.put("AES", object5);
        hashtable3.put("DES", object3);
        hashtable.put("DES", "DES");
        hashtable.put("DESEDE", "DES");
        hashtable.put(((ASN1ObjectIdentifier)object3).getId(), "DES");
        hashtable.put(aSN1ObjectIdentifier7.getId(), "DES");
        hashtable.put(((ASN1ObjectIdentifier)object2).getId(), "DES");
    }

    @Override
    public byte[] engineGenerateSecret() {
        if (baseAgreementSpi2.kdf != null) {
            int n;
            BaseAgreementSpi baseAgreementSpi = baseAgreementSpi2;
            byte[] byArray = baseAgreementSpi.calcSecret();
            BaseAgreementSpi baseAgreementSpi2 = null;
            try {
                n = byArray.length;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalStateException(noSuchAlgorithmException.getMessage());
            }
            return baseAgreementSpi.getSharedSecretBytes(byArray, (String)((Object)baseAgreementSpi2), n * 8);
        }
        return baseAgreementSpi2.calcSecret();
    }

    @Override
    public int engineGenerateSecret(byte[] byArray, int n) {
        byte[] byArray2 = this.engineGenerateSecret();
        if (byArray.length - n >= byArray2.length) {
            int n2 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n, n2);
            return byArray2.length;
        }
        throw new ShortBufferException(b.a(new StringBuilder().append(this.kaAlgorithm).append(" key agreement: need "), byArray2.length, " bytes"));
    }

    @Override
    public SecretKey engineGenerateSecret(String string) {
        Hashtable hashtable = oids;
        String string2 = Strings.toUpperCase(string);
        string2 = hashtable.containsKey(string2) ? ((ASN1ObjectIdentifier)hashtable.get(string2)).getId() : string;
        BaseAgreementSpi baseAgreementSpi = this;
        int n = BaseAgreementSpi.getKeySize(string2);
        byte[] byArray = baseAgreementSpi.getSharedSecretBytes(baseAgreementSpi.calcSecret(), string2, n);
        if (des.containsKey(string = BaseAgreementSpi.getAlgorithm(string))) {
            DESParameters.setOddParity(byArray);
        }
        return new SecretKeySpec(byArray, string);
    }

    public abstract byte[] calcSecret();
}

