/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748.X25519Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc8032.Ed25519;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public abstract class X25519 {
    public static final int POINT_SIZE = 32;
    public static final int SCALAR_SIZE = 32;
    private static final int C_A = 486662;
    private static final int C_A24 = 121666;

    public static boolean calculateAgreement(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, int n3) {
        X25519.scalarMult(byArray, n, byArray2, n2, byArray3, n3);
        return Arrays.areAllZeroes(byArray3, n3, 32) ^ true;
    }

    private static int decode32(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        n = n + 1;
        return n2 | (byArray[n] & 0xFF) << 8 | (byArray[++n] & 0xFF) << 16 | byArray[n + 1] << 24;
    }

    private static void decodeScalar(byte[] byArray, int n, int[] nArray) {
        int n2;
        for (int k = 0; k < 8; ++k) {
            nArray[k] = X25519.decode32(byArray, k * 4 + n);
        }
        int[] nArray2 = nArray;
        nArray2[0] = nArray[0] & 0xFFFFFFF8;
        nArray[7] = n2 = nArray[7] & Integer.MAX_VALUE;
        nArray2[7] = n2 | 0x40000000;
    }

    public static void generatePrivateKey(SecureRandom secureRandom, byte[] byArray) {
        byte by;
        byte[] byArray2 = byArray;
        secureRandom.nextBytes(byArray);
        byArray2[0] = (byte)(byArray[0] & 0xF8);
        byArray[31] = by = (byte)(byArray[31] & 0x7F);
        byArray2[31] = (byte)(by | 0x40);
    }

    public static void generatePublicKey(byte[] byArray, int n, byte[] byArray2, int n2) {
        X25519.scalarMultBase(byArray, n, byArray2, n2);
    }

    private static void pointDouble(int[] nArray, int[] nArray2) {
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = X25519Field.create();
        X25519Field.apm(nArray, nArray2, nArray3, nArray4);
        X25519Field.sqr(nArray3, nArray3);
        X25519Field.sqr(nArray4, nArray4);
        X25519Field.mul(nArray3, nArray4, nArray);
        X25519Field.sub(nArray3, nArray4, nArray3);
        X25519Field.mul(nArray3, 121666, nArray2);
        X25519Field.add(nArray2, nArray4, nArray2);
        X25519Field.mul(nArray2, nArray3, nArray2);
    }

    public static void precompute() {
        Ed25519.precompute();
    }

    public static void scalarMult(byte[] objectArray, int n, byte[] objectArray2, int n2, byte[] byArray, int n3) {
        byte[] byArray2 = objectArray;
        objectArray = new int[8];
        X25519.decodeScalar(byArray2, n, objectArray);
        int[] nArray = X25519Field.create();
        X25519Field.decode(objectArray2, n2, nArray);
        objectArray2 = X25519Field.create();
        X25519Field.copy(nArray, 0, objectArray2, 0);
        int[] nArray2 = X25519Field.create();
        int[] nArray3 = nArray2;
        nArray2[0] = 1;
        int[] nArray4 = X25519Field.create();
        int[] nArray5 = nArray4;
        nArray4[0] = 1;
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        int[] nArray8 = X25519Field.create();
        int n4 = 254;
        int n5 = 1;
        do {
            Object[] objectArray3 = objectArray2;
            X25519Field.apm(nArray5, nArray6, nArray7, nArray5);
            X25519Field.apm(objectArray2, nArray3, nArray6, objectArray2);
            X25519Field.mul(nArray7, objectArray2, nArray7);
            X25519Field.mul(nArray5, nArray6, nArray5);
            X25519Field.sqr(nArray6, nArray6);
            X25519Field.sqr(objectArray3, objectArray3);
            X25519Field.sub(nArray6, objectArray2, nArray8);
            X25519Field.mul(nArray8, 121666, nArray3);
            X25519Field.add(nArray3, objectArray2, nArray3);
            X25519Field.mul(nArray3, nArray8, nArray3);
            X25519Field.mul((int[])objectArray2, nArray6, (int[])objectArray2);
            X25519Field.apm(nArray7, nArray5, nArray5, nArray6);
            X25519Field.sqr(nArray5, nArray5);
            X25519Field.sqr(nArray6, nArray6);
            X25519Field.mul(nArray6, nArray, nArray6);
            int n6 = n5;
            int n7 = n4 += -1;
            n5 = n7 >>> 5;
            int n8 = n7 & 0x1F;
            n5 = objectArray[n5] >>> n8 & 1;
            int n9 = n6 ^ n5;
            X25519Field.cswap(n9, objectArray2, nArray5);
            X25519Field.cswap(n9, nArray3, nArray6);
        } while (n4 >= 3);
        for (int k = 0; k < 3; ++k) {
            X25519.pointDouble(objectArray2, nArray3);
        }
        Object[] objectArray4 = objectArray2;
        X25519Field.inv(nArray3, nArray3);
        X25519Field.mul((int[])objectArray4, nArray3, (int[])objectArray2);
        X25519Field.normalize(objectArray4);
        X25519Field.encode((int[])objectArray2, byArray, n3);
    }

    public static void scalarMultBase(byte[] byArray, int n, byte[] objectArray, int n2) {
        int[] nArray = X25519Field.create();
        byte[] byArray2 = objectArray;
        int[] nArray2 = X25519Field.create();
        objectArray = nArray2;
        Ed25519.scalarMultBaseYZ(Friend.INSTANCE, byArray, n, nArray, objectArray);
        X25519Field.apm(nArray2, nArray, nArray, objectArray);
        X25519Field.inv(nArray2, nArray2);
        X25519Field.mul(nArray, nArray2, nArray);
        X25519Field.normalize(nArray);
        X25519Field.encode(nArray, byArray2, n2);
    }

    public static class F
    extends X25519Field {
        private F() {
        }
    }

    public static class Friend {
        private static final Friend INSTANCE = new Friend();

        private Friend() {
        }
    }
}

