/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ExhaustedPrivateKeyException;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.KeyedHashFunctions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSVerifierUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class XMSSSigner
implements StateAwareMessageSigner {
    private XMSSPrivateKeyParameters privateKey;
    private XMSSPublicKeyParameters publicKey;
    private XMSSParameters params;
    private WOTSPlus wotsPlus;
    private KeyedHashFunctions khf;
    private boolean initSign;
    private boolean hasGenerated;

    private WOTSPlusSignature wotsSign(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray.length == this.params.getTreeDigestSize()) {
            if (oTSHashAddress != null) {
                XMSSSigner xMSSSigner = this;
                WOTSPlus wOTSPlus = xMSSSigner.wotsPlus;
                wOTSPlus.importKeys(wOTSPlus.getWOTSPlusSecretKey(this.privateKey.getSecretKeySeed(), oTSHashAddress), this.privateKey.getPublicSeed());
                return xMSSSigner.wotsPlus.sign(byArray, oTSHashAddress);
            }
            throw new NullPointerException("otsHashAddress == null");
        }
        throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters;
            XMSSSigner xMSSSigner = wOTSPlus;
            XMSSSigner xMSSSigner2 = wOTSPlus;
            xMSSSigner2.initSign = true;
            xMSSSigner2.hasGenerated = false;
            xMSSSigner.privateKey = xMSSPrivateKeyParameters = (XMSSPrivateKeyParameters)cipherParameters;
            xMSSSigner.params = xMSSPrivateKeyParameters.getParameters();
        } else {
            XMSSPublicKeyParameters xMSSPublicKeyParameters;
            XMSSSigner xMSSSigner = wOTSPlus;
            ((XMSSSigner)((Object)wOTSPlus)).initSign = false;
            xMSSSigner.publicKey = xMSSPublicKeyParameters = (XMSSPublicKeyParameters)cipherParameters;
            xMSSSigner.params = xMSSPublicKeyParameters.getParameters();
        }
        WOTSPlus wOTSPlus = ((XMSSSigner)((Object)wOTSPlus)).params.getWOTSPlus();
        v3.wotsPlus = wOTSPlus;
        v3.khf = wOTSPlus.getKhf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] generateSignature(byte[] byArray) {
        if (byArray == null) throw new NullPointerException("message == null");
        if (!this.initSign) throw new IllegalStateException("signer not initialized for signature generation");
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this.privateKey;
        if (xMSSPrivateKeyParameters == null) throw new IllegalStateException("signing key no longer usable");
        synchronized (xMSSPrivateKeyParameters) {
            if (this.privateKey.getUsagesRemaining() <= 0L) throw new ExhaustedPrivateKeyException("no usages of private key remaining");
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            if (this.privateKey.getBDSState().getAuthenticationPath().isEmpty()) throw new IllegalStateException("not initialized");
            XMSSSigner xMSSSigner = this;
            XMSSSigner xMSSSigner2 = xMSSSigner;
            XMSSSigner xMSSSigner3 = xMSSSigner;
            XMSSSigner xMSSSigner4 = xMSSSigner;
            XMSSSigner xMSSSigner5 = xMSSSigner;
            int n = xMSSSigner.privateKey.getIndex();
            xMSSSigner3.hasGenerated = true;
            KeyedHashFunctions keyedHashFunctions = xMSSSigner4.khf;
            byte[] byArray2 = this.privateKey.getSecretKeyPRF();
            long l = n;
            byArray2 = keyedHashFunctions.PRF(byArray2, XMSSUtil.toBytesBigEndian(l, 32));
            long l2 = l;
            XMSSSigner xMSSSigner6 = this;
            XMSSSigner xMSSSigner7 = xMSSSigner6;
            byte[] byArray3 = xMSSSigner6.privateKey.getRoot();
            byArray3 = Arrays.concatenate(byArray2, byArray3, XMSSUtil.toBytesBigEndian(l2, xMSSSigner7.params.getTreeDigestSize()));
            byte[] byArray4 = xMSSSigner5.khf.HMsg(byArray3, byArray);
            WOTSPlusSignature wOTSPlusSignature = xMSSSigner2.wotsSign(byArray4, (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(n).build());
            byte[] byArray5 = new XMSSSignature.Builder(this.params).withIndex(n).withRandom(byArray2).withWOTSPlusSignature(wOTSPlusSignature).withAuthPath(this.privateKey.getBDSState().getAuthenticationPath()).build().toByteArray();
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters2 = xMSSPrivateKeyParameters;
            XMSSSigner xMSSSigner8 = this;
            xMSSSigner8.privateKey.getBDSState().markUsed();
            xMSSSigner8.privateKey.rollKey();
            // ** MonitorExit[v13] (shouldn't be in output)
            return byArray5;
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                XMSSSigner xMSSSigner9 = this;
                xMSSSigner9.privateKey.getBDSState().markUsed();
                xMSSSigner9.privateKey.rollKey();
                throw throwable2;
            }
        }
    }

    public long getUsagesRemaining() {
        return this.privateKey.getUsagesRemaining();
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] object) {
        XMSSSignature xMSSSignature = new XMSSSignature.Builder(this.params).withSignature((byte[])object).build();
        object = xMSSSignature;
        int n = xMSSSignature.getIndex();
        this.wotsPlus.importKeys(new byte[this.params.getTreeDigestSize()], this.publicKey.getPublicSeed());
        byte[] byArray2 = ((XMSSSignature)object).getRandom();
        byte[] byArray3 = this.publicKey.getRoot();
        long l = n;
        XMSSSigner xMSSSigner = this;
        byArray2 = Arrays.concatenate(byArray2, byArray3, XMSSUtil.toBytesBigEndian(l, this.params.getTreeDigestSize()));
        byArray = xMSSSigner.khf.HMsg(byArray2, byArray);
        int n2 = xMSSSigner.params.getHeight();
        int n3 = XMSSUtil.getLeafIndex(l, n2);
        OTSHashAddress oTSHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(n).build();
        return Arrays.constantTimeAreEqual(XMSSVerifierUtil.getRootNodeFromSignature(this.wotsPlus, n2, byArray, (XMSSReducedSignature)object, oTSHashAddress, n3).getValue(), this.publicKey.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        XMSSSigner xMSSSigner = this;
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = xMSSSigner.privateKey;
        synchronized (xMSSPrivateKeyParameters) {
            if (xMSSSigner.hasGenerated) {
                this.privateKey = null;
                return this.privateKey;
            }
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters2 = this.privateKey;
            if (xMSSPrivateKeyParameters2 != null) {
                this.privateKey = xMSSPrivateKeyParameters2.getNextKey();
            }
            return xMSSPrivateKeyParameters2;
        }
    }
}

