/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.mrz;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.mrz.MrzParseException;
import com.fis.ekyc.nfc.build_in.mrz.MrzRange;
import com.fis.ekyc.nfc.build_in.mrz.MrzRecord;
import com.fis.ekyc.nfc.build_in.mrz.types.MrzDate;
import com.fis.ekyc.nfc.build_in.mrz.types.MrzFormat;
import com.fis.ekyc.nfc.build_in.mrz.types.MrzSex;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;

public class MrzParser {
    private static final int[] MRZ_WEIGHTS = new int[]{7, 3, 1};
    private static final Map<String, String> EXPAND_CHARACTERS = new HashMap<String, String>();
    public static final char FILLER = '<';
    public final String mrz;
    public final String[] rows;
    public final MrzFormat format;

    public MrzParser(String string2) {
        this.mrz = string2;
        this.rows = string2.split("\n");
        this.format = MrzFormat.get(string2);
    }

    private static boolean isValid(char c2) {
        return c2 == '<' || c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z';
    }

    private static int getCharacterValue(char c2) {
        if (c2 == '<') {
            return 0;
        }
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'A' && c2 <= 'Z') {
            return c2 - 65 + 10;
        }
        throw new RuntimeException("Invalid character in MRZ record: " + c2);
    }

    public static int computeCheckDigit(String string2) {
        int n = 0;
        for (int k = 0; k < string2.length(); ++k) {
            n = MrzParser.getCharacterValue(string2.charAt(k)) * MRZ_WEIGHTS[k % MRZ_WEIGHTS.length] + n;
        }
        return n % 10;
    }

    public static char computeCheckDigitChar(String string2) {
        return (char)(MrzParser.computeCheckDigit(string2) + 48);
    }

    public static MrzRecord parse(String string2) {
        MrzRecord mrzRecord = MrzFormat.get(string2).newRecord();
        mrzRecord.fromMrz(string2);
        return mrzRecord;
    }

    public static String toMrz(String object, int n) {
        StringBuilder stringBuilder;
        if (object == null) {
            object = "";
        }
        Object object2 = EXPAND_CHARACTERS.entrySet().iterator();
        while (object2.hasNext()) {
            String string2 = object;
            object = object2.next();
            object = string2.replace(object.getKey(), (CharSequence)object.getValue());
        }
        object = MrzParser.deaccent(((String)object).replace("\u2019", "").replace("'", "")).toUpperCase();
        if (n >= 0 && ((String)object).length() > n) {
            object = ((String)object).substring(0, n);
        }
        object2 = stringBuilder;
        stringBuilder = new StringBuilder((String)object);
        for (int k = 0; k < ((StringBuilder)object2).length(); ++k) {
            if (MrzParser.isValid(((StringBuilder)object2).charAt(k))) continue;
            ((StringBuilder)object2).setCharAt(k, '<');
        }
        while (((StringBuilder)object2).length() < n) {
            ((StringBuilder)object2).append('<');
        }
        return ((StringBuilder)object2).toString();
    }

    private static boolean isBlank(String string2) {
        return string2 == null || string2.trim().length() == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String nameToMrz(String string2, String string3, int n) {
        int n2;
        if (MrzParser.isBlank(string2)) throw new IllegalArgumentException(g.a("Parameter surname: invalid value ", string2, ": blank"));
        if (MrzParser.isBlank(string3)) throw new IllegalArgumentException(g.a("Parameter givenNames: invalid value ", string3, ": blank"));
        if (n <= 0) throw new IllegalArgumentException(f.a("Parameter length: invalid value ", n, ": not positive"));
        string2 = string2.replace(", ", " ");
        string3 = string3.replace(", ", " ");
        String[] stringArray = string2.trim().split("[ \n\t\f\r]+");
        String[] stringArray2 = string3.trim().split("[ \n\t\f\r]+");
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray[n2] = MrzParser.toMrz(stringArray[n2], -1);
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            stringArray2[n2] = MrzParser.toMrz(stringArray2[n2], -1);
        }
        n2 = MrzParser.getNameSize(stringArray, stringArray2);
        int n3 = stringArray2.length - 1;
        String[] stringArray3 = stringArray2;
        while (n2 > n) {
            String string4 = stringArray3[n3];
            int n4 = string4.length();
            if (n2 - n4 + 1 <= n) {
                stringArray3[n3] = string4.substring(0, n4 - (n2 - n));
            } else {
                stringArray3[n3] = string4.substring(0, 1);
                n2 = n3 + -1;
                if (n2 < 0) {
                    if (stringArray3 == stringArray) throw new IllegalArgumentException("Cannot truncate name " + string2 + " " + string3 + ": length too small: " + n + "; truncated to " + MrzParser.toName(stringArray, stringArray2));
                    n2 = stringArray.length - 1;
                    stringArray3 = stringArray;
                    n3 = n2;
                } else {
                    n3 = n2;
                }
            }
            n2 = MrzParser.getNameSize(stringArray, stringArray2);
        }
        return MrzParser.toMrz(MrzParser.toName(stringArray, stringArray2), n);
    }

    private static String toName(String[] stringArray, String[] stringArray2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n = 1;
        for (String string2 : stringArray) {
            if (n != 0) {
                n = 0;
            } else {
                stringBuilder2.append('<');
            }
            stringBuilder2.append(string2);
        }
        stringBuilder2.append('<');
        int n2 = stringArray2.length;
        for (n = 0; n < n2; ++n) {
            StringBuilder stringBuilder3 = stringBuilder2;
            String string3 = stringArray2[n];
            stringBuilder3.append('<');
            stringBuilder3.append(string3);
        }
        return stringBuilder2.toString();
    }

    private static int getNameSize(String[] stringArray, String[] stringArray2) {
        int n = 0;
        int n2 = stringArray.length;
        for (int k = 0; k < n2; ++k) {
            n = stringArray[k].length() + 1 + n;
        }
        int n3 = stringArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            n = stringArray2[n2].length() + 1 + n;
        }
        return n;
    }

    private static String deaccent(String string2) {
        return Normalizer.normalize(string2, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").toLowerCase();
    }

    static {
        EXPAND_CHARACTERS.put("\u00c4", "AE");
        EXPAND_CHARACTERS.put("\u00e4", "AE");
        EXPAND_CHARACTERS.put("\u00c5", "AA");
        EXPAND_CHARACTERS.put("\u00e5", "AA");
        EXPAND_CHARACTERS.put("\u00c6", "AE");
        EXPAND_CHARACTERS.put("\u00e6", "AE");
        EXPAND_CHARACTERS.put("\u0132", "IJ");
        EXPAND_CHARACTERS.put("\u0133", "IJ");
        EXPAND_CHARACTERS.put("\u00d6", "OE");
        EXPAND_CHARACTERS.put("\u00f6", "OE");
        EXPAND_CHARACTERS.put("\u00d8", "OE");
        EXPAND_CHARACTERS.put("\u00f8", "OE");
        EXPAND_CHARACTERS.put("\u00dc", "UE");
        EXPAND_CHARACTERS.put("\u00fc", "UE");
        EXPAND_CHARACTERS.put("\u00df", "SS");
    }

    public String[] parseName(MrzRange mrzRange) {
        MrzParser mrzParser = this;
        mrzParser.checkValidCharacters(mrzRange);
        MrzRange[] mrzRangeArray = new MrzRange[1];
        Object object = mrzRangeArray;
        mrzRangeArray[0] = mrzRange;
        object = mrzParser.rawValue((MrzRange[])object);
        while (((String)object).endsWith("<")) {
            Object object2 = object;
            object = ((String)object2).substring(0, ((String)object2).length() - 1);
        }
        String[] stringArray = ((String)object).split("<<");
        String string2 = "";
        int n = mrzRange.column;
        int n2 = stringArray[0].length() + n;
        int n3 = mrzRange.row;
        String string3 = this.parseString(new MrzRange(n, n2, n3));
        if (stringArray.length == 1) {
            int n4 = mrzRange.column;
            int n5 = stringArray[0].length() + n4;
            int n6 = mrzRange.row;
            string2 = this.parseString(new MrzRange(n4, n5, n6));
            string3 = "";
        } else if (stringArray.length > 1) {
            MrzParser mrzParser2 = this;
            int n7 = mrzRange.column;
            int n8 = stringArray[0].length() + n7;
            int n9 = mrzRange.row;
            string3 = mrzParser2.parseString(new MrzRange(n7, n8, n9));
            n7 = mrzRange.column;
            n7 = stringArray[0].length() + n7 + 2;
            int n10 = mrzRange.column;
            n10 = ((String)object).length() + n10;
            int n11 = mrzRange.row;
            string2 = mrzParser2.parseString(new MrzRange(n7, n10, n11));
        }
        return new String[]{string3, string2};
    }

    public String rawValue(MrzRange ... mrzRangeArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n = mrzRangeArray.length;
        for (int k = 0; k < n; ++k) {
            MrzRange mrzRange;
            MrzRange mrzRange2 = mrzRange = mrzRangeArray[k];
            int n2 = mrzRange2.column;
            stringBuilder2.append(this.rows[mrzRange.row].substring(n2, mrzRange2.columnTo));
        }
        return stringBuilder2.toString();
    }

    public void checkValidCharacters(MrzRange mrzRange) {
        MrzRange[] mrzRangeArray = new MrzRange[1];
        Object object = mrzRangeArray;
        mrzRangeArray[0] = mrzRange;
        object = ((MrzParser)((Object)string2)).rawValue((MrzRange[])object);
        for (int k = 0; k < ((String)object).length(); ++k) {
            MrzRange mrzRange2;
            char c2 = ((String)object).charAt(k);
            if (c2 == '<' || c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z') continue;
            MrzParser mrzParser = string2;
            String string2 = "Invalid character in MRZ record: " + c2;
            object = mrzParser.mrz;
            MrzRange mrzRange3 = mrzRange2;
            MrzRange mrzRange4 = mrzRange;
            int n = mrzRange4.column;
            int n2 = n + k;
            k = n + k + 1;
            int n3 = mrzRange4.row;
            mrzRange2 = new MrzRange(n2, k, n3);
            MrzFormat mrzFormat = mrzParser.format;
            throw new MrzParseException(string2, (String)object, mrzRange3, mrzFormat);
        }
    }

    public String parseString(MrzRange mrzRange) {
        ((MrzParser)object).checkValidCharacters(mrzRange);
        MrzRange[] mrzRangeArray = new MrzRange[1];
        Object object = mrzRangeArray;
        mrzRangeArray[0] = mrzRange;
        object = ((MrzParser)object).rawValue((MrzRange[])object);
        while (((String)object).endsWith("<")) {
            Object object2 = object;
            object = ((String)object2).substring(0, ((String)object2).length() - 1);
        }
        return ((String)object).replace("<<", ", ").replace('<', ' ');
    }

    public boolean checkDigit(int n, int n2, MrzRange mrzRange, String string2) {
        return this.checkDigit(n, n2, this.rawValue(mrzRange), string2);
    }

    public boolean checkDigit(int n, int n2, String string2, String string3) {
        MrzParser mrzParser = object;
        Object object = null;
        char c2 = (char)(MrzParser.computeCheckDigit(string2) + 48);
        char c3 = mrzParser.rows[n2].charAt(n);
        if (c3 == '<') {
            c3 = '0';
        }
        if (c2 != c3) {
            MrzRange mrzRange;
            object = mrzRange;
            int n3 = n;
            mrzRange = new MrzRange(n3, n3 + 1, n2);
            System.out.println("Check digit verification failed for " + string3 + ": expected " + c2 + " but got " + c3);
        }
        return object == null;
    }

    public MrzDate parseDate(MrzRange mrzRange) {
        if (mrzRange.length() == 6) {
            int n;
            MrzRange mrzRange2;
            int n2;
            MrzRange mrzRange3;
            int n3;
            MrzRange mrzRange4;
            MrzRange mrzRange5 = mrzRange4;
            MrzRange mrzRange6 = mrzRange;
            int n4 = mrzRange6.column;
            int n5 = n4 + 2;
            int n6 = mrzRange6.row;
            mrzRange4 = new MrzRange(n4, n5, n6);
            try {
                n3 = Integer.parseInt(object.rawValue(mrzRange5));
            }
            catch (NumberFormatException numberFormatException) {
                n3 = -1;
            }
            MrzRange mrzRange7 = mrzRange3;
            MrzRange mrzRange8 = mrzRange;
            n5 = mrzRange8.column;
            n6 = n5 + 2;
            int n7 = mrzRange8.row;
            mrzRange3 = new MrzRange(n6, n5 += 4, n7);
            try {
                n2 = Integer.parseInt(object.rawValue(mrzRange7));
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
            MrzRange mrzRange9 = mrzRange2;
            MrzRange mrzRange10 = mrzRange;
            n6 = mrzRange10.column;
            n7 = n6 + 4;
            int n8 = mrzRange10.row;
            mrzRange2 = new MrzRange(n7, n6 += 6, n8);
            try {
                n = Integer.parseInt(object.rawValue(mrzRange9));
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            MrzRange[] mrzRangeArray = object;
            MrzRange[] mrzRangeArray2 = new MrzRange[1];
            Object object = mrzRangeArray2;
            mrzRangeArray2[0] = mrzRange;
            object = mrzRangeArray.rawValue((MrzRange)object);
            return new MrzDate(n3, n2, n, (String)object);
        }
        throw new IllegalArgumentException("Parameter range: invalid value " + mrzRange + ": must be 6 characters long");
    }

    public MrzSex parseSex(int n, int n2) {
        return MrzSex.fromMrz(this.rows[n2].charAt(n));
    }
}

