/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.codescanner;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QrDetectionView
extends View {
    @Nullable
    private RectF boundingBox;
    @Nullable
    private RectF targetBoundingBox;
    @NotNull
    private final Paint cornerPaint;
    private final float cornerLength;
    private final int startColor;
    private final int endColor;
    private int currentColor;
    private float scaleProgress;
    private float colorProgress;
    private final float initialScale;
    @NotNull
    private final Path path;
    private final ValueAnimator propertyAnimator;

    @JvmOverloads
    public QrDetectionView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(12.0f);
        this.cornerPaint = paint;
        this.cornerLength = 40.0f;
        this.startColor = -256;
        this.endColor = -16711936;
        this.currentColor = -256;
        this.initialScale = 1.5f;
        this.path = new Path();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.setDuration(300L);
        valueAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        valueAnimator.addUpdateListener(arg_0 -> QrDetectionView.propertyAnimator$lambda$2$lambda$1(this, arg_0));
        this.propertyAnimator = valueAnimator;
    }

    public /* synthetic */ QrDetectionView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final void updateColor() {
        QrDetectionView qrDetectionView = this;
        int n = Color.red((int)qrDetectionView.startColor);
        int n2 = Color.red((int)qrDetectionView.endColor);
        float f2 = qrDetectionView.colorProgress;
        int n3 = qrDetectionView.evaluateColor(n, n2, f2);
        QrDetectionView qrDetectionView2 = this;
        int n4 = Color.green((int)qrDetectionView2.startColor);
        n = Color.green((int)qrDetectionView2.endColor);
        float f3 = qrDetectionView2.colorProgress;
        n4 = qrDetectionView2.evaluateColor(n4, n, f3);
        n = Color.blue((int)qrDetectionView2.startColor);
        int n5 = Color.blue((int)qrDetectionView2.endColor);
        f2 = qrDetectionView2.colorProgress;
        qrDetectionView.currentColor = n4 = Color.rgb((int)n3, (int)n4, (int)qrDetectionView2.evaluateColor(n, n5, f2));
        qrDetectionView.cornerPaint.setColor(n4);
    }

    private final int evaluateColor(int n, int n2, float f2) {
        int n3 = n;
        float f3 = n3;
        return (int)((float)(n2 - n3) * f2 + f3);
    }

    private final float lerp(float f2, float f3, float f4) {
        return (f3 - f2) * f4 + f2;
    }

    @JvmOverloads
    public QrDetectionView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public QrDetectionView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void propertyAnimator$lambda$2$lambda$1(QrDetectionView qrDetectionView, ValueAnimator valueAnimator) {
        QrDetectionView qrDetectionView2 = qrDetectionView;
        ValueAnimator valueAnimator2 = valueAnimator;
        Intrinsics.checkNotNullParameter((Object)((Object)qrDetectionView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)valueAnimator2, (String)"animation");
        Object object = valueAnimator2.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        qrDetectionView.scaleProgress = ((Float)object).floatValue();
        Object object2 = valueAnimator.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Float");
        qrDetectionView2.colorProgress = ((Float)object2).floatValue();
        qrDetectionView2.updateColor();
        qrDetectionView2.invalidate();
    }

    public final void showDetection(@NotNull Rect rect, int n, int n2, @NotNull Function0<Unit> function0) {
        QrDetectionView qrDetectionView = this;
        Rect rect2 = rect;
        QrDetectionView qrDetectionView2 = this;
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter(function0, (String)"onAnimFinished");
        float f2 = (float)qrDetectionView2.getWidth() / (float)n;
        float f3 = (float)qrDetectionView2.getHeight() / (float)n2;
        float f4 = (float)rect2.left * f2;
        float f5 = (float)rect2.top * f3;
        f3 = (float)rect2.bottom * f3;
        float f6 = f3 - f5;
        float f7 = (float)rect2.width() * f2;
        f2 = 2;
        float f8 = f4 = f7 / f2 + f4;
        float f9 = f6 / f2;
        float f10 = f8 - f9;
        f9 = f8 + f9;
        this.targetBoundingBox = new RectF(f10, f5, f9, f3);
        Intrinsics.checkNotNull((Object)this.targetBoundingBox);
        f3 = this.targetBoundingBox.centerY();
        float f11 = f6;
        float f12 = this.initialScale;
        f5 = f4 - f6 * f12 / f2;
        f6 = f3 - f6 * f12 / f2;
        f4 = f11 * f12 / f2 + f4;
        f12 = f11 * f12 / f2 + f3;
        qrDetectionView.boundingBox = new RectF(f5, f6, f4, f12);
        qrDetectionView.propertyAnimator.cancel();
        qrDetectionView.propertyAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(function0){
            public final /* synthetic */ Function0<Unit> $onAnimFinished;
            {
                this.$onAnimFinished = function0;
            }

            public void onAnimationEnd(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animation");
                this.$onAnimFinished.invoke();
            }
        });
        qrDetectionView.propertyAnimator.start();
    }

    public final void hideDetection() {
        QrDetectionView qrDetectionView = this;
        qrDetectionView.propertyAnimator.cancel();
        qrDetectionView.boundingBox = null;
        qrDetectionView.targetBoundingBox = null;
        qrDetectionView.invalidate();
    }

    public void onDraw(@NotNull Canvas canvas) {
        RectF rectF;
        QrDetectionView qrDetectionView = qrDetectionView6;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        RectF rectF2 = qrDetectionView.boundingBox;
        if (rectF2 != null && (rectF = qrDetectionView6.targetBoundingBox) != null) {
            RectF rectF3;
            QrDetectionView qrDetectionView2 = qrDetectionView6;
            QrDetectionView qrDetectionView3 = qrDetectionView6;
            QrDetectionView qrDetectionView4 = qrDetectionView6;
            QrDetectionView qrDetectionView5 = qrDetectionView6;
            float f2 = rectF2.left;
            float f3 = rectF.left;
            float f4 = qrDetectionView5.scaleProgress;
            f2 = qrDetectionView5.lerp(f2, f3, f4);
            f3 = rectF2.top;
            f4 = rectF.top;
            float f5 = qrDetectionView4.scaleProgress;
            f3 = qrDetectionView4.lerp(f3, f4, f5);
            f4 = rectF2.right;
            f5 = rectF.right;
            float f6 = qrDetectionView3.scaleProgress;
            f4 = qrDetectionView3.lerp(f4, f5, f6);
            f5 = rectF2.bottom;
            f6 = rectF.bottom;
            float f7 = qrDetectionView2.scaleProgress;
            f5 = qrDetectionView2.lerp(f5, f6, f7);
            RectF rectF4 = rectF3;
            rectF3 = new RectF(f2, f3, f4, f5);
            qrDetectionView2.path.reset();
            RectF rectF5 = rectF4;
            f2 = rectF5.left + qrDetectionView6.cornerLength;
            qrDetectionView2.path.moveTo(f2, rectF5.top);
            RectF rectF6 = rectF4;
            f2 = rectF6.left;
            qrDetectionView2.path.lineTo(f2, rectF6.top);
            qrDetectionView2.path.lineTo(rectF4.left, rectF4.top + qrDetectionView6.cornerLength);
            RectF rectF7 = rectF4;
            f2 = rectF7.right - qrDetectionView6.cornerLength;
            qrDetectionView2.path.moveTo(f2, rectF7.top);
            RectF rectF8 = rectF4;
            f2 = rectF8.right;
            qrDetectionView2.path.lineTo(f2, rectF8.top);
            qrDetectionView2.path.lineTo(rectF4.right, rectF4.top + qrDetectionView6.cornerLength);
            qrDetectionView2.path.moveTo(rectF4.left, rectF4.bottom - qrDetectionView6.cornerLength);
            RectF rectF9 = rectF4;
            f2 = rectF9.left;
            qrDetectionView2.path.lineTo(f2, rectF9.bottom);
            RectF rectF10 = rectF4;
            f2 = rectF10.left + qrDetectionView6.cornerLength;
            qrDetectionView2.path.lineTo(f2, rectF10.bottom);
            RectF rectF11 = rectF4;
            f2 = rectF11.right - qrDetectionView6.cornerLength;
            qrDetectionView2.path.moveTo(f2, rectF11.bottom);
            RectF rectF12 = rectF4;
            f2 = rectF12.right;
            qrDetectionView2.path.lineTo(f2, rectF12.bottom);
            qrDetectionView2.path.lineTo(rectF4.right, rectF4.bottom - qrDetectionView6.cornerLength);
            QrDetectionView qrDetectionView6 = qrDetectionView2.path;
            canvas.drawPath((Path)qrDetectionView6, qrDetectionView2.cornerPaint);
        }
    }
}

