/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.liveness;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.CountDownTimer;
import android.util.Log;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.KalapaSDK;
import vn.kalapa.ekyc.liveness.LivenessHandler;
import vn.kalapa.ekyc.liveness.LivenessSession;
import vn.kalapa.ekyc.liveness.LivenessSessionStatus;
import vn.kalapa.ekyc.managers.KLPFaceDetectorListener;
import vn.kalapa.ekyc.utils.Common;
import vn.kalapa.ekyc.utils.Helpers;

@SourceDebugExtension(value={"SMAP\nLivenessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LivenessHandler.kt\nvn/kalapa/ekyc/liveness/LivenessHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n1#2:277\n*E\n"})
public final class LivenessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long PROCESS_INTERVAL = 33L;
    @NotNull
    private final Context context;
    @NotNull
    private final Common.LIVENESS_VERSION livenessSessionType;
    @NotNull
    private final KLPFaceDetectorListener faceDetectorListener;
    private final int rotationAngle;
    private int addedRotation;
    private final String TAG;
    private final long LIVENESS_MAX_TIME;
    private long countdown;
    @NotNull
    private LivenessSession livenessSession;
    private boolean isStop;
    @Nullable
    private CountDownTimer countDownTimer;
    private long startTime;
    private long lastCheckTime;
    @NotNull
    private LivenessSessionStatus sessionStatus;
    @NotNull
    private String sessionAction;
    private long TIME_PERIOD;
    @NotNull
    private final String CAMERA_ORIENTATION_KEY;
    private int actualRotationDegree;
    private boolean checkingForOrientation;
    private int wrongFaceRatioCount;
    private double wrongFaceRatio;
    private int sessionStatusCount;
    private int continuousFaceCounter;
    private long lastProcessTime;
    @NotNull
    private final LinkedBlockingQueue<Pair<Bitmap, Bitmap>> processingQueue;
    @NotNull
    private final CoroutineScope processingScope;

    public LivenessHandler(@NotNull Context object, @NotNull Common.LIVENESS_VERSION lIVENESS_VERSION, @NotNull KLPFaceDetectorListener kLPFaceDetectorListener, int n) {
        int n2;
        long l;
        LivenessHandler livenessHandler = this;
        Intrinsics.checkNotNullParameter((Object)object, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)lIVENESS_VERSION), (String)"livenessSessionType");
        Intrinsics.checkNotNullParameter((Object)kLPFaceDetectorListener, (String)"faceDetectorListener");
        this.context = object;
        this.livenessSessionType = lIVENESS_VERSION;
        this.faceDetectorListener = kLPFaceDetectorListener;
        livenessHandler.rotationAngle = n;
        livenessHandler.TAG = "LivenessHandler";
        object = KalapaSDK.Companion;
        long l2 = ((KalapaSDK.Companion)object).isConfigInitialized$kalapa_release() && ((KalapaSDK.Companion)object).getConfig$kalapa_release().getLivenessTimeoutInSeconds() > 0 ? (long)((KalapaSDK.Companion)object).getConfig$kalapa_release().getLivenessTimeoutInSeconds() * 1000L : 61000L;
        LivenessHandler livenessHandler2 = this;
        this.LIVENESS_MAX_TIME = l2;
        livenessHandler2.countdown = l2;
        livenessHandler2.livenessSession = new LivenessSession(lIVENESS_VERSION);
        livenessHandler2.startTime = l = System.currentTimeMillis();
        livenessHandler2.lastCheckTime = l;
        livenessHandler2.sessionStatus = LivenessSessionStatus.UNVERIFIED;
        livenessHandler2.sessionAction = "";
        livenessHandler2.TIME_PERIOD = 5000L;
        livenessHandler2.CAMERA_ORIENTATION_KEY = "KLP_CAMERA_ORIENTATION_KEY";
        this.actualRotationDegree = n;
        this.processingQueue = new LinkedBlockingQueue(2);
        this.processingScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getDefault().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.setupCountdownHandler();
        Object[] objectArray = Helpers.Companion;
        this.addedRotation = n2 = Helpers.Companion.getIntPreferences("KLP_CAMERA_ORIENTATION_KEY", 0);
        if (n2 != 0) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = "Added Rotation Cached addedRotation: " + n2;
            objectArray2.printLog(objectArray);
        }
        this.startProcessingWorker();
    }

    public /* synthetic */ LivenessHandler(Context context, Common.LIVENESS_VERSION lIVENESS_VERSION, KLPFaceDetectorListener kLPFaceDetectorListener, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        this(context, lIVENESS_VERSION, kLPFaceDetectorListener, n);
    }

    private final void checkForOrientationSuspect() {
        long l = System.currentTimeMillis() - this.lastCheckTime;
        int n = this.sessionStatusCount;
        if (n > 0) {
            double d2;
            LivenessHandler livenessHandler = this;
            int n2 = livenessHandler.wrongFaceRatioCount;
            livenessHandler.wrongFaceRatio = d2 = (double)n2 / (double)n;
            Helpers.Companion.printLog(this.TAG + " shouldChangeAngleOrientation: NO_FACE " + n2 + "/" + n + " wrongFaceRatio: " + d2 + " Elapsed: " + l);
            if (l > livenessHandler.TIME_PERIOD && this.wrongFaceRatio > 0.9) {
                this.faceDetectorListener.onWrongOrientationSuspect();
            }
        }
    }

    private final void startProcessingWorker() {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            public int label;
            private /* synthetic */ Object L$0;
            public final /* synthetic */ LivenessHandler this$0;
            {
                this.this$0 = livenessHandler;
                super(2, continuation);
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block8: {
                    block7: {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        var3_3 = this.label;
                        if (var3_3 != 0) {
                            if (var3_3 != 1) {
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            v0 = var1_1;
                            var1_1 = (CoroutineScope)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)v0);
                                break block7;
                            }
                            catch (Exception v1) {
                                break block8;
                            }
                        }
                        ResultKt.throwOnFailure((Object)var1_1);
                        var1_1 = (CoroutineScope)this.L$0;
                    }
lbl16:
                    // 2 sources

                    while (true) {
                        if (CoroutineScopeKt.isActive((CoroutineScope)var1_1)) ** GOTO lbl-1000
                        return Unit.INSTANCE;
lbl-1000:
                        // 1 sources

                        {
                            var3_4 = (Pair)LivenessHandler.access$getProcessingQueue$p(this.this$0).poll(100L, TimeUnit.MILLISECONDS);
                            if (var3_4 == null) continue;
                        }
                        {
                            var3_4 = (Bitmap)var3_4.component1();
                            v2 = this;
                            v2.L$0 = var1_1;
                            v2.label = 1;
                            if (LivenessHandler.access$processFrameInternal(this.this$0, (Bitmap)var3_4, (Continuation)this) != var2_2) continue;
                            return var2_2;
                        }
                        break;
                    }
                }
                Log.e((String)"LivenessHandler", (String)("Error processing frame: " + v1.getMessage()));
                ** while (true)
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)this.processingScope, null, null, (Function2)function22, (int)3, null);
    }

    private final void stop() {
        LivenessHandler livenessHandler = livenessHandler2;
        livenessHandler.isStop = true;
        CoroutineScopeKt.cancel$default((CoroutineScope)livenessHandler.processingScope, null, (int)1, null);
        livenessHandler.processingQueue.clear();
        LivenessHandler livenessHandler2 = livenessHandler.countDownTimer;
        if (livenessHandler2 != null) {
            livenessHandler2.cancel();
        }
    }

    private final void refreshFrameCounts() {
        LivenessHandler livenessHandler = this;
        livenessHandler.wrongFaceRatioCount = 0;
        livenessHandler.sessionStatusCount = 0;
        livenessHandler.checkingForOrientation = false;
    }

    private final void setupCountdownHandler() {
        CountDownTimer countDownTimer;
        Helpers.Companion.printLog("setupCountdownHandler onInit");
        CountDownTimer countDownTimer2 = this.countDownTimer;
        if (countDownTimer2 != null) {
            countDownTimer2.cancel();
        }
        if (KalapaSDK.Companion.isConfigInitialized$kalapa_release() && this.LIVENESS_MAX_TIME == -1L) {
            return;
        }
        long l = this.countdown;
        CountDownTimer countDownTimer3 = countDownTimer;
        new CountDownTimer(this, l){
            public final /* synthetic */ LivenessHandler this$0;
            {
                this.this$0 = livenessHandler;
                super(l, 1000L);
            }

            public void onTick(long l) {
                LivenessHandler.access$getFaceDetectorListener$p(this.this$0).onCountdown(l);
            }

            public void onFinish() {
                Helpers.Companion.printLog("setupCountdownHandler onFinish");
                LivenessHandler.access$getFaceDetectorListener$p(this.this$0).onExpired();
            }
        }.start();
        this.countDownTimer = countDownTimer3;
    }

    private final Object processFrameInternal(Bitmap bitmap, Continuation<? super Unit> continuation) {
        long l;
        ((LivenessHandler)object).lastProcessTime = l = System.currentTimeMillis();
        boolean bl = l - ((LivenessHandler)object).startTime > ((LivenessHandler)object).LIVENESS_MAX_TIME || ((LivenessHandler)object).countdown == 0L;
        LivenessHandler livenessHandler = object;
        livenessHandler.sessionStatus = livenessHandler.livenessSession.getSessionStatus();
        livenessHandler.sessionAction = livenessHandler.livenessSession.getCurrentAction();
        if (!(livenessHandler.isStop || ((LivenessHandler)object).livenessSession.isFinished() || bl)) {
            int n;
            if (!((LivenessHandler)object).checkingForOrientation) {
                LivenessHandler livenessHandler2 = object;
                livenessHandler2.checkForOrientationSuspect();
                LivenessSessionStatus livenessSessionStatus = livenessHandler2.sessionStatus;
                if (livenessSessionStatus != LivenessSessionStatus.TOO_SMALL && livenessSessionStatus != LivenessSessionStatus.TOO_LARGE && livenessSessionStatus != LivenessSessionStatus.OFF_CENTER) {
                    ++((LivenessHandler)object).sessionStatusCount;
                }
                if (livenessSessionStatus == LivenessSessionStatus.NO_FACE || livenessSessionStatus == LivenessSessionStatus.ANGLE_NOT_CORRECT) {
                    ++((LivenessHandler)object).wrongFaceRatioCount;
                }
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[((LivenessHandler)object).sessionStatus.ordinal()]) {
                    default: {
                        Helpers.Companion.printLog("Ignored sessionStatus " + ((LivenessHandler)object).sessionStatus);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (++((LivenessHandler)object).continuousFaceCounter < 3) break;
                        LivenessHandler livenessHandler3 = object;
                        Helpers.Companion companion = Helpers.Companion;
                        companion.savePrefs(((LivenessHandler)object).CAMERA_ORIENTATION_KEY, Boxing.boxInt((int)((LivenessHandler)object).addedRotation));
                        companion.printLog("Orientation updated and accepted: " + ((LivenessHandler)object).addedRotation);
                        livenessHandler3.checkingForOrientation = false;
                        livenessHandler3.continuousFaceCounter = 0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        ((LivenessHandler)object).addedRotation = (((LivenessHandler)object).addedRotation + 90) % 360;
                        ((LivenessHandler)object).continuousFaceCounter = 0;
                    }
                }
            }
            int n2 = ((LivenessHandler)object).rotationAngle;
            int n3 = ((LivenessHandler)object).addedRotation;
            ((LivenessHandler)object).actualRotationDegree = n = (n2 + n3) % 360;
            Helpers.Companion.printLog("Actual Rotation Degree updated to " + n + " from " + n2 + " addedRotation " + n3);
            Object object = BuildersKt.withContext((CoroutineContext)Dispatchers.getDefault(), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((LivenessHandler)object, bitmap, null){
                public int label;
                public final /* synthetic */ LivenessHandler this$0;
                public final /* synthetic */ Bitmap $frame;
                {
                    this.this$0 = livenessHandler;
                    this.$frame = bitmap;
                    super(2, continuation);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    if (this.label == 0) {
                        ResultKt.throwOnFailure((Object)object);
                        processFrameInternal.2 v0 = this;
                        int n = LivenessHandler.access$getActualRotationDegree$p(v0.this$0);
                        LivenessHandler.access$getLivenessSession$p(this.this$0).process(this.$frame, n, LivenessHandler.access$getFaceDetectorListener$p(v0.this$0));
                        return Unit.INSTANCE;
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                    var v0 = object2;
                    Object object2 = v0.this$0;
                    return new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                    return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                }
            }, continuation);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        ((LivenessHandler)object).handleSessionEnd(bitmap, bl);
        return Unit.INSTANCE;
    }

    private final void handleSessionEnd(Bitmap bitmap, boolean bl) {
        LivenessHandler livenessHandler = livenessHandler3;
        livenessHandler.sessionStatus = livenessHandler.livenessSession.getSessionStatus();
        livenessHandler.sessionAction = livenessHandler.livenessSession.getCurrentAction();
        if (livenessHandler.livenessSession.isFinished()) {
            Object object = Helpers.Companion;
            object.printLog("LivenessSessionStatus " + livenessHandler3.sessionStatus + " addedRotation " + livenessHandler3.addedRotation);
            if (livenessHandler3.addedRotation != object.getIntPreferences(livenessHandler3.CAMERA_ORIENTATION_KEY, 0)) {
                Helpers.Companion companion = object;
                companion.savePrefs(livenessHandler3.CAMERA_ORIENTATION_KEY, livenessHandler3.addedRotation);
                companion.printLog("Added Rotation Cached addedRotation: " + livenessHandler3.addedRotation + " into " + livenessHandler3.CAMERA_ORIENTATION_KEY);
            }
            if ((object = livenessHandler3.sessionStatus) == LivenessSessionStatus.VERIFIED) {
                if (livenessHandler3.livenessSession.getGotTypicalFace()) {
                    LivenessHandler livenessHandler2 = livenessHandler3;
                    LivenessHandler livenessHandler3 = livenessHandler2.livenessSession.getTypicalFace();
                    livenessHandler3.faceDetectorListener.onFaceDetected(bitmap, (Bitmap)livenessHandler3, livenessHandler2.actualRotationDegree);
                }
            } else {
                livenessHandler3.faceDetectorListener.onMessage((LivenessSessionStatus)((Object)object), livenessHandler3.sessionAction);
            }
        } else if (livenessHandler3.sessionStatus == LivenessSessionStatus.EXPIRED || bl) {
            livenessHandler3.faceDetectorListener.onExpired();
        }
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getProcessingQueue$p(LivenessHandler livenessHandler) {
        return livenessHandler.processingQueue;
    }

    public static final /* synthetic */ Object access$processFrameInternal(LivenessHandler livenessHandler, Bitmap bitmap, Continuation continuation) {
        return livenessHandler.processFrameInternal(bitmap, (Continuation<? super Unit>)continuation);
    }

    public static final /* synthetic */ KLPFaceDetectorListener access$getFaceDetectorListener$p(LivenessHandler livenessHandler) {
        return livenessHandler.faceDetectorListener;
    }

    public static final /* synthetic */ LivenessSession access$getLivenessSession$p(LivenessHandler livenessHandler) {
        return livenessHandler.livenessSession;
    }

    public static final /* synthetic */ int access$getActualRotationDegree$p(LivenessHandler livenessHandler) {
        return livenessHandler.actualRotationDegree;
    }

    public final boolean getCheckingForOrientation() {
        return this.checkingForOrientation;
    }

    public final void setCheckingForOrientation(boolean bl) {
        this.checkingForOrientation = bl;
    }

    public final void renewSession() {
        LivenessHandler livenessHandler = this;
        livenessHandler.processingQueue.clear();
        livenessHandler.livenessSession.renewSession(this.livenessSessionType);
        livenessHandler.refreshFrameCounts();
        livenessHandler.sessionStatus = livenessHandler.livenessSession.getSessionStatus();
        livenessHandler.startTime = System.currentTimeMillis();
        livenessHandler.lastProcessTime = 0L;
        livenessHandler.isStop = false;
        livenessHandler.countdown = livenessHandler.LIVENESS_MAX_TIME;
        livenessHandler.setupCountdownHandler();
    }

    public final void processSession(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"frame");
        if (System.currentTimeMillis() - this.lastProcessTime < 33L) {
            return;
        }
        if (this.processingQueue.size() < 2) {
            Bitmap bitmap2 = bitmap;
            this.processingQueue.offer((Pair<Bitmap, Bitmap>)TuplesKt.to((Object)bitmap2, (Object)bitmap2));
        }
    }

    public final void release() {
        LivenessHandler livenessHandler = this;
        livenessHandler.livenessSession.cleanup();
        livenessHandler.stop();
        livenessHandler.processingQueue.clear();
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LivenessSessionStatus.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[LivenessSessionStatus.NO_FACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[LivenessSessionStatus.ANGLE_NOT_CORRECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[LivenessSessionStatus.PROCESSING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[LivenessSessionStatus.OFF_CENTER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[LivenessSessionStatus.TOO_LARGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[LivenessSessionStatus.TOO_SMALL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

