package vn.kalapa.ekyc.iproov.data.response

import com.google.gson.annotations.SerializedName

data class IProovValidateResponse(
    @SerializedName("passed") val passed: Boolean,
    @SerializedName("token") val token: String,
    @SerializedName("type") val type: String,
    @SerializedName("frame_available") val frameAvailable: Boolean,
    @SerializedName("frame") val frame: String,
    @SerializedName("frame_jpeg") val frameJpeg: String,
    @SerializedName("reason") val reason: String,
    @SerializedName("risk_profile") val riskProfile: String,
    @SerializedName("assurance_type") val assuranceType: String,
    @SerializedName("signals") val signals: Signals
) {
    data class Signals(
        @SerializedName("anti_spoofing") val antiSpoofing: AntiSpoofing,
        @SerializedName("matching") val matching: Matching,
        @SerializedName("multiple_faces") val multipleFaces: MultipleFaces,
        @SerializedName("return_frame_quality") val returnFrameQuality: ReturnFrameQuality
    ) {
        data class AntiSpoofing(
            @SerializedName("passed") val passed: Boolean
        )

        data class Matching(
            @SerializedName("passed") val passed: Boolean
        )

        data class MultipleFaces(
            @SerializedName("single_face") val singleFace: SingleFace,
            @SerializedName("face_consistent") val faceConsistent: FaceConsistent
        ) {
            data class SingleFace(
                @SerializedName("found") val found: Boolean
            )

            data class FaceConsistent(
                @SerializedName("passed") val passed: Boolean
            )
        }

        data class ReturnFrameQuality(
            @SerializedName("blur") val blur: String,
            @SerializedName("pose") val pose: String,
            @SerializedName("lighting") val lighting: String
        )
    }
}