package vn.kalapa.ekyc.utils

import android.app.Activity
import android.content.Context.CAMERA_SERVICE
import android.hardware.camera2.CameraAccessException
import android.hardware.camera2.CameraCharacteristics
import android.hardware.camera2.CameraManager
import android.os.Build
import android.util.SparseIntArray
import android.view.Surface
import androidx.annotation.RequiresApi
import androidx.camera.camera2.interop.Camera2CameraInfo
import androidx.camera.core.CameraInfo
import kotlin.math.atan

class CameraUtils {
    companion object {
        fun getCameraFov(cameraInfo: CameraInfo): Float {
            // Extract the camera ID
            val cameraCharacteristics = Camera2CameraInfo.extractCameraCharacteristics(cameraInfo)

            val focalLengths =
                cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS)
            val maxFocalLength = focalLengths?.maxOrNull() ?: 0.0f
            val minFocalLength = focalLengths?.minOrNull() ?: 0.0f

            val sensorSize =
                cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE)
            val sensorWidth = sensorSize?.width ?: 0.0f
            val sensorHeight = sensorSize?.height ?: 0.0f
            Helpers.printLog("cameraInfo maxFocalLength $maxFocalLength minFocalLength $minFocalLength sensorWidth $sensorWidth sensorHeight $sensorHeight ")
            val FOV = 2 * atan(sensorWidth / (2 * maxFocalLength))
            val FOVinDegree = FOV * 180 / 3.14f
            Helpers.printLog("cameraInfo FOV: $FOV $FOVinDegree")
            return FOVinDegree
        }

        private val ORIENTATIONS = SparseIntArray()

        init {
            ORIENTATIONS.append(Surface.ROTATION_0, 0)
            ORIENTATIONS.append(Surface.ROTATION_90, 90)
            ORIENTATIONS.append(Surface.ROTATION_180, 180)
            ORIENTATIONS.append(Surface.ROTATION_270, 270)
        }

        /**
         * Get the angle by which an image must be rotated given the device's current
         * orientation.
         */
        @Throws(CameraAccessException::class)
        fun getRotationCompensation(cameraId: String, activity: Activity, isFrontFacing: Boolean): Int {
            // Get the device's current rotation relative to its "native" orientation.
            // Then, from the ORIENTATIONS table, look up the angle the image must be
            // rotated to compensate for the device's rotation.
            val deviceRotation = activity.windowManager.defaultDisplay.rotation
            var rotationCompensation = ORIENTATIONS.get(deviceRotation)

            // Get the device's sensor orientation.
            val cameraManager = activity.getSystemService(CAMERA_SERVICE) as CameraManager
            val sensorOrientation = cameraManager
                .getCameraCharacteristics(cameraId)
                .get(CameraCharacteristics.SENSOR_ORIENTATION)!!

            rotationCompensation = if (isFrontFacing) {
                (sensorOrientation + rotationCompensation) % 360
            } else { // back-facing
                (sensorOrientation - rotationCompensation + 360) % 360
            }
            return rotationCompensation
        }
    }
}