/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DateUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

public class ASN1UTCTime
extends ASN1Primitive {
    private byte[] time;

    public static ASN1UTCTime getInstance(Object object) {
        if (object != null && !(object instanceof ASN1UTCTime)) {
            if (object instanceof byte[]) {
                try {
                    return (ASN1UTCTime)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(d.a(exception, b.a("encoding error in getInstance: ")));
                }
            }
            throw new IllegalArgumentException(c.a(object, b.a("illegal object in getInstance: ")));
        }
        return (ASN1UTCTime)object;
    }

    public static ASN1UTCTime getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        aSN1Primitive = aSN1Primitive.getObject();
        if (!bl && !(aSN1Primitive instanceof ASN1UTCTime)) {
            return new ASN1UTCTime(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
        }
        return ASN1UTCTime.getInstance(aSN1Primitive);
    }

    public ASN1UTCTime(String string) {
        this.time = Strings.toByteArray(string);
        try {
            this.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(b.a("invalid date string: ").append(parseException.getMessage()).toString());
        }
    }

    public ASN1UTCTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'", DateUtil.EN_Locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = Strings.toByteArray(simpleDateFormat.format(date));
    }

    public ASN1UTCTime(Date date, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'", locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = Strings.toByteArray(simpleDateFormat.format(date));
    }

    public ASN1UTCTime(byte[] byArray) {
        if (byArray.length >= 2) {
            this.time = byArray;
            if (this.isDigit(0) && this.isDigit(1)) {
                return;
            }
            throw new IllegalArgumentException("illegal characters in UTCTime string");
        }
        throw new IllegalArgumentException("UTCTime string too short");
    }

    private boolean isDigit(int n) {
        Object object;
        Object object2 = ((ASN1UTCTime)object2).time;
        return ((ASN1UTCTime)object2).time.length > n && (object = object2[n]) >= 48 && object <= 57;
    }

    public Date getDate() {
        return DateUtil.epochAdjust(new SimpleDateFormat("yyMMddHHmmssz").parse(this.getTime()));
    }

    public Date getAdjustedDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        return DateUtil.epochAdjust(simpleDateFormat.parse(this.getAdjustedTime()));
    }

    public String getTime() {
        Object object = Strings.fromByteArray(((ASN1UTCTime)object).time);
        if (((String)object).indexOf(45) < 0 && ((String)object).indexOf(43) < 0) {
            if (((String)object).length() == 11) {
                return ((String)object).substring(0, 10) + "00GMT+00:00";
            }
            return ((String)object).substring(0, 12) + "GMT+00:00";
        }
        int n = ((String)object).indexOf(45);
        if (n < 0) {
            n = ((String)object).indexOf(43);
        }
        if (n == ((String)object).length() - 3) {
            object = i.a((String)object, "00");
        }
        if (n == 10) {
            return ((String)object).substring(0, 10) + "00GMT" + ((String)object).substring(10, 13) + ":" + ((String)object).substring(13, 15);
        }
        return ((String)object).substring(0, 12) + "GMT" + ((String)object).substring(12, 15) + ":" + ((String)object).substring(15, 17);
    }

    public String getAdjustedTime() {
        if (((String)(this = ((ASN1UTCTime)this).getTime())).charAt(0) < '5') {
            return i.a("20", (String)this);
        }
        return i.a("19", (String)this);
    }

    @Override
    public boolean isConstructed() {
        return false;
    }

    @Override
    public int encodedLength() {
        int n = this.time.length;
        return StreamUtil.calculateBodyLength(n) + 1 + n;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        Object object = ((ASN1UTCTime)object).time;
        aSN1OutputStream.writeEncoded(bl, 23, (byte[])object);
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1UTCTime)) {
            return false;
        }
        return Arrays.areEqual(this.time, ((ASN1UTCTime)aSN1Primitive).time);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.time);
    }

    public String toString() {
        return Strings.fromByteArray(this.time);
    }
}

