/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Generator;
import java.io.OutputStream;

public class BERGenerator
extends ASN1Generator {
    private boolean _tagged;
    private boolean _isExplicit;
    private int _tagNo;

    public BERGenerator(OutputStream outputStream) {
        super(outputStream);
        this._tagged = false;
    }

    public BERGenerator(OutputStream outputStream, int n, boolean bl) {
        super(outputStream);
        this._tagged = true;
        this._isExplicit = bl;
        this._tagNo = n;
    }

    private void writeHdr(int n) {
        BERGenerator bERGenerator = this;
        bERGenerator._out.write(n);
        bERGenerator._out.write(128);
    }

    @Override
    public OutputStream getRawOutputStream() {
        return this._out;
    }

    public void writeBERHeader(int n) {
        if (this._tagged) {
            BERGenerator bERGenerator = this;
            int n2 = bERGenerator._tagNo | 0x80;
            if (bERGenerator._isExplicit) {
                this.writeHdr(n2 | 0x20);
                this.writeHdr(n);
            } else if ((n & 0x20) != 0) {
                this.writeHdr(n2 | 0x20);
            } else {
                this.writeHdr(n2);
            }
        } else {
            this.writeHdr(n);
        }
    }

    public void writeBEREnd() {
        BERGenerator bERGenerator = this;
        bERGenerator._out.write(0);
        bERGenerator._out.write(0);
        if (bERGenerator._tagged && this._isExplicit) {
            BERGenerator bERGenerator2 = this;
            bERGenerator2._out.write(0);
            bERGenerator2._out.write(0);
        }
    }
}

