/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;

public class DERIA5String
extends ASN1Primitive
implements ASN1String {
    private final byte[] string;

    public static DERIA5String getInstance(Object object) {
        if (object != null && !(object instanceof DERIA5String)) {
            if (object instanceof byte[]) {
                try {
                    return (DERIA5String)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(d.a(exception, b.a("encoding error in getInstance: ")));
                }
            }
            throw new IllegalArgumentException(c.a(object, b.a("illegal object in getInstance: ")));
        }
        return (DERIA5String)object;
    }

    public static DERIA5String getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        aSN1Primitive = aSN1Primitive.getObject();
        if (!bl && !(aSN1Primitive instanceof DERIA5String)) {
            return new DERIA5String(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
        }
        return DERIA5String.getInstance(aSN1Primitive);
    }

    public DERIA5String(byte[] byArray) {
        this.string = byArray;
    }

    public DERIA5String(String string) {
        this(string, false);
    }

    public DERIA5String(String string, boolean bl) {
        if (string != null) {
            if (bl && !DERIA5String.isIA5String(string)) {
                throw new IllegalArgumentException("'string' contains illegal characters");
            }
            this.string = Strings.toByteArray(string);
            return;
        }
        throw new NullPointerException("'string' cannot be null");
    }

    public static boolean isIA5String(String string) {
        for (int k = string.length() - 1; k >= 0; --k) {
            if (string.charAt(k) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    @Override
    public String getString() {
        return Strings.fromByteArray(this.string);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    @Override
    public boolean isConstructed() {
        return false;
    }

    @Override
    public int encodedLength() {
        return StreamUtil.calculateBodyLength(this.string.length) + 1 + this.string.length;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        Object object = ((DERIA5String)object).string;
        aSN1OutputStream.writeEncoded(bl, 22, (byte[])object);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERIA5String)) {
            return false;
        }
        DERIA5String dERIA5String = dERIA5String2;
        DERIA5String dERIA5String2 = (DERIA5String)aSN1Primitive;
        return Arrays.areEqual(dERIA5String.string, dERIA5String2.string);
    }
}

