/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;

public class DLSet
extends ASN1Set {
    private int bodyLength = -1;

    public DLSet() {
    }

    public DLSet(ASN1Encodable aSN1Encodable) {
        super(aSN1Encodable);
    }

    public DLSet(ASN1EncodableVector aSN1EncodableVector) {
        super(aSN1EncodableVector, false);
    }

    public DLSet(ASN1Encodable[] aSN1EncodableArray) {
        super(aSN1EncodableArray, false);
    }

    public DLSet(boolean bl, ASN1Encodable[] aSN1EncodableArray) {
        super(bl, aSN1EncodableArray);
    }

    private int getBodyLength() {
        if (this.bodyLength < 0) {
            int n = this.elements.length;
            int n2 = 0;
            for (int k = 0; k < n; ++k) {
                n2 = this.elements[k].toASN1Primitive().toDLObject().encodedLength() + n2;
            }
            this.bodyLength = n2;
        }
        return this.bodyLength;
    }

    @Override
    public int encodedLength() {
        int n = this.getBodyLength();
        return StreamUtil.calculateBodyLength(n) + 1 + n;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        if (bl) {
            aSN1OutputStream.write(49);
        }
        DLSet dLSet = this;
        ASN1OutputStream aSN1OutputStream2 = aSN1OutputStream.getDLSubStream();
        int n = dLSet.elements.length;
        if (dLSet.bodyLength < 0 && n <= 16) {
            int n2 = 0;
            ASN1Primitive[] aSN1PrimitiveArray = new ASN1Primitive[n];
            for (int k = 0; k < n; ++k) {
                ASN1Primitive aSN1Primitive;
                aSN1PrimitiveArray[k] = aSN1Primitive = this.elements[k].toASN1Primitive().toDLObject();
                n2 = aSN1Primitive.encodedLength() + n2;
            }
            this.bodyLength = n2;
            aSN1OutputStream.writeLength(n2);
            for (int k = 0; k < n; ++k) {
                aSN1OutputStream2.writePrimitive(aSN1PrimitiveArray[k], true);
            }
        } else {
            aSN1OutputStream.writeLength(this.getBodyLength());
            for (int k = 0; k < n; ++k) {
                aSN1OutputStream2.writePrimitive(this.elements[k].toASN1Primitive(), true);
            }
        }
    }

    @Override
    public ASN1Primitive toDLObject() {
        return this;
    }
}

