/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.OtherMsg;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.TaggedAttribute;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.TaggedContentInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.TaggedRequest;

public class PKIData
extends ASN1Object {
    private final TaggedAttribute[] controlSequence;
    private final TaggedRequest[] reqSequence;
    private final TaggedContentInfo[] cmsSequence;
    private final OtherMsg[] otherMsgSequence;

    public PKIData(TaggedAttribute[] taggedAttributeArray, TaggedRequest[] taggedRequestArray, TaggedContentInfo[] taggedContentInfoArray, OtherMsg[] otherMsgArray) {
        this.controlSequence = this.copy(taggedAttributeArray);
        this.reqSequence = this.copy(taggedRequestArray);
        this.cmsSequence = this.copy(taggedContentInfoArray);
        this.otherMsgSequence = this.copy(otherMsgArray);
    }

    private PKIData(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 4) {
            ASN1Object[] aSN1ObjectArray;
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(0);
            this.controlSequence = new TaggedAttribute[aSN1Sequence2.size()];
            int n = 0;
            while (true) {
                aSN1ObjectArray = this.controlSequence;
                if (n >= this.controlSequence.length) break;
                aSN1ObjectArray[n] = TaggedAttribute.getInstance(aSN1Sequence2.getObjectAt(n));
                ++n;
            }
            aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(1);
            this.reqSequence = new TaggedRequest[aSN1Sequence2.size()];
            n = 0;
            while (true) {
                aSN1ObjectArray = this.reqSequence;
                if (n >= this.reqSequence.length) break;
                aSN1ObjectArray[n] = TaggedRequest.getInstance(aSN1Sequence2.getObjectAt(n));
                ++n;
            }
            aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(2);
            this.cmsSequence = new TaggedContentInfo[aSN1Sequence2.size()];
            n = 0;
            while (true) {
                aSN1ObjectArray = this.cmsSequence;
                if (n >= this.cmsSequence.length) break;
                aSN1ObjectArray[n] = TaggedContentInfo.getInstance(aSN1Sequence2.getObjectAt(n));
                ++n;
            }
            aSN1Sequence = (ASN1Sequence)aSN1Sequence.getObjectAt(3);
            this.otherMsgSequence = new OtherMsg[aSN1Sequence.size()];
            int n2 = 0;
            while (true) {
                OtherMsg[] otherMsgArray = this.otherMsgSequence;
                if (n2 >= this.otherMsgSequence.length) break;
                otherMsgArray[n2] = OtherMsg.getInstance(aSN1Sequence.getObjectAt(n2));
                ++n2;
            }
            return;
        }
        throw new IllegalArgumentException("Sequence not 4 elements.");
    }

    public static PKIData getInstance(Object object) {
        if (object instanceof PKIData) {
            return (PKIData)object;
        }
        if (object != null) {
            return new PKIData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private TaggedAttribute[] copy(TaggedAttribute[] taggedAttributeArray) {
        int n = taggedAttributeArray.length;
        TaggedAttribute[] taggedAttributeArray2 = new TaggedAttribute[n];
        System.arraycopy(taggedAttributeArray, 0, taggedAttributeArray2, 0, n);
        return taggedAttributeArray2;
    }

    private TaggedRequest[] copy(TaggedRequest[] taggedRequestArray) {
        int n = taggedRequestArray.length;
        TaggedRequest[] taggedRequestArray2 = new TaggedRequest[n];
        System.arraycopy(taggedRequestArray, 0, taggedRequestArray2, 0, n);
        return taggedRequestArray2;
    }

    private TaggedContentInfo[] copy(TaggedContentInfo[] taggedContentInfoArray) {
        int n = taggedContentInfoArray.length;
        TaggedContentInfo[] taggedContentInfoArray2 = new TaggedContentInfo[n];
        System.arraycopy(taggedContentInfoArray, 0, taggedContentInfoArray2, 0, n);
        return taggedContentInfoArray2;
    }

    private OtherMsg[] copy(OtherMsg[] otherMsgArray) {
        int n = otherMsgArray.length;
        OtherMsg[] otherMsgArray2 = new OtherMsg[n];
        System.arraycopy(otherMsgArray, 0, otherMsgArray2, 0, n);
        return otherMsgArray2;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DERSequence dERSequence;
        DERSequence dERSequence2;
        DERSequence dERSequence3;
        DERSequence dERSequence4;
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[4];
        DERSequence dERSequence5 = dERSequence4;
        dERSequence4 = new DERSequence(this.controlSequence);
        aSN1EncodableArray[0] = dERSequence5;
        dERSequence5 = dERSequence3;
        dERSequence3 = new DERSequence(this.reqSequence);
        aSN1EncodableArray[1] = dERSequence5;
        dERSequence5 = dERSequence2;
        dERSequence2 = new DERSequence(this.cmsSequence);
        aSN1EncodableArray[2] = dERSequence5;
        dERSequence5 = dERSequence;
        dERSequence = new DERSequence(this.otherMsgSequence);
        aSN1EncodableArray[3] = dERSequence5;
        return new DERSequence(aSN1EncodableArray);
    }

    public TaggedAttribute[] getControlSequence() {
        PKIData pKIData = this;
        return pKIData.copy(pKIData.controlSequence);
    }

    public TaggedRequest[] getReqSequence() {
        PKIData pKIData = this;
        return pKIData.copy(pKIData.reqSequence);
    }

    public TaggedContentInfo[] getCmsSequence() {
        PKIData pKIData = this;
        return pKIData.copy(pKIData.cmsSequence);
    }

    public OtherMsg[] getOtherMsgSequence() {
        PKIData pKIData = this;
        return pKIData.copy(pKIData.otherMsgSequence);
    }
}

