/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class PublishTrustAnchors
extends ASN1Object {
    private final ASN1Integer seqNumber;
    private final AlgorithmIdentifier hashAlgorithm;
    private final ASN1Sequence anchorHashes;

    public PublishTrustAnchors(BigInteger object, AlgorithmIdentifier algorithmIdentifier, byte[][] byArray) {
        DERSequence dERSequence;
        ASN1EncodableVector aSN1EncodableVector;
        aSN1Object.seqNumber = new ASN1Integer((BigInteger)object);
        aSN1Object.hashAlgorithm = algorithmIdentifier;
        object = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(byArray.length);
        for (int k = 0; k != byArray.length; ++k) {
            ((ASN1EncodableVector)object).add(new DEROctetString(Arrays.clone(byArray[k])));
        }
        PublishTrustAnchors publishTrustAnchors = aSN1Object;
        ASN1Object aSN1Object = dERSequence;
        dERSequence = new DERSequence((ASN1EncodableVector)object);
        publishTrustAnchors.anchorHashes = aSN1Object;
    }

    private PublishTrustAnchors(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 3) {
            this.seqNumber = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
            this.hashAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
            this.anchorHashes = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(2));
            return;
        }
        throw new IllegalArgumentException("incorrect sequence size");
    }

    public static PublishTrustAnchors getInstance(Object object) {
        if (object instanceof PublishTrustAnchors) {
            return (PublishTrustAnchors)object;
        }
        if (object != null) {
            return new PublishTrustAnchors(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public BigInteger getSeqNumber() {
        return this.seqNumber.getValue();
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[][] getAnchorHashes() {
        int n = this.anchorHashes.size();
        byte[][] byArrayArray = new byte[n][];
        for (int k = 0; k != n; ++k) {
            byArrayArray[k] = a.a(this.anchorHashes, k);
        }
        return byArrayArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector2.add(this.seqNumber);
        aSN1EncodableVector2.add(this.hashAlgorithm);
        aSN1EncodableVector.add(this.anchorHashes);
        return new DERSequence(aSN1EncodableVector2);
    }
}

