/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class Challenge
extends ASN1Object {
    private AlgorithmIdentifier owf;
    private ASN1OctetString witness;
    private ASN1OctetString challenge;

    private Challenge(ASN1Sequence aSN1Sequence) {
        int n = 0;
        if (aSN1Sequence.size() == 3) {
            int n2 = n;
            n = 1;
            this.owf = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n2));
        }
        int n3 = n;
        int n4 = n3 + 1;
        this.witness = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(n3));
        this.challenge = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(n4));
    }

    public static Challenge getInstance(Object object) {
        if (object instanceof Challenge) {
            return (Challenge)object;
        }
        if (object != null) {
            return new Challenge(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public Challenge(byte[] byArray, byte[] byArray2) {
        this(null, byArray, byArray2);
    }

    public Challenge(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2) {
        DEROctetString dEROctetString;
        DEROctetString dEROctetString2;
        aSN1Object.owf = algorithmIdentifier;
        ASN1Object aSN1Object = dEROctetString2;
        dEROctetString2 = new DEROctetString(byArray);
        v1.witness = aSN1Object;
        aSN1Object = dEROctetString;
        dEROctetString = new DEROctetString(byArray2);
        v1.challenge = aSN1Object;
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(aSN1Encodable);
        }
    }

    public AlgorithmIdentifier getOwf() {
        return this.owf;
    }

    public byte[] getWitness() {
        return this.witness.getOctets();
    }

    public byte[] getChallenge() {
        return this.challenge.getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        Challenge challenge = this;
        aSN1EncodableVector2(3);
        challenge.addOptional(aSN1EncodableVector2, this.owf);
        aSN1EncodableVector2.add(challenge.witness);
        aSN1EncodableVector.add(this.challenge);
        return new DERSequence(aSN1EncodableVector2);
    }
}

