/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ParsingException;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1SequenceParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1SetParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObjectParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.EncryptedContentInfoParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.OriginatorInfo;

public class AuthEnvelopedDataParser {
    private ASN1SequenceParser seq;
    private ASN1Integer version;
    private ASN1Encodable nextObject;
    private boolean originatorInfoCalled;
    private EncryptedContentInfoParser authEncryptedContentInfoParser;

    public AuthEnvelopedDataParser(ASN1SequenceParser aSN1Encodable) {
        this.seq = aSN1Encodable;
        aSN1Encodable = ASN1Integer.getInstance(aSN1Encodable.readObject());
        this.version = aSN1Encodable;
        if (((ASN1Integer)aSN1Encodable).intValueExact() == 0) {
            return;
        }
        throw new ASN1ParsingException("AuthEnvelopedData version number must be 0");
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public OriginatorInfo getOriginatorInfo() {
        ASN1Encodable aSN1Encodable;
        ((AuthEnvelopedDataParser)((Object)aSN1SequenceParser)).originatorInfoCalled = true;
        if (((AuthEnvelopedDataParser)((Object)aSN1SequenceParser)).nextObject == null) {
            ((AuthEnvelopedDataParser)((Object)aSN1SequenceParser)).nextObject = ((AuthEnvelopedDataParser)((Object)aSN1SequenceParser)).seq.readObject();
        }
        if ((aSN1Encodable = ((AuthEnvelopedDataParser)((Object)aSN1SequenceParser)).nextObject) instanceof ASN1TaggedObjectParser && ((ASN1TaggedObjectParser)aSN1Encodable).getTagNo() == 0) {
            ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)((ASN1TaggedObjectParser)((AuthEnvelopedDataParser)((Object)aSN1SequenceParser)).nextObject).getObjectParser(16, false);
            v0.nextObject = null;
            return OriginatorInfo.getInstance(aSN1SequenceParser.toASN1Primitive());
        }
        return null;
    }

    public ASN1SetParser getRecipientInfos() {
        if (!this.originatorInfoCalled) {
            this.getOriginatorInfo();
        }
        if (this.nextObject == null) {
            this.nextObject = this.seq.readObject();
        }
        this.nextObject = null;
        return (ASN1SetParser)this.nextObject;
    }

    public EncryptedContentInfoParser getAuthEncryptedContentInfo() {
        ASN1Encodable aSN1Encodable;
        if (this.nextObject == null) {
            this.nextObject = this.seq.readObject();
        }
        if ((aSN1Encodable = this.nextObject) != null) {
            EncryptedContentInfoParser encryptedContentInfoParser;
            aSN1Encodable = (ASN1SequenceParser)aSN1Encodable;
            this.nextObject = null;
            EncryptedContentInfoParser encryptedContentInfoParser2 = encryptedContentInfoParser;
            encryptedContentInfoParser2((ASN1SequenceParser)aSN1Encodable);
            this.authEncryptedContentInfoParser = encryptedContentInfoParser2;
            return encryptedContentInfoParser;
        }
        return null;
    }

    public ASN1SetParser getAuthAttrs() {
        ASN1Encodable aSN1Encodable;
        if (this.nextObject == null) {
            this.nextObject = this.seq.readObject();
        }
        if ((aSN1Encodable = this.nextObject) instanceof ASN1TaggedObjectParser) {
            this.nextObject = null;
            return (ASN1SetParser)((ASN1TaggedObjectParser)aSN1Encodable).getObjectParser(17, false);
        }
        if (this.authEncryptedContentInfoParser.getContentType().equals(CMSObjectIdentifiers.data)) {
            return null;
        }
        throw new ASN1ParsingException("authAttrs must be present with non-data content");
    }

    public ASN1OctetString getMac() {
        if (((AuthEnvelopedDataParser)((Object)aSN1Encodable)).nextObject == null) {
            ((AuthEnvelopedDataParser)((Object)aSN1Encodable)).nextObject = ((AuthEnvelopedDataParser)((Object)aSN1Encodable)).seq.readObject();
        }
        ASN1Encodable aSN1Encodable = ((AuthEnvelopedDataParser)((Object)aSN1Encodable)).nextObject;
        v0.nextObject = null;
        return ASN1OctetString.getInstance(aSN1Encodable.toASN1Primitive());
    }

    public ASN1SetParser getUnauthAttrs() {
        ASN1Encodable aSN1Encodable;
        if (this.nextObject == null) {
            this.nextObject = this.seq.readObject();
        }
        if ((aSN1Encodable = this.nextObject) != null) {
            this.nextObject = null;
            return (ASN1SetParser)((ASN1TaggedObjectParser)aSN1Encodable).getObjectParser(17, false);
        }
        return null;
    }
}

