/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.ContentInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.OriginatorInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class AuthenticatedData
extends ASN1Object {
    private ASN1Integer version;
    private OriginatorInfo originatorInfo;
    private ASN1Set recipientInfos;
    private AlgorithmIdentifier macAlgorithm;
    private AlgorithmIdentifier digestAlgorithm;
    private ContentInfo encapsulatedContentInfo;
    private ASN1Set authAttrs;
    private ASN1OctetString mac;
    private ASN1Set unauthAttrs;

    public AuthenticatedData(OriginatorInfo originatorInfo, ASN1Set aSN1Set, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, ContentInfo contentInfo, ASN1Set aSN1Set2, ASN1OctetString aSN1OctetString, ASN1Set aSN1Set3) {
        if (algorithmIdentifier2 == null && aSN1Set2 == null || algorithmIdentifier2 != null && aSN1Set2 != null) {
            this.version = new ASN1Integer(AuthenticatedData.calculateVersion(originatorInfo));
            this.originatorInfo = originatorInfo;
            this.macAlgorithm = algorithmIdentifier;
            this.digestAlgorithm = algorithmIdentifier2;
            this.recipientInfos = aSN1Set;
            this.encapsulatedContentInfo = contentInfo;
            this.authAttrs = aSN1Set2;
            this.mac = aSN1OctetString;
            this.unauthAttrs = aSN1Set3;
            return;
        }
        throw new IllegalArgumentException("digestAlgorithm and authAttrs must be set together");
    }

    private AuthenticatedData(ASN1Sequence aSN1Sequence) {
        this.version = (ASN1Integer)aSN1Sequence.getObjectAt(0);
        int n = 2;
        ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(1);
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            int n2 = n;
            this.originatorInfo = OriginatorInfo.getInstance((ASN1TaggedObject)aSN1Encodable, false);
            n = 3;
            aSN1Encodable = aSN1Sequence.getObjectAt(n2);
        }
        this.recipientInfos = ASN1Set.getInstance(aSN1Encodable);
        this.macAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n++));
        if ((aSN1Encodable = aSN1Sequence.getObjectAt(n++)) instanceof ASN1TaggedObject) {
            this.digestAlgorithm = AlgorithmIdentifier.getInstance((ASN1TaggedObject)aSN1Encodable, false);
            aSN1Encodable = aSN1Sequence.getObjectAt(n++);
        }
        this.encapsulatedContentInfo = ContentInfo.getInstance(aSN1Encodable);
        if ((aSN1Encodable = aSN1Sequence.getObjectAt(n++)) instanceof ASN1TaggedObject) {
            this.authAttrs = ASN1Set.getInstance((ASN1TaggedObject)aSN1Encodable, false);
            aSN1Encodable = aSN1Sequence.getObjectAt(n++);
        }
        this.mac = ASN1OctetString.getInstance(aSN1Encodable);
        if (aSN1Sequence.size() > n) {
            this.unauthAttrs = ASN1Set.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n), false);
        }
    }

    public static AuthenticatedData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return AuthenticatedData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static AuthenticatedData getInstance(Object object) {
        if (object instanceof AuthenticatedData) {
            return (AuthenticatedData)object;
        }
        if (object != null) {
            return new AuthenticatedData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static int calculateVersion(OriginatorInfo object) {
        if (object == null) {
            return 0;
        }
        int n = 0;
        Enumeration enumeration = ((OriginatorInfo)object).getCertificates().getObjects();
        while (enumeration.hasMoreElements()) {
            Object object2 = enumeration.nextElement();
            if (!(object2 instanceof ASN1TaggedObject)) continue;
            if (((ASN1TaggedObject)(object2 = (ASN1TaggedObject)object2)).getTagNo() == 2) {
                n = 1;
                continue;
            }
            if (((ASN1TaggedObject)object2).getTagNo() != 3) continue;
            n = 3;
            break;
        }
        if (((OriginatorInfo)object).getCRLs() != null) {
            object = ((OriginatorInfo)object).getCRLs().getObjects();
            while (object.hasMoreElements()) {
                enumeration = object.nextElement();
                if (!(enumeration instanceof ASN1TaggedObject) || ((ASN1TaggedObject)((Object)enumeration)).getTagNo() != 1) continue;
                n = 3;
                break;
            }
        }
        return n;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public AlgorithmIdentifier getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public ContentInfo getEncapsulatedContentInfo() {
        return this.encapsulatedContentInfo;
    }

    public ASN1Set getAuthAttrs() {
        return this.authAttrs;
    }

    public ASN1OctetString getMac() {
        return this.mac;
    }

    public ASN1Set getUnauthAttrs() {
        return this.unauthAttrs;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(9);
        aSN1EncodableVector.add(aSN1Object2.version);
        ASN1Object aSN1Object = aSN1Object2.originatorInfo;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            dERTaggedObject2 = new DERTaggedObject(false, 0, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        aSN1EncodableVector2.add(aSN1Object2.recipientInfos);
        aSN1EncodableVector2.add(aSN1Object2.macAlgorithm);
        aSN1Object = aSN1Object2.digestAlgorithm;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            dERTaggedObject3 = new DERTaggedObject(false, 1, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        aSN1EncodableVector2.add(aSN1Object2.encapsulatedContentInfo);
        aSN1Object = aSN1Object2.authAttrs;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject4;
            dERTaggedObject = dERTaggedObject4;
            dERTaggedObject4 = new DERTaggedObject(false, 2, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        aSN1EncodableVector2.add(aSN1Object2.mac);
        ASN1Object aSN1Object2 = aSN1Object2.unauthAttrs;
        if (aSN1Object2 != null) {
            DERTaggedObject dERTaggedObject5;
            aSN1Object = dERTaggedObject5;
            dERTaggedObject5 = new DERTaggedObject(false, 3, aSN1Object2);
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new BERSequence(aSN1EncodableVector2);
    }
}

