/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf.POPOPrivKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf.POPOSigningKey;

public class ProofOfPossession
extends ASN1Object
implements ASN1Choice {
    public static final int TYPE_RA_VERIFIED = 0;
    public static final int TYPE_SIGNING_KEY = 1;
    public static final int TYPE_KEY_ENCIPHERMENT = 2;
    public static final int TYPE_KEY_AGREEMENT = 3;
    private int tagNo;
    private ASN1Encodable obj;

    private ProofOfPossession(ASN1TaggedObject aSN1TaggedObject) {
        this.tagNo = aSN1TaggedObject.getTagNo();
        switch (this.tagNo) {
            default: {
                throw new IllegalArgumentException(b.a("unknown tag: ").append(this.tagNo).toString());
            }
            case 2: 
            case 3: {
                this.obj = POPOPrivKey.getInstance(aSN1TaggedObject, true);
                break;
            }
            case 1: {
                this.obj = POPOSigningKey.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 0: {
                this.obj = DERNull.INSTANCE;
            }
        }
    }

    public static ProofOfPossession getInstance(Object object) {
        if (object != null && !(object instanceof ProofOfPossession)) {
            if (object instanceof ASN1TaggedObject) {
                return new ProofOfPossession((ASN1TaggedObject)object);
            }
            throw new IllegalArgumentException(c.a(object, b.a("Invalid object: ")));
        }
        return (ProofOfPossession)object;
    }

    public ProofOfPossession() {
        this.tagNo = 0;
        this.obj = DERNull.INSTANCE;
    }

    public ProofOfPossession(POPOSigningKey pOPOSigningKey) {
        this.tagNo = 1;
        this.obj = pOPOSigningKey;
    }

    public ProofOfPossession(int n, POPOPrivKey pOPOPrivKey) {
        this.tagNo = n;
        this.obj = pOPOPrivKey;
    }

    public int getType() {
        return this.tagNo;
    }

    public ASN1Encodable getObject() {
        return this.obj;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ProofOfPossession proofOfPossession = this;
        int n = proofOfPossession.tagNo;
        ASN1Encodable aSN1Encodable = proofOfPossession.obj;
        return new DERTaggedObject(false, n, aSN1Encodable);
    }
}

