/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ApplicationSpecific;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERApplicationSpecific;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.BidirectionalMap;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.EACObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.util.Dictionary;
import java.util.Hashtable;

public class CertificateHolderAuthorization
extends ASN1Object {
    public static final ASN1ObjectIdentifier id_role_EAC = EACObjectIdentifiers.bsi_de.branch("3.1.2.1");
    public static final int CVCA = 192;
    public static final int DV_DOMESTIC = 128;
    public static final int DV_FOREIGN = 64;
    public static final int IS = 0;
    public static final int RADG4 = 2;
    public static final int RADG3 = 1;
    public static Hashtable RightsDecodeMap = new Hashtable();
    public static BidirectionalMap AuthorizationRole = new BidirectionalMap();
    public static Hashtable ReverseMap = new Hashtable();
    public ASN1ObjectIdentifier oid;
    public ASN1ApplicationSpecific accessRights;

    public static String getRoleDescription(int n) {
        return (String)((Dictionary)AuthorizationRole).get(Integers.valueOf(n));
    }

    public static int getFlag(String string) {
        Integer n = (Integer)AuthorizationRole.getReverse(string);
        if (n != null) {
            return n;
        }
        throw new IllegalArgumentException(i.a("Unknown value ", string));
    }

    private void setPrivateData(ASN1InputStream object) {
        ASN1Primitive aSN1Primitive = ((ASN1InputStream)object).readObject();
        if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
            this.oid = (ASN1ObjectIdentifier)aSN1Primitive;
            if ((object = ((ASN1InputStream)object).readObject()) instanceof ASN1ApplicationSpecific) {
                this.accessRights = (ASN1ApplicationSpecific)object;
                return;
            }
            throw new IllegalArgumentException("No access rights in CerticateHolderAuthorization");
        }
        throw new IllegalArgumentException("no Oid in CerticateHolderAuthorization");
    }

    public CertificateHolderAuthorization(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n) {
        this.setOid(aSN1ObjectIdentifier);
        this.setAccessRights((byte)n);
    }

    public CertificateHolderAuthorization(ASN1ApplicationSpecific aSN1ApplicationSpecific) {
        if (aSN1ApplicationSpecific.getApplicationTag() == 76) {
            this.setPrivateData(new ASN1InputStream(aSN1ApplicationSpecific.getContents()));
        }
    }

    private void setAccessRights(byte by) {
        DERApplicationSpecific dERApplicationSpecific;
        CertificateHolderAuthorization certificateHolderAuthorization = object;
        byte[] byArray = new byte[1];
        Object object = byArray;
        byArray[0] = by;
        DERApplicationSpecific dERApplicationSpecific2 = dERApplicationSpecific;
        dERApplicationSpecific = new DERApplicationSpecific(19, (byte[])object);
        certificateHolderAuthorization.accessRights = dERApplicationSpecific2;
    }

    private void setOid(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.oid = aSN1ObjectIdentifier;
    }

    static {
        RightsDecodeMap.put(Integers.valueOf(2), "RADG4");
        RightsDecodeMap.put(Integers.valueOf(1), "RADG3");
        AuthorizationRole.put(Integers.valueOf(192), "CVCA");
        AuthorizationRole.put(Integers.valueOf(128), "DV_DOMESTIC");
        AuthorizationRole.put(Integers.valueOf(64), "DV_FOREIGN");
        AuthorizationRole.put(Integers.valueOf(0), "IS");
    }

    public int getAccessRights() {
        return this.accessRights.getContents()[0] & 0xFF;
    }

    public ASN1ObjectIdentifier getOid() {
        return this.oid;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(2);
        aSN1EncodableVector2.add(this.oid);
        aSN1EncodableVector.add(this.accessRights);
        return new DERApplicationSpecific(76, aSN1EncodableVector2);
    }
}

