/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.UnsignedInteger;
import java.math.BigInteger;

public class RSAPublicKey
extends PublicKeyDataObject {
    private static int modulusValid = 1;
    private static int exponentValid = 2;
    private ASN1ObjectIdentifier usage;
    private BigInteger modulus;
    private BigInteger exponent;
    private int valid = 0;

    public RSAPublicKey(ASN1Sequence object) {
        object = ((ASN1Sequence)object).getObjects();
        this.usage = ASN1ObjectIdentifier.getInstance(object.nextElement());
        while (object.hasMoreElements()) {
            UnsignedInteger unsignedInteger = UnsignedInteger.getInstance(object.nextElement());
            int n = unsignedInteger.getTagNo();
            if (n != 1) {
                if (n == 2) {
                    this.setExponent(unsignedInteger);
                    continue;
                }
                throw new IllegalArgumentException(b.a("Unknown DERTaggedObject :").append(unsignedInteger.getTagNo()).append("-> not an Iso7816RSAPublicKeyStructure").toString());
            }
            this.setModulus(unsignedInteger);
        }
        if (this.valid == 3) {
            return;
        }
        throw new IllegalArgumentException("missing argument -> not an Iso7816RSAPublicKeyStructure");
    }

    public RSAPublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, BigInteger bigInteger, BigInteger bigInteger2) {
        this.usage = aSN1ObjectIdentifier;
        this.modulus = bigInteger;
        this.exponent = bigInteger2;
    }

    private void setModulus(UnsignedInteger unsignedInteger) {
        int n = this.valid;
        int n2 = modulusValid;
        if ((n & n2) == 0) {
            this.valid = n | n2;
            this.modulus = unsignedInteger.getValue();
            return;
        }
        throw new IllegalArgumentException("Modulus already set");
    }

    private void setExponent(UnsignedInteger unsignedInteger) {
        int n = this.valid;
        int n2 = exponentValid;
        if ((n & n2) == 0) {
            this.valid = n | n2;
            this.exponent = unsignedInteger.getValue();
            return;
        }
        throw new IllegalArgumentException("Exponent already set");
    }

    @Override
    public ASN1ObjectIdentifier getUsage() {
        return this.usage;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.exponent;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector.add(this.usage);
        aSN1EncodableVector.add(new UnsignedInteger(1, this.getModulus()));
        aSN1EncodableVector.add(new UnsignedInteger(2, this.getPublicExponent()));
        return new DERSequence(aSN1EncodableVector2);
    }
}

