/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.esf;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERUTF8String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.DirectoryString;

public class SignerLocation
extends ASN1Object {
    private DirectoryString countryName;
    private DirectoryString localityName;
    private ASN1Sequence postalAddress;

    private SignerLocation(ASN1Sequence object) {
        object = ((ASN1Sequence)object).getObjects();
        while (object.hasMoreElements()) {
            ASN1Primitive aSN1Primitive = (ASN1TaggedObject)object.nextElement();
            int n = ((ASN1TaggedObject)aSN1Primitive).getTagNo();
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        this.postalAddress = ((ASN1TaggedObject)aSN1Primitive).isExplicit() ? ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Primitive, true) : ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                        aSN1Primitive = this.postalAddress;
                        if (aSN1Primitive == null || ((ASN1Sequence)aSN1Primitive).size() <= 6) continue;
                        throw new IllegalArgumentException("postal address must contain less than 6 strings");
                    }
                    throw new IllegalArgumentException("illegal tag");
                }
                this.localityName = DirectoryString.getInstance((ASN1TaggedObject)aSN1Primitive, true);
                continue;
            }
            this.countryName = DirectoryString.getInstance((ASN1TaggedObject)aSN1Primitive, true);
        }
    }

    private SignerLocation(DirectoryString directoryString, DirectoryString directoryString2, ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence != null && aSN1Sequence.size() > 6) {
            throw new IllegalArgumentException("postal address must contain less than 6 strings");
        }
        SignerLocation signerLocation = this;
        signerLocation.countryName = directoryString;
        signerLocation.localityName = directoryString2;
        signerLocation.postalAddress = aSN1Sequence;
    }

    public SignerLocation(DirectoryString directoryString, DirectoryString directoryString2, DirectoryString[] directoryStringArray) {
        DERSequence dERSequence;
        SignerLocation signerLocation = aSN1Object;
        ASN1Object aSN1Object = dERSequence;
        dERSequence = new DERSequence(directoryStringArray);
        signerLocation(directoryString, directoryString2, (ASN1Sequence)aSN1Object);
    }

    public SignerLocation(DERUTF8String dERUTF8String, DERUTF8String dERUTF8String2, ASN1Sequence aSN1Sequence) {
        SignerLocation signerLocation = aSN1Object;
        ASN1Object aSN1Object = DirectoryString.getInstance(dERUTF8String);
        signerLocation((DirectoryString)aSN1Object, DirectoryString.getInstance(dERUTF8String2), aSN1Sequence);
    }

    public static SignerLocation getInstance(Object object) {
        if (object != null && !(object instanceof SignerLocation)) {
            return new SignerLocation(ASN1Sequence.getInstance(object));
        }
        return (SignerLocation)object;
    }

    public DirectoryString getCountry() {
        return this.countryName;
    }

    public DirectoryString getLocality() {
        return this.localityName;
    }

    public DirectoryString[] getPostal() {
        ASN1Sequence aSN1Sequence = this.postalAddress;
        if (aSN1Sequence == null) {
            return null;
        }
        int n = aSN1Sequence.size();
        DirectoryString[] directoryStringArray = new DirectoryString[n];
        for (int k = 0; k != n; ++k) {
            directoryStringArray[k] = DirectoryString.getInstance(this.postalAddress.getObjectAt(k));
        }
        return directoryStringArray;
    }

    public DERUTF8String getCountryName() {
        if (this.countryName == null) {
            return null;
        }
        return new DERUTF8String(this.getCountry().getString());
    }

    public DERUTF8String getLocalityName() {
        if (this.localityName == null) {
            return null;
        }
        return new DERUTF8String(this.getLocality().getString());
    }

    public ASN1Sequence getPostalAddress() {
        return this.postalAddress;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1Sequence aSN1Sequence;
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(3);
        ASN1Object aSN1Object = this.countryName;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            dERTaggedObject2 = new DERTaggedObject(true, 0, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Object = this.localityName) != null) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            dERTaggedObject3 = new DERTaggedObject(true, 1, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Sequence = this.postalAddress) != null) {
            DERTaggedObject dERTaggedObject4;
            aSN1Object = dERTaggedObject4;
            dERTaggedObject4 = new DERTaggedObject(true, 2, aSN1Sequence);
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

