/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ocsp;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ocsp.CertID;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ocsp.CertStatus;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Extensions;

public class SingleResponse
extends ASN1Object {
    private CertID certID;
    private CertStatus certStatus;
    private ASN1GeneralizedTime thisUpdate;
    private ASN1GeneralizedTime nextUpdate;
    private Extensions singleExtensions;

    public SingleResponse(CertID certID, CertStatus certStatus, ASN1GeneralizedTime aSN1GeneralizedTime, ASN1GeneralizedTime aSN1GeneralizedTime2, X509Extensions x509Extensions) {
        SingleResponse singleResponse = aSN1Object;
        ASN1Object aSN1Object = Extensions.getInstance(x509Extensions);
        singleResponse(certID, certStatus, aSN1GeneralizedTime, aSN1GeneralizedTime2, (Extensions)aSN1Object);
    }

    public SingleResponse(CertID certID, CertStatus certStatus, ASN1GeneralizedTime aSN1GeneralizedTime, ASN1GeneralizedTime aSN1GeneralizedTime2, Extensions extensions) {
        this.certID = certID;
        this.certStatus = certStatus;
        this.thisUpdate = aSN1GeneralizedTime;
        this.nextUpdate = aSN1GeneralizedTime2;
        this.singleExtensions = extensions;
    }

    private SingleResponse(ASN1Sequence aSN1Primitive) {
        this.certID = CertID.getInstance(aSN1Primitive.getObjectAt(0));
        this.certStatus = CertStatus.getInstance(aSN1Primitive.getObjectAt(1));
        this.thisUpdate = ASN1GeneralizedTime.getInstance(aSN1Primitive.getObjectAt(2));
        if (aSN1Primitive.size() > 4) {
            this.nextUpdate = ASN1GeneralizedTime.getInstance((ASN1TaggedObject)aSN1Primitive.getObjectAt(3), true);
            this.singleExtensions = Extensions.getInstance((ASN1TaggedObject)aSN1Primitive.getObjectAt(4), true);
        } else if (aSN1Primitive.size() > 3) {
            if (((ASN1TaggedObject)(aSN1Primitive = (ASN1TaggedObject)aSN1Primitive.getObjectAt(3))).getTagNo() == 0) {
                this.nextUpdate = ASN1GeneralizedTime.getInstance((ASN1TaggedObject)aSN1Primitive, true);
            } else {
                this.singleExtensions = Extensions.getInstance((ASN1TaggedObject)aSN1Primitive, true);
            }
        }
    }

    public static SingleResponse getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SingleResponse.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static SingleResponse getInstance(Object object) {
        if (object instanceof SingleResponse) {
            return (SingleResponse)object;
        }
        if (object != null) {
            return new SingleResponse(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CertID getCertID() {
        return this.certID;
    }

    public CertStatus getCertStatus() {
        return this.certStatus;
    }

    public ASN1GeneralizedTime getThisUpdate() {
        return this.thisUpdate;
    }

    public ASN1GeneralizedTime getNextUpdate() {
        return this.nextUpdate;
    }

    public Extensions getSingleExtensions() {
        return this.singleExtensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        Extensions extensions;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(5);
        aSN1EncodableVector2.add(this.certID);
        aSN1EncodableVector2.add(this.certStatus);
        aSN1EncodableVector.add(this.thisUpdate);
        ASN1Primitive aSN1Primitive = this.nextUpdate;
        if (aSN1Primitive != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, 0, aSN1Primitive);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        if ((extensions = this.singleExtensions) != null) {
            DERTaggedObject dERTaggedObject;
            aSN1Primitive = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, 1, extensions);
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

