/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;

public class RC2CBCParameter
extends ASN1Object {
    public ASN1Integer version;
    public ASN1OctetString iv;

    public static RC2CBCParameter getInstance(Object object) {
        if (object instanceof RC2CBCParameter) {
            return (RC2CBCParameter)object;
        }
        if (object != null) {
            return new RC2CBCParameter(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public RC2CBCParameter(byte[] byArray) {
        DEROctetString dEROctetString;
        aSN1Object.version = null;
        ASN1Object aSN1Object = dEROctetString;
        dEROctetString = new DEROctetString(byArray);
        v1.iv = aSN1Object;
    }

    public RC2CBCParameter(int n, byte[] byArray) {
        this.version = new ASN1Integer(n);
        this.iv = new DEROctetString(byArray);
    }

    private RC2CBCParameter(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 1) {
            this.version = null;
            this.iv = (ASN1OctetString)aSN1Sequence.getObjectAt(0);
        } else {
            this.version = (ASN1Integer)aSN1Sequence.getObjectAt(0);
            this.iv = (ASN1OctetString)aSN1Sequence.getObjectAt(1);
        }
    }

    public BigInteger getRC2ParameterVersion() {
        ASN1Object aSN1Object = ((RC2CBCParameter)aSN1Object).version;
        if (aSN1Object == null) {
            return null;
        }
        return ((ASN1Integer)aSN1Object).getValue();
    }

    public byte[] getIV() {
        return this.iv.getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(2);
        ASN1Integer aSN1Integer = this.version;
        if (aSN1Integer != null) {
            aSN1EncodableVector2.add(aSN1Integer);
        }
        aSN1EncodableVector2.add(this.iv);
        return new DERSequence(aSN1EncodableVector2);
    }
}

