/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;

public class RSAPrivateKey
extends ASN1Object {
    private BigInteger version;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger prime1;
    private BigInteger prime2;
    private BigInteger exponent1;
    private BigInteger exponent2;
    private BigInteger coefficient;
    private ASN1Sequence otherPrimeInfos = null;

    public static RSAPrivateKey getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RSAPrivateKey.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static RSAPrivateKey getInstance(Object object) {
        if (object instanceof RSAPrivateKey) {
            return (RSAPrivateKey)object;
        }
        if (object != null) {
            return new RSAPrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.version = BigInteger.valueOf(0L);
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        this.privateExponent = bigInteger3;
        this.prime1 = bigInteger4;
        this.prime2 = bigInteger5;
        this.exponent1 = bigInteger6;
        this.exponent2 = bigInteger7;
        this.coefficient = bigInteger8;
    }

    private RSAPrivateKey(ASN1Sequence object) {
        object = ((ASN1Sequence)object).getObjects();
        ASN1Integer aSN1Integer = (ASN1Integer)object.nextElement();
        int n = aSN1Integer.intValueExact();
        if (n >= 0 && n <= 1) {
            this.version = aSN1Integer.getValue();
            this.modulus = ((ASN1Integer)object.nextElement()).getValue();
            this.publicExponent = ((ASN1Integer)object.nextElement()).getValue();
            this.privateExponent = ((ASN1Integer)object.nextElement()).getValue();
            this.prime1 = ((ASN1Integer)object.nextElement()).getValue();
            this.prime2 = ((ASN1Integer)object.nextElement()).getValue();
            this.exponent1 = ((ASN1Integer)object.nextElement()).getValue();
            this.exponent2 = ((ASN1Integer)object.nextElement()).getValue();
            this.coefficient = ((ASN1Integer)object.nextElement()).getValue();
            if (object.hasMoreElements()) {
                this.otherPrimeInfos = (ASN1Sequence)object.nextElement();
            }
            return;
        }
        throw new IllegalArgumentException("wrong version for RSA private key");
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPrime1() {
        return this.prime1;
    }

    public BigInteger getPrime2() {
        return this.prime2;
    }

    public BigInteger getExponent1() {
        return this.exponent1;
    }

    public BigInteger getExponent2() {
        return this.exponent2;
    }

    public BigInteger getCoefficient() {
        return this.coefficient;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector(10).add(new ASN1Integer(aSN1Object.version));
        aSN1EncodableVector2.add(new ASN1Integer(aSN1Object.getModulus()));
        aSN1EncodableVector2.add(new ASN1Integer(aSN1Object.getPublicExponent()));
        aSN1EncodableVector2.add(new ASN1Integer(aSN1Object.getPrivateExponent()));
        aSN1EncodableVector2.add(new ASN1Integer(aSN1Object.getPrime1()));
        aSN1EncodableVector2.add(new ASN1Integer(aSN1Object.getPrime2()));
        aSN1EncodableVector2.add(new ASN1Integer(aSN1Object.getExponent1()));
        aSN1EncodableVector2.add(new ASN1Integer(aSN1Object.getExponent2()));
        aSN1EncodableVector2.add(new ASN1Integer(aSN1Object.getCoefficient()));
        ASN1Object aSN1Object = aSN1Object.otherPrimeInfos;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

