/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SignerInfo
extends ASN1Object {
    private ASN1Integer version;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private AlgorithmIdentifier digAlgorithm;
    private ASN1Set authenticatedAttributes;
    private AlgorithmIdentifier digEncryptionAlgorithm;
    private ASN1OctetString encryptedDigest;
    private ASN1Set unauthenticatedAttributes;

    public static SignerInfo getInstance(Object object) {
        if (object instanceof SignerInfo) {
            return (SignerInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SignerInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException(c.a(object, b.a("unknown object in factory: ")));
    }

    public SignerInfo(ASN1Integer aSN1Integer, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier algorithmIdentifier, ASN1Set aSN1Set, AlgorithmIdentifier algorithmIdentifier2, ASN1OctetString aSN1OctetString, ASN1Set aSN1Set2) {
        this.version = aSN1Integer;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.digAlgorithm = algorithmIdentifier;
        this.authenticatedAttributes = aSN1Set;
        this.digEncryptionAlgorithm = algorithmIdentifier2;
        this.encryptedDigest = aSN1OctetString;
        this.unauthenticatedAttributes = aSN1Set2;
    }

    public SignerInfo(ASN1Sequence object) {
        object = ((ASN1Sequence)object).getObjects();
        this.version = (ASN1Integer)object.nextElement();
        this.issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(object.nextElement());
        this.digAlgorithm = AlgorithmIdentifier.getInstance(object.nextElement());
        Object e2 = object.nextElement();
        if (e2 instanceof ASN1TaggedObject) {
            this.authenticatedAttributes = ASN1Set.getInstance((ASN1TaggedObject)e2, false);
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(object.nextElement());
        } else {
            this.authenticatedAttributes = null;
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(e2);
        }
        this.encryptedDigest = ASN1OctetString.getInstance(object.nextElement());
        this.unauthenticatedAttributes = object.hasMoreElements() ? ASN1Set.getInstance((ASN1TaggedObject)object.nextElement(), false) : null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public ASN1Set getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digAlgorithm;
    }

    public ASN1OctetString getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return this.digEncryptionAlgorithm;
    }

    public ASN1Set getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(7);
        aSN1EncodableVector2.add(aSN1Object.version);
        aSN1EncodableVector2.add(aSN1Object.issuerAndSerialNumber);
        aSN1EncodableVector.add(aSN1Object.digAlgorithm);
        ASN1Primitive aSN1Primitive = aSN1Object.authenticatedAttributes;
        if (aSN1Primitive != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 0, aSN1Primitive);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        aSN1EncodableVector2.add(aSN1Object.digEncryptionAlgorithm);
        aSN1EncodableVector2.add(aSN1Object.encryptedDigest);
        ASN1Object aSN1Object = aSN1Object.unauthenticatedAttributes;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject;
            aSN1Primitive = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 1, aSN1Object);
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

