/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.RDN;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500NameStyle;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style.BCStyle;
import java.util.Vector;

public class X500NameBuilder {
    private X500NameStyle template;
    private Vector rdns;

    public X500NameBuilder() {
        this(BCStyle.INSTANCE);
    }

    public X500NameBuilder(X500NameStyle x500NameStyle) {
        Vector vector;
        Vector vector2 = vector;
        vector = new Vector();
        v1.rdns = vector2;
        v1.template = x500NameStyle;
    }

    public X500NameBuilder addRDN(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        X500NameBuilder x500NameBuilder = this;
        x500NameBuilder.addRDN(aSN1ObjectIdentifier, this.template.stringToValue(aSN1ObjectIdentifier, string));
        return x500NameBuilder;
    }

    public X500NameBuilder addRDN(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        X500NameBuilder x500NameBuilder = this;
        x500NameBuilder.rdns.addElement(new RDN(aSN1ObjectIdentifier, aSN1Encodable));
        return x500NameBuilder;
    }

    public X500NameBuilder addRDN(AttributeTypeAndValue attributeTypeAndValue) {
        X500NameBuilder x500NameBuilder = this;
        x500NameBuilder.rdns.addElement(new RDN(attributeTypeAndValue));
        return x500NameBuilder;
    }

    public X500NameBuilder addMultiValuedRDN(ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray, String[] stringArray) {
        int n = stringArray.length;
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[n];
        for (int k = 0; k != n; ++k) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = aSN1ObjectIdentifierArray[k];
            aSN1EncodableArray[k] = this.template.stringToValue(aSN1ObjectIdentifier, stringArray[k]);
        }
        return this.addMultiValuedRDN(aSN1ObjectIdentifierArray, aSN1EncodableArray);
    }

    public X500NameBuilder addMultiValuedRDN(ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray, ASN1Encodable[] aSN1EncodableArray) {
        AttributeTypeAndValue[] attributeTypeAndValueArray = new AttributeTypeAndValue[aSN1ObjectIdentifierArray.length];
        for (int k = 0; k != aSN1ObjectIdentifierArray.length; ++k) {
            AttributeTypeAndValue attributeTypeAndValue;
            AttributeTypeAndValue attributeTypeAndValue2 = attributeTypeAndValue;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = aSN1ObjectIdentifierArray[k];
            attributeTypeAndValue = new AttributeTypeAndValue(aSN1ObjectIdentifier, aSN1EncodableArray[k]);
            attributeTypeAndValueArray[k] = attributeTypeAndValue2;
        }
        return this.addMultiValuedRDN(attributeTypeAndValueArray);
    }

    public X500NameBuilder addMultiValuedRDN(AttributeTypeAndValue[] attributeTypeAndValueArray) {
        X500NameBuilder x500NameBuilder = this;
        x500NameBuilder.rdns.addElement(new RDN(attributeTypeAndValueArray));
        return x500NameBuilder;
    }

    public X500Name build() {
        int n = this.rdns.size();
        RDN[] rDNArray = new RDN[n];
        for (int k = 0; k != n; ++k) {
            rDNArray[k] = (RDN)this.rdns.elementAt(k);
        }
        return new X500Name(this.template, rDNArray);
    }
}

