/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERUniversalString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.j;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.RDN;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500NameBuilder;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500NameStyle;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style.X500NameTokenizer;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IETFUtils {
    private static String unescape(String string) {
        if (string.length() != 0 && (string.indexOf(92) >= 0 || string.indexOf(34) >= 0)) {
            StringBuffer stringBuffer;
            char[] cArray = string.toCharArray();
            boolean bl = false;
            boolean bl2 = false;
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer = new StringBuffer(string.length());
            int n = 0;
            if (cArray[0] == '\\' && cArray[1] == '#') {
                n = 2;
                stringBuffer2.append("\\#");
            }
            boolean bl3 = false;
            int n2 = 0;
            char c2 = '\u0000';
            while (n != cArray.length) {
                char c3 = cArray[n];
                if (c3 != ' ') {
                    bl3 = true;
                }
                if (c3 == '\"') {
                    if (!bl) {
                        bl2 ^= true;
                    } else {
                        stringBuffer2.append(c3);
                    }
                    bl = false;
                } else if (c3 == '\\' && !bl && !bl2) {
                    bl = true;
                    n2 = stringBuffer2.length();
                } else if (c3 != ' ' || bl || bl3) {
                    if (bl && IETFUtils.isHexDigit(c3)) {
                        if (c2 != '\u0000') {
                            stringBuffer2.append((char)(IETFUtils.convertHex(c2) * 16 + IETFUtils.convertHex(c3)));
                            bl = false;
                            c2 = '\u0000';
                        } else {
                            c2 = c3;
                        }
                    } else {
                        stringBuffer2.append(c3);
                        bl = false;
                    }
                }
                ++n;
            }
            if (stringBuffer2.length() > 0) {
                while (true) {
                    StringBuffer stringBuffer3 = stringBuffer2;
                    if (stringBuffer3.charAt(stringBuffer3.length() - 1) != ' ' || n2 == stringBuffer2.length() - 1) break;
                    StringBuffer stringBuffer4 = stringBuffer2;
                    stringBuffer4.setLength(stringBuffer4.length() - 1);
                }
            }
            return stringBuffer2.toString();
        }
        return string.trim();
    }

    private static boolean isHexDigit(char c2) {
        return '0' <= c2 && c2 <= '9' || 'a' <= c2 && c2 <= 'f' || 'A' <= c2 && c2 <= 'F';
    }

    private static int convertHex(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return c2 - 48;
        }
        if ('a' <= c2 && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        return c2 - 65 + 10;
    }

    public static RDN[] rDNsFromString(String object, X500NameStyle x500NameStyle) {
        X500NameBuilder x500NameBuilder;
        X500NameTokenizer x500NameTokenizer;
        X500NameTokenizer x500NameTokenizer2 = x500NameTokenizer;
        x500NameTokenizer = new X500NameTokenizer((String)object);
        object = x500NameBuilder;
        x500NameBuilder = new X500NameBuilder(x500NameStyle);
        while (x500NameTokenizer2.hasMoreTokens()) {
            X500NameTokenizer x500NameTokenizer3;
            X500NameTokenizer x500NameTokenizer4;
            Object object2 = x500NameTokenizer2.nextToken();
            if (object2.indexOf(43) > 0) {
                X500NameTokenizer x500NameTokenizer5;
                X500NameTokenizer x500NameTokenizer6;
                x500NameTokenizer4 = x500NameTokenizer6;
                x500NameTokenizer6 = new X500NameTokenizer((String)object2, '+');
                object2 = x500NameTokenizer5;
                Object object3 = new X500NameTokenizer(x500NameTokenizer4.nextToken(), '=').nextToken();
                if (object2.hasMoreTokens()) {
                    object2 = object2.nextToken();
                    object3 = x500NameStyle.attrNameToOID(((String)object3).trim());
                    if (x500NameTokenizer4.hasMoreTokens()) {
                        Vector<String> vector;
                        Vector<Object> vector2;
                        Vector<Object> vector3 = vector2;
                        vector2 = new Vector<Object>();
                        Vector<String> vector4 = vector;
                        vector4();
                        vector3.addElement(object3);
                        vector.addElement(IETFUtils.unescape((String)object2));
                        while (x500NameTokenizer4.hasMoreTokens()) {
                            X500NameTokenizer x500NameTokenizer7;
                            object2 = x500NameTokenizer7;
                            object3 = new X500NameTokenizer(x500NameTokenizer4.nextToken(), '=').nextToken();
                            if (object2.hasMoreTokens()) {
                                object2 = object2.nextToken();
                                vector3.addElement(x500NameStyle.attrNameToOID(((String)object3).trim()));
                                vector4.addElement(IETFUtils.unescape((String)object2));
                                continue;
                            }
                            throw new IllegalArgumentException("badly formatted directory string");
                        }
                        object2 = IETFUtils.toOIDArray(vector3);
                        ((X500NameBuilder)object).addMultiValuedRDN((ASN1ObjectIdentifier[])object2, IETFUtils.toValueArray(vector4));
                        continue;
                    }
                    ((X500NameBuilder)object).addRDN((ASN1ObjectIdentifier)object3, IETFUtils.unescape((String)object2));
                    continue;
                }
                throw new IllegalArgumentException("badly formatted directory string");
            }
            x500NameTokenizer4 = x500NameTokenizer3;
            object2 = new X500NameTokenizer((String)object2, '=').nextToken();
            if (x500NameTokenizer4.hasMoreTokens()) {
                object2 = x500NameStyle.attrNameToOID(object2.trim());
                ((X500NameBuilder)object).addRDN((ASN1ObjectIdentifier)object2, IETFUtils.unescape(x500NameTokenizer4.nextToken()));
                continue;
            }
            throw new IllegalArgumentException("badly formatted directory string");
        }
        return ((X500NameBuilder)object).build().getRDNs();
    }

    private static String[] toValueArray(Vector vector) {
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int k = 0; k != n; ++k) {
            stringArray[k] = (String)vector.elementAt(k);
        }
        return stringArray;
    }

    private static ASN1ObjectIdentifier[] toOIDArray(Vector vector) {
        int n = vector.size();
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = new ASN1ObjectIdentifier[n];
        for (int k = 0; k != n; ++k) {
            aSN1ObjectIdentifierArray[k] = (ASN1ObjectIdentifier)vector.elementAt(k);
        }
        return aSN1ObjectIdentifierArray;
    }

    public static String[] findAttrNamesForOID(ASN1ObjectIdentifier aSN1ObjectIdentifier, Hashtable hashtable) {
        int n = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            if (!aSN1ObjectIdentifier.equals(enumeration.nextElement())) continue;
            ++n;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        Enumeration enumeration2 = hashtable.keys();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            if (!aSN1ObjectIdentifier.equals(hashtable.get(string))) continue;
            int n3 = n2 + 1;
            stringArray[n2] = string;
            n2 = n3;
        }
        return stringArray;
    }

    public static ASN1ObjectIdentifier decodeAttrName(String string, Hashtable object) {
        if (Strings.toUpperCase(string).startsWith("OID.")) {
            return new ASN1ObjectIdentifier(string.substring(4));
        }
        if (string.charAt(0) >= '0' && string.charAt(0) <= '9') {
            return new ASN1ObjectIdentifier(string);
        }
        if ((object = (ASN1ObjectIdentifier)((Hashtable)object).get(Strings.toLowerCase(string))) != null) {
            return object;
        }
        throw new IllegalArgumentException(g.a("Unknown object id - ", string, " - passed to distinguished name"));
    }

    public static ASN1Encodable valueFromHexString(String string, int n) {
        int n2 = (string.length() - n) / 2;
        byte[] byArray = new byte[n2];
        for (int k = 0; k != n2; ++k) {
            int n3 = k * 2 + n;
            char c2 = string.charAt(n3);
            byArray[k] = (byte)(IETFUtils.convertHex(c2) << 4 | IETFUtils.convertHex(string.charAt(n3 + 1)));
        }
        return ASN1Primitive.fromByteArray(byArray);
    }

    public static void appendRDN(StringBuffer stringBuffer, RDN attributeTypeAndValueArray, Hashtable hashtable) {
        if (attributeTypeAndValueArray.isMultiValued()) {
            attributeTypeAndValueArray = attributeTypeAndValueArray.getTypesAndValues();
            boolean bl = true;
            for (int k = 0; k != attributeTypeAndValueArray.length; ++k) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append('+');
                }
                IETFUtils.appendTypeAndValue(stringBuffer, attributeTypeAndValueArray[k], hashtable);
            }
        } else if (attributeTypeAndValueArray.getFirst() != null) {
            IETFUtils.appendTypeAndValue(stringBuffer, attributeTypeAndValueArray.getFirst(), hashtable);
        }
    }

    public static void appendTypeAndValue(StringBuffer stringBuffer, AttributeTypeAndValue attributeTypeAndValue, Hashtable object) {
        if ((object = (String)((Hashtable)object).get(attributeTypeAndValue.getType())) != null) {
            stringBuffer.append((String)object);
        } else {
            stringBuffer.append(attributeTypeAndValue.getType().getId());
        }
        stringBuffer.append('=');
        stringBuffer.append(IETFUtils.valueToString(attributeTypeAndValue.getValue()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String valueToString(ASN1Encodable object) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        if (object instanceof ASN1String && !(object instanceof DERUniversalString)) {
            if (((String)(object = ((ASN1String)object).getString())).length() > 0 && ((String)object).charAt(0) == '#') {
                stringBuffer2.append('\\');
            }
            stringBuffer2.append((String)object);
        } else {
            Object object2;
            StringBuffer stringBuffer3;
            try {
                stringBuffer3 = stringBuffer2;
                object2 = object;
                stringBuffer2.append('#');
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Other value has no encoded form");
            }
            {
                stringBuffer3.append(Hex.toHexString(object2.toASN1Primitive().getEncoded("DER")));
            }
        }
        StringBuffer stringBuffer4 = stringBuffer2;
        int n = stringBuffer4.length();
        int n2 = 0;
        if (stringBuffer4.length() >= 2 && stringBuffer2.charAt(0) == '\\' && stringBuffer2.charAt(1) == '#') {
            n2 = 2;
        }
        block6: while (n2 != n) {
            char c2 = stringBuffer2.charAt(n2);
            if (c2 != '\"' && c2 != '\\' && c2 != '+' && c2 != ',') {
                switch (c2) {
                    default: {
                        ++n2;
                        continue block6;
                    }
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                }
            }
            stringBuffer2.insert(n2, "\\");
            n2 += 2;
            ++n;
        }
        if (stringBuffer2.length() > 0) {
            for (n = 0; stringBuffer2.length() > n && stringBuffer2.charAt(n) == ' '; n += 2) {
                stringBuffer2.insert(n, "\\");
            }
        }
        for (n = stringBuffer2.length() - 1; n >= 0 && stringBuffer2.charAt(n) == ' '; --n) {
            stringBuffer2.insert(n, '\\');
        }
        return stringBuffer2.toString();
    }

    public static String canonicalize(String string) {
        int n;
        int n2;
        ASN1Primitive aSN1Primitive;
        if (string.length() > 0 && string.charAt(0) == '#' && (aSN1Primitive = IETFUtils.decodeObject(string)) instanceof ASN1String) {
            string = ((ASN1String)((Object)aSN1Primitive)).getString();
        }
        if ((n2 = (string = Strings.toLowerCase(string)).length()) < 2) {
            return string;
        }
        int n3 = n2;
        int n4 = n3 - 1;
        for (n2 = 0; n2 < n4 && string.charAt(n2) == '\\' && string.charAt(n2 + 1) == ' '; n2 += 2) {
        }
        int n5 = n2 + 1;
        for (n = n4; n > n5 && string.charAt(n - 1) == '\\' && string.charAt(n) == ' '; n -= 2) {
        }
        if (n2 > 0 || n < n4) {
            string = string.substring(n2, n + 1);
        }
        return IETFUtils.stripInternalSpaces(string);
    }

    public static String canonicalString(ASN1Encodable aSN1Encodable) {
        return IETFUtils.canonicalize(IETFUtils.valueToString(aSN1Encodable));
    }

    private static ASN1Primitive decodeObject(String string) {
        int n;
        try {
            n = string.length();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(j.a("unknown encoding in name: ", iOException));
        }
        return ASN1Primitive.fromByteArray(Hex.decodeStrict(string, 1, n - 1));
    }

    public static String stripInternalSpaces(String string) {
        StringBuffer stringBuffer;
        if (string.indexOf("  ") < 0) {
            return string;
        }
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer2();
        char c2 = string.charAt(0);
        stringBuffer.append(c2);
        for (int k = 1; k < string.length(); ++k) {
            char c3 = string.charAt(k);
            if (c2 == ' ' && c3 == ' ') continue;
            stringBuffer2.append(c3);
            c2 = c3;
        }
        return stringBuffer2.toString();
    }

    public static boolean rDNAreEqual(RDN attributeTypeAndValueArray, RDN attributeTypeAndValueArray2) {
        if (attributeTypeAndValueArray.size() != attributeTypeAndValueArray2.size()) {
            return false;
        }
        if ((attributeTypeAndValueArray = attributeTypeAndValueArray.getTypesAndValues()).length != (attributeTypeAndValueArray2 = attributeTypeAndValueArray2.getTypesAndValues()).length) {
            return false;
        }
        for (int k = 0; k != attributeTypeAndValueArray.length; ++k) {
            if (IETFUtils.atvAreEqual(attributeTypeAndValueArray[k], attributeTypeAndValueArray2[k])) continue;
            return false;
        }
        return true;
    }

    private static boolean atvAreEqual(AttributeTypeAndValue attributeTypeAndValue, AttributeTypeAndValue attributeTypeAndValue2) {
        if (attributeTypeAndValue == attributeTypeAndValue2) {
            return true;
        }
        if (attributeTypeAndValue != null && attributeTypeAndValue2 != null) {
            if (!attributeTypeAndValue.getType().equals(attributeTypeAndValue2.getType())) {
                return false;
            }
            return IETFUtils.canonicalString(attributeTypeAndValue.getValue()).equals(IETFUtils.canonicalString(attributeTypeAndValue2.getValue()));
        }
        return false;
    }
}

