/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERIA5String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.IPAddress;
import java.io.IOException;
import java.util.StringTokenizer;

public class GeneralName
extends ASN1Object
implements ASN1Choice {
    public static final int otherName = 0;
    public static final int rfc822Name = 1;
    public static final int dNSName = 2;
    public static final int x400Address = 3;
    public static final int directoryName = 4;
    public static final int ediPartyName = 5;
    public static final int uniformResourceIdentifier = 6;
    public static final int iPAddress = 7;
    public static final int registeredID = 8;
    private ASN1Encodable obj;
    private int tag;

    public GeneralName(X509Name x509Name) {
        GeneralName generalName = this;
        generalName.obj = X500Name.getInstance(x509Name);
        generalName.tag = 4;
    }

    public GeneralName(X500Name x500Name) {
        this.obj = x500Name;
        this.tag = 4;
    }

    public GeneralName(int n, ASN1Encodable aSN1Encodable) {
        this.obj = aSN1Encodable;
        this.tag = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneralName(int n, String string) {
        ASN1Object aSN1Object;
        ((GeneralName)aSN1Object).tag = n;
        if (n != 1 && n != 2 && n != 6) {
            if (n == 8) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier;
                ASN1Object aSN1Object2 = aSN1Object;
                aSN1Object = aSN1ObjectIdentifier;
                aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
                aSN1Object2.obj = aSN1Object;
                return;
            } else if (n == 4) {
                X500Name x500Name;
                ASN1Object aSN1Object3 = aSN1Object;
                aSN1Object = x500Name;
                x500Name = new X500Name(string);
                aSN1Object3.obj = aSN1Object;
                return;
            } else {
                DEROctetString dEROctetString;
                if (n != 7) throw new IllegalArgumentException(a.a("can't process String for tag: ", n));
                byte[] byArray = ((GeneralName)aSN1Object).toGeneralNameEncoding(string);
                if (byArray == null) throw new IllegalArgumentException("IP Address is invalid");
                ASN1Object aSN1Object4 = aSN1Object;
                aSN1Object = dEROctetString;
                dEROctetString = new DEROctetString(byArray);
                ((GeneralName)aSN1Object4).obj = aSN1Object;
            }
            return;
        } else {
            DERIA5String dERIA5String;
            GeneralName generalName = aSN1Object;
            aSN1Object = dERIA5String;
            dERIA5String = new DERIA5String(string);
            generalName.obj = aSN1Object;
        }
    }

    public static GeneralName getInstance(Object object) {
        if (object != null && !(object instanceof GeneralName)) {
            if (object instanceof ASN1TaggedObject) {
                object = (ASN1TaggedObject)object;
                int n = ((ASN1TaggedObject)object).getTagNo();
                switch (n) {
                    default: {
                        throw new IllegalArgumentException(a.a("unknown tag: ", n));
                    }
                    case 8: {
                        return new GeneralName(n, ASN1ObjectIdentifier.getInstance((ASN1TaggedObject)object, false));
                    }
                    case 7: {
                        return new GeneralName(n, ASN1OctetString.getInstance((ASN1TaggedObject)object, false));
                    }
                    case 4: {
                        return new GeneralName(n, X500Name.getInstance((ASN1TaggedObject)object, true));
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        return new GeneralName(n, DERIA5String.getInstance((ASN1TaggedObject)object, false));
                    }
                    case 0: 
                    case 3: 
                    case 5: 
                }
                return new GeneralName(n, ASN1Sequence.getInstance((ASN1TaggedObject)object, false));
            }
            if (object instanceof byte[]) {
                try {
                    return GeneralName.getInstance(ASN1Primitive.fromByteArray((byte[])object));
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("unable to parse encoded general name");
                }
            }
            throw new IllegalArgumentException(c.a(object, b.a("unknown object in getInstance: ")));
        }
        return (GeneralName)object;
    }

    public static GeneralName getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return GeneralName.getInstance(ASN1TaggedObject.getInstance(aSN1TaggedObject, true));
    }

    private byte[] toGeneralNameEncoding(String object) {
        if (!IPAddress.isValidIPv6WithNetmask((String)object) && !IPAddress.isValidIPv6((String)object)) {
            if (!IPAddress.isValidIPv4WithNetmask((String)object) && !IPAddress.isValidIPv4((String)object)) {
                return null;
            }
            int n = ((String)object).indexOf(47);
            if (n < 0) {
                byte[] byArray = new byte[4];
                this.parseIPv4((String)object, byArray, 0);
                return byArray;
            }
            String string = object;
            Object object2 = object;
            object = new byte[8];
            this.parseIPv4(((String)object2).substring(0, n), (byte[])object, 0);
            String string2 = string.substring(n + 1);
            if (string2.indexOf(46) > 0) {
                this.parseIPv4(string2, (byte[])object, 4);
            } else {
                this.parseIPv4Mask(string2, (byte[])object, 4);
            }
            return object;
        }
        int n = ((String)object).indexOf(47);
        if (n < 0) {
            byte[] byArray = new byte[16];
            GeneralName generalName = this;
            generalName.copyInts(generalName.parseIPv6((String)object), byArray, 0);
            return byArray;
        }
        String string = object;
        GeneralName generalName = this;
        String string3 = object;
        object = new byte[32];
        generalName.copyInts(generalName.parseIPv6(string3.substring(0, n)), (byte[])object, 0);
        Object object3 = string.substring(n + 1);
        object3 = ((String)object3).indexOf(58) > 0 ? (Object)this.parseIPv6((String)object3) : (Object)this.parseMask((String)object3);
        this.copyInts((int[])object3, (byte[])object, 16);
        return object;
    }

    private void parseIPv4Mask(String string, byte[] byArray, int n) {
        int n2 = Integer.parseInt(string);
        for (int k = 0; k != n2; ++k) {
            int n3 = k / 8 + n;
            byArray[n3] = (byte)(byArray[n3] | 1 << 7 - k % 8);
        }
    }

    private void parseIPv4(String string, byte[] byArray, int n) {
        StringTokenizer stringTokenizer;
        StringTokenizer stringTokenizer2 = stringTokenizer;
        stringTokenizer = new StringTokenizer(string, "./");
        int n2 = 0;
        while (stringTokenizer2.hasMoreTokens()) {
            byArray[n + n2++] = (byte)Integer.parseInt(stringTokenizer2.nextToken());
        }
    }

    private int[] parseMask(String string) {
        Object object = new int[8];
        int n = Integer.parseInt(string);
        for (int k = 0; k != n; ++k) {
            Object object2 = object;
            int n2 = k / 16;
            object2[n2] = object2[n2] | 1 << 15 - k % 16;
        }
        return object;
    }

    private void copyInts(int[] nArray, byte[] byArray, int n) {
        int n2 = 0;
        while (n2 != nArray.length) {
            int n3 = n2++;
            int n4 = n3 * 2;
            int n5 = n4 + n;
            int n6 = nArray[n3];
            byArray[n5] = (byte)(n6 >> 8);
            n4 = n4 + 1 + n;
            byArray[n4] = (byte)n6;
        }
    }

    private int[] parseIPv6(String string) {
        StringTokenizer stringTokenizer;
        StringTokenizer stringTokenizer2 = stringTokenizer;
        stringTokenizer = new StringTokenizer(string, ":", true);
        int n = 0;
        int n2 = 8;
        int[] nArray = new int[8];
        if (string.charAt(0) == ':' && string.charAt(1) == ':') {
            stringTokenizer2.nextToken();
        }
        int n3 = -1;
        while (stringTokenizer2.hasMoreTokens()) {
            StringTokenizer stringTokenizer3;
            String string2 = stringTokenizer2.nextToken();
            if (string2.equals(":")) {
                n3 = n + 1;
                nArray[n] = 0;
                int n4 = n3;
                n3 = n;
                n = n4;
                continue;
            }
            if (string2.indexOf(46) < 0) {
                nArray[n++] = Integer.parseInt(string2, 16);
                if (!stringTokenizer2.hasMoreTokens()) continue;
                stringTokenizer2.nextToken();
                continue;
            }
            StringTokenizer stringTokenizer4 = stringTokenizer3;
            nArray[n++] = Integer.parseInt(new StringTokenizer(string2, ".").nextToken()) << 8 | Integer.parseInt(stringTokenizer4.nextToken());
            nArray[n++] = Integer.parseInt(stringTokenizer4.nextToken()) << 8 | Integer.parseInt(stringTokenizer4.nextToken());
        }
        if (n != n2) {
            int n5 = n - n3;
            n = n2 - n5;
            System.arraycopy(nArray, n3, nArray, n, n5);
            while (n3 != n) {
                nArray[n3] = 0;
                ++n3;
            }
        }
        return nArray;
    }

    public int getTagNo() {
        return this.tag;
    }

    public ASN1Encodable getName() {
        return this.obj;
    }

    public String toString() {
        StringBuffer stringBuffer;
        block2: {
            block0: {
                block1: {
                    StringBuffer stringBuffer2;
                    stringBuffer = stringBuffer2;
                    stringBuffer();
                    stringBuffer2.append(this.tag);
                    stringBuffer2.append(": ");
                    int n = this.tag;
                    if (n == 1 || n == 2) break block0;
                    if (n == 4) break block1;
                    if (n == 6) break block0;
                    stringBuffer.append(this.obj.toString());
                    break block2;
                }
                stringBuffer.append(X500Name.getInstance(this.obj).toString());
                break block2;
            }
            stringBuffer.append(DERIA5String.getInstance(this.obj).getString());
        }
        return stringBuffer.toString();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        int n = aSN1Encodable.tag;
        boolean bl = n == 4;
        ASN1Encodable aSN1Encodable = aSN1Encodable.obj;
        return new DERTaggedObject(bl, n, aSN1Encodable);
    }
}

