/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;
import java.math.BigInteger;

public class IssuerSerial
extends ASN1Object {
    public GeneralNames issuer;
    public ASN1Integer serial;
    public DERBitString issuerUID;

    public static IssuerSerial getInstance(Object object) {
        if (object instanceof IssuerSerial) {
            return (IssuerSerial)object;
        }
        if (object != null) {
            return new IssuerSerial(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static IssuerSerial getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return IssuerSerial.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    private IssuerSerial(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2 && aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("Bad sequence size: ")));
        }
        this.issuer = GeneralNames.getInstance(aSN1Sequence.getObjectAt(0));
        this.serial = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.size() == 3) {
            this.issuerUID = DERBitString.getInstance(aSN1Sequence.getObjectAt(2));
        }
    }

    public IssuerSerial(X500Name aSN1Object, BigInteger bigInteger) {
        ASN1Integer aSN1Integer;
        GeneralName generalName;
        GeneralNames generalNames;
        IssuerSerial issuerSerial = aSN1Object2;
        ASN1Object aSN1Object2 = generalNames;
        GeneralName generalName2 = generalName;
        generalName = new GeneralName((X500Name)aSN1Object);
        generalNames = new GeneralNames(generalName2);
        aSN1Object = aSN1Integer;
        aSN1Integer = new ASN1Integer(bigInteger);
        issuerSerial((GeneralNames)aSN1Object2, (ASN1Integer)aSN1Object);
    }

    public IssuerSerial(GeneralNames generalNames, BigInteger bigInteger) {
        ASN1Integer aSN1Integer;
        IssuerSerial issuerSerial = aSN1Object;
        ASN1Object aSN1Object = aSN1Integer;
        aSN1Integer = new ASN1Integer(bigInteger);
        issuerSerial(generalNames, (ASN1Integer)aSN1Object);
    }

    public IssuerSerial(GeneralNames generalNames, ASN1Integer aSN1Integer) {
        this.issuer = generalNames;
        this.serial = aSN1Integer;
    }

    public GeneralNames getIssuer() {
        return this.issuer;
    }

    public ASN1Integer getSerial() {
        return this.serial;
    }

    public DERBitString getIssuerUID() {
        return this.issuerUID;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector2.add(aSN1Object.issuer);
        aSN1EncodableVector.add(aSN1Object.serial);
        ASN1Object aSN1Object = aSN1Object.issuerUID;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

