/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.DHValidationParms;
import java.math.BigInteger;
import java.util.Enumeration;

public class DHDomainParameters
extends ASN1Object {
    private ASN1Integer p;
    private ASN1Integer g;
    private ASN1Integer q;
    private ASN1Integer j;
    private DHValidationParms validationParms;

    public static DHDomainParameters getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DHDomainParameters.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static DHDomainParameters getInstance(Object object) {
        if (object != null && !(object instanceof DHDomainParameters)) {
            if (object instanceof ASN1Sequence) {
                return new DHDomainParameters((ASN1Sequence)object);
            }
            throw new IllegalArgumentException(c.a(object, b.b.a("Invalid DHDomainParameters: ")));
        }
        return (DHDomainParameters)object;
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, DHValidationParms dHValidationParms) {
        if (bigInteger != null) {
            if (bigInteger2 != null) {
                if (bigInteger3 != null) {
                    ASN1Integer aSN1Integer;
                    ASN1Integer aSN1Integer2;
                    ASN1Integer aSN1Integer3;
                    ASN1Integer aSN1Integer4;
                    DHDomainParameters dHDomainParameters = aSN1Object;
                    ASN1Object aSN1Object = aSN1Integer4;
                    aSN1Integer4 = new ASN1Integer(bigInteger);
                    dHDomainParameters.p = aSN1Object;
                    aSN1Object = aSN1Integer3;
                    aSN1Integer3 = new ASN1Integer(bigInteger2);
                    dHDomainParameters.g = aSN1Object;
                    aSN1Object = aSN1Integer2;
                    aSN1Integer2 = new ASN1Integer(bigInteger3);
                    dHDomainParameters.q = aSN1Object;
                    aSN1Object = aSN1Integer;
                    aSN1Integer = new ASN1Integer(bigInteger4);
                    dHDomainParameters.j = aSN1Object;
                    dHDomainParameters.validationParms = dHValidationParms;
                    return;
                }
                throw new IllegalArgumentException("'q' cannot be null");
            }
            throw new IllegalArgumentException("'g' cannot be null");
        }
        throw new IllegalArgumentException("'p' cannot be null");
    }

    public DHDomainParameters(ASN1Integer aSN1Integer, ASN1Integer aSN1Integer2, ASN1Integer aSN1Integer3, ASN1Integer aSN1Integer4, DHValidationParms dHValidationParms) {
        if (aSN1Integer != null) {
            if (aSN1Integer2 != null) {
                if (aSN1Integer3 != null) {
                    DHDomainParameters dHDomainParameters = this;
                    dHDomainParameters.p = aSN1Integer;
                    dHDomainParameters.g = aSN1Integer2;
                    dHDomainParameters.q = aSN1Integer3;
                    dHDomainParameters.j = aSN1Integer4;
                    dHDomainParameters.validationParms = dHValidationParms;
                    return;
                }
                throw new IllegalArgumentException("'q' cannot be null");
            }
            throw new IllegalArgumentException("'g' cannot be null");
        }
        throw new IllegalArgumentException("'p' cannot be null");
    }

    private DHDomainParameters(ASN1Sequence object) {
        if (((ASN1Sequence)object).size() >= 3 && ((ASN1Sequence)object).size() <= 5) {
            object = ((ASN1Sequence)object).getObjects();
            this.p = ASN1Integer.getInstance(object.nextElement());
            this.g = ASN1Integer.getInstance(object.nextElement());
            this.q = ASN1Integer.getInstance(object.nextElement());
            ASN1Encodable aSN1Encodable = DHDomainParameters.getNext((Enumeration)object);
            if (aSN1Encodable != null && aSN1Encodable instanceof ASN1Integer) {
                this.j = ASN1Integer.getInstance(aSN1Encodable);
                aSN1Encodable = DHDomainParameters.getNext((Enumeration)object);
            }
            if (aSN1Encodable != null) {
                this.validationParms = DHValidationParms.getInstance(aSN1Encodable.toASN1Primitive());
            }
            return;
        }
        throw new IllegalArgumentException(b.a((ASN1Sequence)object, b.b.a("Bad sequence size: ")));
    }

    private static ASN1Encodable getNext(Enumeration enumeration) {
        return enumeration.hasMoreElements() ? (ASN1Encodable)enumeration.nextElement() : null;
    }

    public ASN1Integer getP() {
        return this.p;
    }

    public ASN1Integer getG() {
        return this.g;
    }

    public ASN1Integer getQ() {
        return this.q;
    }

    public ASN1Integer getJ() {
        return this.j;
    }

    public DHValidationParms getValidationParms() {
        return this.validationParms;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DHValidationParms dHValidationParms;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(5);
        aSN1EncodableVector2.add(this.p);
        aSN1EncodableVector2.add(this.g);
        aSN1EncodableVector.add(this.q);
        ASN1Integer aSN1Integer = this.j;
        if (aSN1Integer != null) {
            aSN1EncodableVector2.add(aSN1Integer);
        }
        if ((dHValidationParms = this.validationParms) != null) {
            aSN1EncodableVector2.add(dHValidationParms);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

