/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class X9ECPoint
extends ASN1Object {
    private final ASN1OctetString encoding;
    private ECCurve c;
    private ECPoint p;

    public X9ECPoint(ECPoint eCPoint, boolean bl) {
        X9ECPoint x9ECPoint = this;
        x9ECPoint.p = eCPoint.normalize();
        x9ECPoint.encoding = new DEROctetString(eCPoint.getEncoded(bl));
    }

    public X9ECPoint(ECCurve eCCurve, byte[] byArray) {
        X9ECPoint x9ECPoint = this;
        x9ECPoint.c = eCCurve;
        x9ECPoint.encoding = new DEROctetString(Arrays.clone(byArray));
    }

    public X9ECPoint(ECCurve eCCurve, ASN1OctetString aSN1OctetString) {
        this(eCCurve, aSN1OctetString.getOctets());
    }

    public byte[] getPointEncoding() {
        return Arrays.clone(this.encoding.getOctets());
    }

    public synchronized ECPoint getPoint() {
        if (this.p == null) {
            this.p = this.c.decodePoint(this.encoding.getOctets()).normalize();
        }
        return this.p;
    }

    public boolean isPointCompressed() {
        Object object;
        byte[] byArray = ((X9ECPoint)object2).encoding.getOctets();
        Object object2 = byArray;
        return byArray != null && ((Object)object2).length > 0 && ((object = object2[0]) == 2 || object == 3);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.encoding;
    }
}

