/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BasicAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class ECDHBasicAgreement
implements BasicAgreement {
    private ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters cipherParameters) {
        this.key = (ECPrivateKeyParameters)cipherParameters;
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters object) {
        object = (ECPublicKeyParameters)object;
        ECDomainParameters eCDomainParameters = ((ECDHBasicAgreement)object2).key.getParameters();
        if (eCDomainParameters.equals(((ECKeyParameters)object).getParameters())) {
            Object object2 = ((ECDHBasicAgreement)object2).key.getD();
            object = ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), ((ECPublicKeyParameters)object).getQ());
            if (!((ECPoint)object).isInfinity()) {
                BigInteger bigInteger = eCDomainParameters.getH();
                if (!bigInteger.equals(ECConstants.ONE)) {
                    object2 = eCDomainParameters.getHInv().multiply((BigInteger)object2).mod(eCDomainParameters.getN());
                    object = ECAlgorithms.referenceMultiply((ECPoint)object, bigInteger);
                }
                if (!((ECPoint)(object2 = ((ECPoint)object).multiply((BigInteger)object2).normalize())).isInfinity()) {
                    return ((ECPoint)object2).getAffineXCoord().toBigInteger();
                }
                throw new IllegalStateException("Infinity is not a valid agreement value for ECDH");
            }
            throw new IllegalStateException("Infinity is not a valid public key for ECDH");
        }
        throw new IllegalStateException("ECDH public key has wrong domain parameters");
    }
}

