/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKEPrimeOrderGroup;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKEPrimeOrderGroups;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKERound1Payload;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKERound2Payload;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKERound3Payload;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKEUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.SecureRandom;

public class JPAKEParticipant {
    public static final int STATE_INITIALIZED = 0;
    public static final int STATE_ROUND_1_CREATED = 10;
    public static final int STATE_ROUND_1_VALIDATED = 20;
    public static final int STATE_ROUND_2_CREATED = 30;
    public static final int STATE_ROUND_2_VALIDATED = 40;
    public static final int STATE_KEY_CALCULATED = 50;
    public static final int STATE_ROUND_3_CREATED = 60;
    public static final int STATE_ROUND_3_VALIDATED = 70;
    private final String participantId;
    private char[] password;
    private final Digest digest;
    private final SecureRandom random;
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger g;
    private String partnerParticipantId;
    private BigInteger x1;
    private BigInteger x2;
    private BigInteger gx1;
    private BigInteger gx2;
    private BigInteger gx3;
    private BigInteger gx4;
    private BigInteger b;
    private int state;

    public JPAKEParticipant(String string, char[] cArray) {
        JPAKEParticipant jPAKEParticipant = jPAKEPrimeOrderGroup;
        JPAKEPrimeOrderGroup jPAKEPrimeOrderGroup = JPAKEPrimeOrderGroups.NIST_3072;
        jPAKEParticipant(string, cArray, jPAKEPrimeOrderGroup);
    }

    public JPAKEParticipant(String string, char[] cArray, JPAKEPrimeOrderGroup jPAKEPrimeOrderGroup) {
        SHA256Digest sHA256Digest;
        JPAKEParticipant jPAKEParticipant = sHA256Digest2;
        SHA256Digest sHA256Digest2 = sHA256Digest;
        sHA256Digest = new SHA256Digest();
        SecureRandom secureRandom = CryptoServicesRegistrar.getSecureRandom();
        jPAKEParticipant(string, cArray, jPAKEPrimeOrderGroup, sHA256Digest2, secureRandom);
    }

    public JPAKEParticipant(String string, char[] cArray, JPAKEPrimeOrderGroup jPAKEPrimeOrderGroup, Digest digest, SecureRandom secureRandom) {
        JPAKEUtil.validateNotNull(string, "participantId");
        JPAKEUtil.validateNotNull(cArray, "password");
        JPAKEUtil.validateNotNull(jPAKEPrimeOrderGroup, "p");
        JPAKEUtil.validateNotNull(digest, "digest");
        JPAKEUtil.validateNotNull(secureRandom, "random");
        if (cArray.length != 0) {
            JPAKEParticipant jPAKEParticipant = this;
            this.participantId = string;
            this.password = Arrays.copyOf(cArray, cArray.length);
            this.p = jPAKEPrimeOrderGroup.getP();
            this.q = jPAKEPrimeOrderGroup.getQ();
            this.g = jPAKEPrimeOrderGroup.getG();
            this.digest = digest;
            jPAKEParticipant.random = secureRandom;
            jPAKEParticipant.state = 0;
            return;
        }
        throw new IllegalArgumentException("Password must not be empty.");
    }

    public int getState() {
        return this.state;
    }

    public JPAKERound1Payload createRound1PayloadToSend() {
        if (((JPAKEParticipant)((Object)string)).state < 10) {
            JPAKEParticipant jPAKEParticipant = string;
            jPAKEParticipant.x1 = JPAKEUtil.generateX1(jPAKEParticipant.q, ((JPAKEParticipant)((Object)string)).random);
            jPAKEParticipant.x2 = JPAKEUtil.generateX2(jPAKEParticipant.q, ((JPAKEParticipant)((Object)string)).random);
            JPAKEParticipant jPAKEParticipant2 = string;
            BigInteger[] bigIntegerArray = jPAKEParticipant2.g;
            jPAKEParticipant.gx1 = JPAKEUtil.calculateGx(jPAKEParticipant.p, (BigInteger)bigIntegerArray, jPAKEParticipant2.x1);
            JPAKEParticipant jPAKEParticipant3 = string;
            bigIntegerArray = jPAKEParticipant3.g;
            jPAKEParticipant.gx2 = JPAKEUtil.calculateGx(jPAKEParticipant.p, (BigInteger)bigIntegerArray, jPAKEParticipant3.x2);
            JPAKEParticipant jPAKEParticipant4 = string;
            bigIntegerArray = jPAKEParticipant4.q;
            BigInteger[] bigIntegerArray2 = jPAKEParticipant4.g;
            BigInteger bigInteger = jPAKEParticipant4.gx1;
            BigInteger bigInteger2 = jPAKEParticipant4.x1;
            Object object = jPAKEParticipant4.participantId;
            Object object2 = jPAKEParticipant4.digest;
            Object object3 = jPAKEParticipant4.random;
            bigIntegerArray = JPAKEUtil.calculateZeroKnowledgeProof(jPAKEParticipant.p, (BigInteger)bigIntegerArray, (BigInteger)bigIntegerArray2, bigInteger, bigInteger2, (String)object, (Digest)object2, (SecureRandom)object3);
            JPAKEParticipant jPAKEParticipant5 = string;
            bigIntegerArray2 = jPAKEParticipant5.q;
            bigInteger = jPAKEParticipant5.g;
            bigInteger2 = jPAKEParticipant5.gx2;
            object = jPAKEParticipant5.x2;
            object2 = jPAKEParticipant5.participantId;
            object3 = jPAKEParticipant5.digest;
            SecureRandom secureRandom = jPAKEParticipant5.random;
            bigIntegerArray2 = JPAKEUtil.calculateZeroKnowledgeProof(jPAKEParticipant.p, (BigInteger)bigIntegerArray2, bigInteger, bigInteger2, (BigInteger)object, (String)object2, (Digest)object3, secureRandom);
            jPAKEParticipant.state = 10;
            JPAKEParticipant jPAKEParticipant6 = string;
            String string = jPAKEParticipant6.participantId;
            bigInteger = jPAKEParticipant6.gx1;
            bigInteger2 = jPAKEParticipant6.gx2;
            return new JPAKERound1Payload(string, bigInteger, bigInteger2, bigIntegerArray, bigIntegerArray2);
        }
        throw new IllegalStateException(b.b.a("Round1 payload already created for ").append(((JPAKEParticipant)((Object)string)).participantId).toString());
    }

    public void validateRound1PayloadReceived(JPAKERound1Payload object) {
        if (((JPAKEParticipant)((Object)bigInteger2)).state < 20) {
            JPAKEParticipant jPAKEParticipant = bigInteger2;
            JPAKERound1Payload jPAKERound1Payload = object;
            ((JPAKEParticipant)((Object)bigInteger2)).partnerParticipantId = ((JPAKERound1Payload)object).getParticipantId();
            ((JPAKEParticipant)((Object)bigInteger2)).gx3 = ((JPAKERound1Payload)object).getGx1();
            ((JPAKEParticipant)((Object)bigInteger2)).gx4 = ((JPAKERound1Payload)object).getGx2();
            Object object2 = jPAKERound1Payload.getKnowledgeProofForX1();
            BigInteger[] bigIntegerArray = jPAKERound1Payload.getKnowledgeProofForX2();
            JPAKEUtil.validateParticipantIdsDiffer(jPAKEParticipant.participantId, ((JPAKERound1Payload)object).getParticipantId());
            JPAKEUtil.validateGx4(jPAKEParticipant.gx4);
            JPAKEParticipant jPAKEParticipant2 = bigInteger2;
            Object object3 = jPAKEParticipant2.q;
            Object object4 = jPAKEParticipant2.g;
            BigInteger bigInteger = jPAKEParticipant2.gx3;
            String string = ((JPAKERound1Payload)object).getParticipantId();
            Digest digest = ((JPAKEParticipant)((Object)bigInteger2)).digest;
            JPAKEUtil.validateZeroKnowledgeProof(jPAKEParticipant.p, (BigInteger)object3, (BigInteger)object4, bigInteger, object2, string, digest);
            JPAKEParticipant jPAKEParticipant3 = bigInteger2;
            JPAKERound1Payload jPAKERound1Payload2 = object;
            JPAKEParticipant jPAKEParticipant4 = bigInteger2;
            BigInteger bigInteger2 = jPAKEParticipant4.q;
            object = jPAKEParticipant4.g;
            object2 = jPAKEParticipant4.gx4;
            object3 = jPAKERound1Payload2.getParticipantId();
            object4 = jPAKEParticipant3.digest;
            JPAKEUtil.validateZeroKnowledgeProof(jPAKEParticipant.p, bigInteger2, (BigInteger)object, (BigInteger)object2, bigIntegerArray, (String)object3, (Digest)object4);
            jPAKEParticipant.state = 20;
            return;
        }
        throw new IllegalStateException(b.b.a("Validation already attempted for round1 payload for").append(((JPAKEParticipant)((Object)bigInteger2)).participantId).toString());
    }

    public JPAKERound2Payload createRound2PayloadToSend() {
        int n = this.state;
        if (n < 30) {
            if (n >= 20) {
                JPAKEParticipant jPAKEParticipant = this;
                JPAKEParticipant jPAKEParticipant2 = this;
                BigInteger[] bigIntegerArray = jPAKEParticipant2.gx1;
                BigInteger bigInteger = jPAKEParticipant2.gx3;
                BigInteger bigInteger2 = jPAKEParticipant2.gx4;
                bigIntegerArray = JPAKEUtil.calculateGA(jPAKEParticipant.p, (BigInteger)bigIntegerArray, bigInteger, bigInteger2);
                bigInteger = JPAKEUtil.calculateS(jPAKEParticipant.password);
                bigInteger = JPAKEUtil.calculateX2s(jPAKEParticipant.q, this.x2, bigInteger);
                bigInteger2 = JPAKEUtil.calculateA(jPAKEParticipant.p, this.q, (BigInteger)bigIntegerArray, bigInteger);
                JPAKEParticipant jPAKEParticipant3 = this;
                BigInteger bigInteger3 = jPAKEParticipant3.q;
                String string = jPAKEParticipant3.participantId;
                Digest digest = jPAKEParticipant3.digest;
                SecureRandom secureRandom = jPAKEParticipant3.random;
                bigIntegerArray = JPAKEUtil.calculateZeroKnowledgeProof(jPAKEParticipant.p, bigInteger3, (BigInteger)bigIntegerArray, bigInteger2, bigInteger, string, digest, secureRandom);
                jPAKEParticipant.state = 30;
                return new JPAKERound2Payload(this.participantId, bigInteger2, bigIntegerArray);
            }
            throw new IllegalStateException(b.b.a("Round1 payload must be validated prior to creating Round2 payload for ").append(this.participantId).toString());
        }
        throw new IllegalStateException(b.b.a("Round2 payload already created for ").append(this.participantId).toString());
    }

    public void validateRound2PayloadReceived(JPAKERound2Payload object) {
        int n = ((JPAKEParticipant)((Object)bigInteger2)).state;
        if (n < 40) {
            if (n >= 20) {
                JPAKEParticipant jPAKEParticipant = bigInteger2;
                JPAKEParticipant jPAKEParticipant2 = bigInteger2;
                BigInteger bigInteger = jPAKEParticipant2.gx3;
                BigInteger[] bigIntegerArray = jPAKEParticipant2.gx1;
                Object object2 = jPAKEParticipant2.gx2;
                bigInteger = JPAKEUtil.calculateGA(jPAKEParticipant.p, bigInteger, (BigInteger)bigIntegerArray, (BigInteger)object2);
                JPAKEParticipant jPAKEParticipant3 = bigInteger2;
                ((JPAKEParticipant)((Object)bigInteger2)).b = ((JPAKERound2Payload)object).getA();
                bigIntegerArray = ((JPAKERound2Payload)object).getKnowledgeProofForX2s();
                JPAKEUtil.validateParticipantIdsDiffer(jPAKEParticipant3.participantId, ((JPAKERound2Payload)object).getParticipantId());
                JPAKEUtil.validateParticipantIdsEqual(jPAKEParticipant3.partnerParticipantId, ((JPAKERound2Payload)object).getParticipantId());
                JPAKEUtil.validateGa(bigInteger);
                JPAKEParticipant jPAKEParticipant4 = bigInteger2;
                JPAKERound2Payload jPAKERound2Payload = object;
                JPAKEParticipant jPAKEParticipant5 = bigInteger2;
                BigInteger bigInteger2 = jPAKEParticipant5.q;
                object = jPAKEParticipant5.b;
                object2 = jPAKERound2Payload.getParticipantId();
                Digest digest = jPAKEParticipant4.digest;
                JPAKEUtil.validateZeroKnowledgeProof(jPAKEParticipant.p, bigInteger2, bigInteger, (BigInteger)object, bigIntegerArray, (String)object2, digest);
                jPAKEParticipant.state = 40;
                return;
            }
            throw new IllegalStateException(b.b.a("Round1 payload must be validated prior to validating Round2 payload for ").append(((JPAKEParticipant)((Object)bigInteger2)).participantId).toString());
        }
        throw new IllegalStateException(b.b.a("Validation already attempted for round2 payload for").append(((JPAKEParticipant)((Object)bigInteger2)).participantId).toString());
    }

    public BigInteger calculateKeyingMaterial() {
        int n = this.state;
        if (n < 50) {
            if (n >= 40) {
                JPAKEParticipant jPAKEParticipant = this;
                BigInteger bigInteger = JPAKEUtil.calculateS(jPAKEParticipant.password);
                Arrays.fill(jPAKEParticipant.password, '\u0000');
                jPAKEParticipant.password = null;
                JPAKEParticipant jPAKEParticipant2 = this;
                BigInteger bigInteger2 = jPAKEParticipant2.q;
                BigInteger bigInteger3 = jPAKEParticipant2.gx4;
                BigInteger bigInteger4 = jPAKEParticipant2.x2;
                BigInteger bigInteger5 = jPAKEParticipant2.b;
                JPAKEParticipant jPAKEParticipant3 = this;
                jPAKEParticipant3.x1 = null;
                jPAKEParticipant3.x2 = null;
                jPAKEParticipant3.b = null;
                jPAKEParticipant3.state = 50;
                return JPAKEUtil.calculateKeyingMaterial(jPAKEParticipant.p, bigInteger2, bigInteger3, bigInteger4, bigInteger, bigInteger5);
            }
            throw new IllegalStateException(b.b.a("Round2 payload must be validated prior to creating key for ").append(this.participantId).toString());
        }
        throw new IllegalStateException(b.b.a("Key already calculated for ").append(this.participantId).toString());
    }

    public JPAKERound3Payload createRound3PayloadToSend(BigInteger bigInteger) {
        int n = this.state;
        if (n < 60) {
            if (n >= 50) {
                JPAKEParticipant jPAKEParticipant = this;
                String string = jPAKEParticipant.partnerParticipantId;
                BigInteger bigInteger2 = jPAKEParticipant.gx1;
                BigInteger bigInteger3 = jPAKEParticipant.gx2;
                BigInteger bigInteger4 = jPAKEParticipant.gx3;
                BigInteger bigInteger5 = jPAKEParticipant.gx4;
                Digest digest = jPAKEParticipant.digest;
                bigInteger = JPAKEUtil.calculateMacTag(this.participantId, string, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger, digest);
                this.state = 60;
                return new JPAKERound3Payload(this.participantId, bigInteger);
            }
            throw new IllegalStateException(b.b.a("Keying material must be calculated prior to creating Round3 payload for ").append(this.participantId).toString());
        }
        throw new IllegalStateException(b.b.a("Round3 payload already created for ").append(this.participantId).toString());
    }

    public void validateRound3PayloadReceived(JPAKERound3Payload object, BigInteger bigInteger) {
        int n = ((JPAKEParticipant)((Object)string)).state;
        if (n < 70) {
            if (n >= 50) {
                JPAKEParticipant jPAKEParticipant = string;
                JPAKEUtil.validateParticipantIdsDiffer(jPAKEParticipant.participantId, ((JPAKERound3Payload)object).getParticipantId());
                JPAKEUtil.validateParticipantIdsEqual(jPAKEParticipant.partnerParticipantId, ((JPAKERound3Payload)object).getParticipantId());
                JPAKERound3Payload jPAKERound3Payload = object;
                JPAKEParticipant jPAKEParticipant2 = string;
                String string = jPAKEParticipant2.partnerParticipantId;
                object = jPAKEParticipant2.gx1;
                BigInteger bigInteger2 = jPAKEParticipant2.gx2;
                BigInteger bigInteger3 = jPAKEParticipant2.gx3;
                BigInteger bigInteger4 = jPAKEParticipant2.gx4;
                Digest digest = jPAKEParticipant2.digest;
                BigInteger bigInteger5 = jPAKERound3Payload.getMacTag();
                JPAKEUtil.validateMacTag(jPAKEParticipant.participantId, string, (BigInteger)object, bigInteger2, bigInteger3, bigInteger4, bigInteger, digest, bigInteger5);
                jPAKEParticipant.gx1 = null;
                jPAKEParticipant.gx2 = null;
                jPAKEParticipant.gx3 = null;
                jPAKEParticipant.gx4 = null;
                jPAKEParticipant.state = 70;
                return;
            }
            throw new IllegalStateException(b.b.a("Keying material must be calculated validated prior to validating Round3 payload for ").append(((JPAKEParticipant)((Object)string)).participantId).toString());
        }
        throw new IllegalStateException(b.b.a("Validation already attempted for round3 payload for").append(((JPAKEParticipant)((Object)string)).participantId).toString());
    }
}

