/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKEUtil;
import java.math.BigInteger;

public class JPAKEPrimeOrderGroup {
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger g;

    public JPAKEPrimeOrderGroup(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this(bigInteger, bigInteger2, bigInteger3, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JPAKEPrimeOrderGroup(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, boolean bl) {
        JPAKEUtil.validateNotNull(bigInteger, "p");
        JPAKEUtil.validateNotNull(bigInteger2, "q");
        JPAKEUtil.validateNotNull(bigInteger3, "g");
        if (!bl) {
            BigInteger bigInteger4 = JPAKEUtil.ONE;
            if (!bigInteger.subtract(bigInteger4).mod(bigInteger2).equals(JPAKEUtil.ZERO)) throw new IllegalArgumentException("p-1 must be evenly divisible by q");
            if (bigInteger3.compareTo(BigInteger.valueOf(2L)) == -1 || bigInteger3.compareTo(bigInteger.subtract(bigInteger4)) == 1) throw new IllegalArgumentException("g must be in [2, p-1]");
            if (!bigInteger3.modPow(bigInteger2, bigInteger).equals(bigInteger4)) throw new IllegalArgumentException("g^q mod p must equal 1");
            if (!bigInteger.isProbablePrime(20)) throw new IllegalArgumentException("p must be prime");
            if (!bigInteger2.isProbablePrime(20)) {
                throw new IllegalArgumentException("q must be prime");
            }
        }
        JPAKEPrimeOrderGroup jPAKEPrimeOrderGroup = this;
        jPAKEPrimeOrderGroup.p = bigInteger;
        jPAKEPrimeOrderGroup.q = bigInteger2;
        jPAKEPrimeOrderGroup.g = bigInteger3;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getG() {
        return this.g;
    }
}

