/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFParameters;

public class ConcatenationKDFGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] shared;
    private byte[] otherInfo;
    private int hLen;

    public ConcatenationKDFGenerator(Digest digest) {
        this.digest = digest;
        this.hLen = digest.getDigestSize();
    }

    private void ItoOSP(int n, byte[] byArray) {
        byArray[0] = (byte)(n >>> 24);
        byArray[1] = (byte)(n >>> 16);
        byArray[2] = (byte)(n >>> 8);
        byArray[3] = (byte)(n >>> 0);
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof KDFParameters) {
            ConcatenationKDFGenerator concatenationKDFGenerator = kDFParameters;
            KDFParameters kDFParameters = (KDFParameters)derivationParameters;
            concatenationKDFGenerator.shared = kDFParameters.getSharedSecret();
            concatenationKDFGenerator.otherInfo = kDFParameters.getIV();
            return;
        }
        throw new IllegalArgumentException("KDF parameters required for generator");
    }

    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public int generateBytes(byte[] byArray, int n, int n2) {
        if (byArray.length - n2 >= n) {
            ConcatenationKDFGenerator concatenationKDFGenerator = this;
            byte[] byArray2 = new byte[concatenationKDFGenerator.hLen];
            int n3 = 4;
            byte[] byArray3 = new byte[4];
            int n4 = 1;
            int n5 = 0;
            concatenationKDFGenerator.digest.reset();
            if (n2 > concatenationKDFGenerator.hLen) {
                while (true) {
                    int n6 = n4;
                    int n7 = n5;
                    ConcatenationKDFGenerator concatenationKDFGenerator2 = this;
                    concatenationKDFGenerator2.ItoOSP(n4, byArray3);
                    concatenationKDFGenerator2.digest.update(byArray3, 0, n3);
                    concatenationKDFGenerator2.digest.update(this.shared, 0, this.shared.length);
                    concatenationKDFGenerator2.digest.update(this.otherInfo, 0, this.otherInfo.length);
                    concatenationKDFGenerator2.digest.doFinal(byArray2, 0);
                    n5 = n + n5;
                    int n8 = this.hLen;
                    System.arraycopy(byArray2, 0, byArray, n5, n8);
                    n5 = this.hLen;
                    n8 = n7 + n5;
                    ++n4;
                    if (n6 >= n2 / n5) {
                        n5 = n8;
                        break;
                    }
                    n5 = n8;
                }
            }
            if (n5 < n2) {
                ConcatenationKDFGenerator concatenationKDFGenerator3 = this;
                concatenationKDFGenerator3.ItoOSP(n4, byArray3);
                concatenationKDFGenerator3.digest.update(byArray3, 0, n3);
                concatenationKDFGenerator3.digest.update(this.shared, 0, this.shared.length);
                concatenationKDFGenerator3.digest.update(this.otherInfo, 0, this.otherInfo.length);
                concatenationKDFGenerator3.digest.doFinal(byArray2, 0);
                int n9 = n + n5;
                n = n2 - n5;
                System.arraycopy(byArray2, 0, byArray, n9, n);
            }
            return n2;
        }
        throw new OutputLengthException("output buffer too small");
    }
}

