/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.ThreefishEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.SkeinParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SkeinEngine
implements Memoable {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private static final int PARAM_TYPE_KEY = 0;
    private static final int PARAM_TYPE_CONFIG = 4;
    private static final int PARAM_TYPE_MESSAGE = 48;
    private static final int PARAM_TYPE_OUTPUT = 63;
    private static final Hashtable INITIAL_STATES = new Hashtable();
    public final ThreefishEngine threefish;
    private final int outputSizeBytes;
    public long[] chain;
    private long[] initialState;
    private byte[] key;
    private Parameter[] preMessageParameters;
    private Parameter[] postMessageParameters;
    private final UBI ubi;
    private final byte[] singleByte = new byte[1];

    private static void initialState(int n, int n2, long[] lArray) {
        INITIAL_STATES.put(SkeinEngine.variantIdentifier(n / 8, n2 / 8), lArray);
    }

    private static Integer variantIdentifier(int n, int n2) {
        return Integers.valueOf(n2 << 16 | n);
    }

    public SkeinEngine(int n, int n2) {
        if (n2 % 8 == 0) {
            ThreefishEngine threefishEngine;
            SkeinEngine skeinEngine = this;
            skeinEngine.outputSizeBytes = n2 / 8;
            ThreefishEngine threefishEngine2 = threefishEngine;
            skeinEngine.threefish = new ThreefishEngine(n);
            skeinEngine.ubi = new UBI(this, threefishEngine2.getBlockSize());
            return;
        }
        throw new IllegalArgumentException(a.a("Output size must be a multiple of 8 bits. :", n2));
    }

    public SkeinEngine(SkeinEngine skeinEngine) {
        this(skeinEngine.getBlockSize() * 8, skeinEngine.getOutputSize() * 8);
        this.copyIn(skeinEngine);
    }

    private void copyIn(SkeinEngine skeinEngine) {
        this.ubi.reset(skeinEngine.ubi);
        this.chain = Arrays.clone(skeinEngine.chain, this.chain);
        this.initialState = Arrays.clone(skeinEngine.initialState, this.initialState);
        this.key = Arrays.clone(skeinEngine.key, this.key);
        this.preMessageParameters = SkeinEngine.clone(skeinEngine.preMessageParameters, this.preMessageParameters);
        this.postMessageParameters = SkeinEngine.clone(skeinEngine.postMessageParameters, this.postMessageParameters);
    }

    private static Parameter[] clone(Parameter[] parameterArray, Parameter[] parameterArray2) {
        if (parameterArray == null) {
            return null;
        }
        if (parameterArray2 == null || parameterArray2.length != parameterArray.length) {
            parameterArray2 = new Parameter[parameterArray.length];
        }
        int n = parameterArray2.length;
        System.arraycopy(parameterArray, 0, parameterArray2, 0, n);
        return parameterArray2;
    }

    private void initParams(Hashtable hashtable) {
        Vector<Parameter> vector;
        Vector<Parameter> vector2;
        Enumeration enumeration = hashtable.keys();
        Vector<Parameter> vector3 = vector2;
        vector2 = new Vector<Parameter>();
        Vector<Parameter> vector4 = vector;
        vector = new Vector<Parameter>();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            byte[] byArray = (byte[])hashtable.get(n);
            if (n == 0) {
                objectArray5.key = byArray;
                continue;
            }
            if (n < 48) {
                vector3.addElement(new Parameter(n, byArray));
                continue;
            }
            vector4.addElement(new Parameter(n, byArray));
        }
        Object[] objectArray = objectArray5;
        Object[] objectArray2 = objectArray5;
        Object[] objectArray3 = objectArray5;
        Object[] objectArray4 = objectArray5;
        Object[] objectArray5 = new Parameter[vector3.size()];
        objectArray4.preMessageParameters = objectArray5;
        vector3.copyInto(objectArray5);
        SkeinEngine.sort(objectArray3.preMessageParameters);
        objectArray5 = new Parameter[vector4.size()];
        objectArray2.postMessageParameters = objectArray5;
        vector4.copyInto(objectArray5);
        SkeinEngine.sort(objectArray.postMessageParameters);
    }

    private static void sort(Parameter[] parameterArray) {
        if (parameterArray == null) {
            return;
        }
        for (int k = 1; k < parameterArray.length; ++k) {
            Parameter parameter = parameterArray[k];
            int n = k;
            while (n > 0) {
                int n2 = n - 1;
                if (parameter.getType() >= parameterArray[n2].getType()) break;
                parameterArray[n] = parameterArray[n2];
                n = n2;
            }
            parameterArray[n] = parameter;
        }
    }

    private void createInitialState() {
        Object[] objectArray = (long[])INITIAL_STATES.get(SkeinEngine.variantIdentifier(this.getBlockSize(), this.getOutputSize()));
        if (this.key == null && objectArray != null) {
            this.chain = Arrays.clone(objectArray);
        } else {
            SkeinEngine skeinEngine = this;
            skeinEngine.chain = new long[skeinEngine.getBlockSize() / 8];
            objectArray = skeinEngine.key;
            if (skeinEngine.key != null) {
                this.ubiComplete(0, (byte[])objectArray);
            }
            this.ubiComplete(4, new Configuration(this.outputSizeBytes * 8).getBytes());
        }
        if (this.preMessageParameters != null) {
            int n = 0;
            while (true) {
                Parameter[] parameterArray = this.preMessageParameters;
                if (n >= this.preMessageParameters.length) break;
                Parameter parameter = parameterArray[n];
                int n2 = parameter.getType();
                this.ubiComplete(n2, parameter.getValue());
                ++n;
            }
        }
        this.initialState = Arrays.clone(this.chain);
    }

    private void ubiComplete(int n, byte[] byArray) {
        SkeinEngine skeinEngine = this;
        skeinEngine.ubiInit(n);
        int n2 = byArray.length;
        long[] lArray = this.chain;
        skeinEngine.ubi.update(byArray, 0, n2, lArray);
        skeinEngine.ubiFinal();
    }

    private void ubiInit(int n) {
        this.ubi.reset(n);
    }

    private void ubiFinal() {
        this.ubi.doFinal(this.chain);
    }

    private void checkInitialised() {
        if (this.ubi != null) {
            return;
        }
        throw new IllegalArgumentException("Skein engine is not initialised.");
    }

    private void output(long l, byte[] byArray, int n, int n2) {
        SkeinEngine skeinEngine = object;
        byte[] byArray2 = new byte[8];
        Object object = byArray2;
        ThreefishEngine.wordToBytes(l, byArray2, 0);
        long[] lArray = new long[skeinEngine.chain.length];
        skeinEngine.ubiInit(63);
        skeinEngine.ubi.update((byte[])object, 0, 8, lArray);
        skeinEngine.ubi.doFinal(lArray);
        int n3 = (n2 + 8 - 1) / 8;
        for (int k = 0; k < n3; ++k) {
            int n4 = k * 8;
            int n5 = Math.min(8, n2 - n4);
            if (n5 == 8) {
                ThreefishEngine.wordToBytes(lArray[k], byArray, n + n4);
                continue;
            }
            ThreefishEngine.wordToBytes(lArray[k], (byte[])object, 0);
            n4 = n + n4;
            System.arraycopy(object, 0, byArray, n4, n5);
        }
    }

    static {
        long[] lArray = new long[4];
        long[] lArray2 = lArray;
        lArray[0] = -2228972824489528736L;
        lArray[1] = -8629553674646093540L;
        lArray[2] = 1155188648486244218L;
        lArray[3] = -3677226592081559102L;
        SkeinEngine.initialState(256, 128, lArray2);
        long[] lArray3 = new long[4];
        lArray2 = lArray3;
        lArray3[0] = 1450197650740764312L;
        lArray3[1] = 3081844928540042640L;
        lArray3[2] = -3136097061834271170L;
        lArray3[3] = 3301952811952417661L;
        SkeinEngine.initialState(256, 160, lArray2);
        long[] lArray4 = new long[4];
        lArray2 = lArray4;
        lArray4[0] = -4176654842910610933L;
        lArray4[1] = -8688192972455077604L;
        lArray4[2] = -7364642305011795836L;
        lArray4[3] = 4056579644589979102L;
        SkeinEngine.initialState(256, 224, lArray2);
        long[] lArray5 = new long[4];
        lArray2 = lArray5;
        lArray5[0] = -243853671043386295L;
        lArray5[1] = 3443677322885453875L;
        lArray5[2] = -5531612722399640561L;
        lArray5[3] = 7662005193972177513L;
        SkeinEngine.initialState(256, 256, lArray2);
        long[] lArray6 = new long[8];
        lArray2 = lArray6;
        lArray6[0] = -6288014694233956526L;
        lArray6[1] = 2204638249859346602L;
        lArray6[2] = 3502419045458743507L;
        lArray6[3] = -4829063503441264548L;
        lArray6[4] = 983504137758028059L;
        lArray6[5] = 1880512238245786339L;
        lArray6[6] = -6715892782214108542L;
        lArray6[7] = 7602827311880509485L;
        SkeinEngine.initialState(512, 128, lArray2);
        long[] lArray7 = new long[8];
        lArray2 = lArray7;
        lArray7[0] = 2934123928682216849L;
        lArray7[1] = -4399710721982728305L;
        lArray7[2] = 1684584802963255058L;
        lArray7[3] = 5744138295201861711L;
        lArray7[4] = 2444857010922934358L;
        lArray7[5] = -2807833639722848072L;
        lArray7[6] = -5121587834665610502L;
        lArray7[7] = 118355523173251694L;
        SkeinEngine.initialState(512, 160, lArray2);
        long[] lArray8 = new long[8];
        lArray2 = lArray8;
        lArray8[0] = -3688341020067007964L;
        lArray8[1] = -3772225436291745297L;
        lArray8[2] = -8300862168937575580L;
        lArray8[3] = 4146387520469897396L;
        lArray8[4] = 1106145742801415120L;
        lArray8[5] = 7455425944880474941L;
        lArray8[6] = -7351063101234211863L;
        lArray8[7] = -7048981346965512457L;
        SkeinEngine.initialState(512, 224, lArray2);
        long[] lArray9 = new long[8];
        lArray2 = lArray9;
        lArray9[0] = -6631894876634615969L;
        lArray9[1] = -5692838220127733084L;
        lArray9[2] = -7099962856338682626L;
        lArray9[3] = -2911352911530754598L;
        lArray9[4] = 2000907093792408677L;
        lArray9[5] = 9140007292425499655L;
        lArray9[6] = 6093301768906360022L;
        lArray9[7] = 2769176472213098488L;
        SkeinEngine.initialState(512, 384, lArray2);
        long[] lArray10 = new long[8];
        lArray2 = lArray10;
        lArray10[0] = 5261240102383538638L;
        lArray10[1] = 978932832955457283L;
        lArray10[2] = -8083517948103779378L;
        lArray10[3] = -7339365279355032399L;
        lArray10[4] = 6752626034097301424L;
        lArray10[5] = -1531723821829733388L;
        lArray10[6] = -7417126464950782685L;
        lArray10[7] = -5901786942805128141L;
        SkeinEngine.initialState(512, 512, lArray2);
    }

    @Override
    public Memoable copy() {
        return new SkeinEngine(this);
    }

    @Override
    public void reset(Memoable memoable) {
        memoable = (SkeinEngine)memoable;
        if (this.getBlockSize() == ((SkeinEngine)memoable).getBlockSize() && this.outputSizeBytes == ((SkeinEngine)memoable).outputSizeBytes) {
            this.copyIn((SkeinEngine)memoable);
            return;
        }
        throw new IllegalArgumentException("Incompatible parameters in provided SkeinEngine.");
    }

    public int getOutputSize() {
        return this.outputSizeBytes;
    }

    public int getBlockSize() {
        return this.threefish.getBlockSize();
    }

    public void init(SkeinParameters skeinParameters) {
        SkeinEngine skeinEngine = this;
        skeinEngine.chain = null;
        skeinEngine.key = null;
        skeinEngine.preMessageParameters = null;
        skeinEngine.postMessageParameters = null;
        if (skeinParameters != null) {
            if (skeinParameters.getKey().length >= 16) {
                this.initParams(skeinParameters.getParameters());
            } else {
                throw new IllegalArgumentException("Skein key must be at least 128 bits.");
            }
        }
        SkeinEngine skeinEngine2 = this;
        skeinEngine2.createInitialState();
        skeinEngine2.ubiInit(48);
    }

    public void reset() {
        SkeinEngine skeinEngine = object;
        Object object = ((SkeinEngine)object).chain;
        int n = ((SkeinEngine)object).chain.length;
        System.arraycopy(skeinEngine.initialState, 0, object, 0, n);
        skeinEngine.ubiInit(48);
    }

    public void update(byte by) {
        SkeinEngine skeinEngine = object;
        Object object = skeinEngine.singleByte;
        skeinEngine.singleByte[0] = by;
        skeinEngine.update((byte[])object, 0, 1);
    }

    public void update(byte[] byArray, int n, int n2) {
        SkeinEngine skeinEngine = object;
        skeinEngine.checkInitialised();
        Object object = ((SkeinEngine)object).chain;
        skeinEngine.ubi.update(byArray, n, n2, (long[])object);
    }

    public int doFinal(byte[] byArray, int n) {
        this.checkInitialised();
        if (byArray.length >= n + this.outputSizeBytes) {
            int n2;
            SkeinEngine skeinEngine = this;
            skeinEngine.ubiFinal();
            if (skeinEngine.postMessageParameters != null) {
                n2 = 0;
                while (true) {
                    Parameter[] parameterArray = this.postMessageParameters;
                    if (n2 >= this.postMessageParameters.length) break;
                    Parameter parameter = parameterArray[n2];
                    int n3 = parameter.getType();
                    this.ubiComplete(n3, parameter.getValue());
                    ++n2;
                }
            }
            SkeinEngine skeinEngine2 = this;
            n2 = skeinEngine2.getBlockSize();
            int n4 = (skeinEngine2.outputSizeBytes + n2 - 1) / n2;
            for (int k = 0; k < n4; ++k) {
                int n5 = k * n2;
                int n6 = Math.min(n2, this.outputSizeBytes - n5);
                long l = k;
                n5 = n + n5;
                this.output(l, byArray, n5, n6);
            }
            SkeinEngine skeinEngine3 = this;
            skeinEngine3.reset();
            return skeinEngine3.outputSizeBytes;
        }
        throw new OutputLengthException("Output buffer is too short to hold output");
    }

    public class UBI {
        private final UbiTweak tweak;
        private byte[] currentBlock;
        private int currentOffset;
        private long[] message;
        public final /* synthetic */ SkeinEngine this$0;

        public UBI(SkeinEngine skeinEngine, int n) {
            UBI uBI = object;
            ((UBI)object).this$0 = skeinEngine;
            ((UBI)object).tweak = new UbiTweak();
            byte[] byArray = new byte[n];
            Object object = byArray;
            uBI.currentBlock = byArray;
            uBI.message = new long[((Object)object).length / 8];
        }

        private void processBlock(long[] lArray) {
            SkeinEngine skeinEngine = this.this$0;
            Object object = skeinEngine;
            object = ((SkeinEngine)object).chain;
            long[] lArray2 = this.tweak.getWords();
            skeinEngine.threefish.init(true, (long[])object, lArray2);
            int n = 0;
            while (true) {
                lArray2 = this.message;
                if (n >= this.message.length) break;
                lArray2[n] = ThreefishEngine.bytesToWord(this.currentBlock, n * 8);
                ++n;
            }
            this.this$0.threefish.processBlock(lArray2, lArray);
            for (n = 0; n < lArray.length; ++n) {
                lArray[n] = lArray[n] ^ this.message[n];
            }
        }

        public void reset(UBI uBI) {
            this.currentBlock = Arrays.clone(uBI.currentBlock, this.currentBlock);
            this.currentOffset = uBI.currentOffset;
            this.message = Arrays.clone(uBI.message, this.message);
            this.tweak.reset(uBI.tweak);
        }

        public void reset(int n) {
            UBI uBI = this;
            uBI.tweak.reset();
            uBI.tweak.setType(n);
            uBI.currentOffset = 0;
        }

        public void update(byte[] byArray, int n, int n2, long[] lArray) {
            int n3 = 0;
            while (n2 > n3) {
                if (this.currentOffset == this.currentBlock.length) {
                    UBI uBI = this;
                    uBI.processBlock(lArray);
                    uBI.tweak.setFirst(false);
                    uBI.currentOffset = 0;
                }
                UBI uBI = this;
                int n4 = n3;
                UBI uBI2 = this;
                int n5 = n3;
                n3 = Math.min(n2 - n3, this.currentBlock.length - this.currentOffset);
                int n6 = n + n5;
                byte[] byArray2 = uBI2.currentBlock;
                int n7 = uBI2.currentOffset;
                System.arraycopy(byArray, n6, byArray2, n7, n3);
                n6 = n4 + n3;
                uBI.currentOffset += n3;
                uBI.tweak.advancePosition(n3);
                n3 = n6;
            }
        }

        public void doFinal(long[] lArray) {
            int n = this.currentOffset;
            while (true) {
                byte[] byArray = this.currentBlock;
                if (n >= this.currentBlock.length) break;
                byArray[n] = 0;
                ++n;
            }
            this.tweak.setFinal(true);
            this.processBlock(lArray);
        }
    }

    public static class UbiTweak {
        private static final long LOW_RANGE = 9223372034707292160L;
        private static final long T1_FINAL = Long.MIN_VALUE;
        private static final long T1_FIRST = 0x4000000000000000L;
        private long[] tweak;
        private boolean extendedPosition;

        public UbiTweak() {
            UbiTweak ubiTweak = this;
            ubiTweak.tweak = new long[2];
            ubiTweak.reset();
        }

        public void reset(UbiTweak ubiTweak) {
            this.tweak = Arrays.clone(ubiTweak.tweak, this.tweak);
            this.extendedPosition = ubiTweak.extendedPosition;
        }

        public void reset() {
            UbiTweak ubiTweak = this;
            ubiTweak.tweak[0] = 0L;
            ubiTweak.tweak[1] = 0L;
            ubiTweak.extendedPosition = false;
            ubiTweak.setFirst(true);
        }

        public void setType(int n) {
            long l;
            this.tweak[1] = l = this.tweak[1] & 0xFFFFFFC000000000L | ((long)n & 0x3FL) << 56;
        }

        public int getType() {
            return (int)(this.tweak[1] >>> 56 & 0x3FL);
        }

        public void setFirst(boolean bl) {
            long l;
            long l2;
            this.tweak[1] = bl ? (l2 = this.tweak[1] | 0x4000000000000000L) : (l = this.tweak[1] & 0xBFFFFFFFFFFFFFFFL);
        }

        public boolean isFirst() {
            return (this.tweak[1] & 0x4000000000000000L) != 0L;
        }

        public void setFinal(boolean bl) {
            long l;
            long l2;
            this.tweak[1] = bl ? (l2 = this.tweak[1] | Long.MIN_VALUE) : (l = this.tweak[1] & Long.MAX_VALUE);
        }

        public boolean isFinal() {
            return (this.tweak[1] & Long.MIN_VALUE) != 0L;
        }

        public void advancePosition(int n) {
            if (this.extendedPosition) {
                long l;
                long l2;
                int n2 = n;
                n = 3;
                long[] lArray = new long[3];
                long[] lArray2 = lArray;
                long[] lArray3 = this.tweak;
                lArray2[0] = l2 = lArray3[0] & 0xFFFFFFFFL;
                lArray2[1] = l2 = lArray3[0] >>> 32 & 0xFFFFFFFFL;
                lArray[2] = l2 = this.tweak[1] & 0xFFFFFFFFL;
                l2 = n2;
                for (int k = 0; k < n; ++k) {
                    lArray2[k] = l2 += lArray2[k];
                    l2 >>>= 32;
                }
                long[] lArray4 = this.tweak;
                lArray4[0] = l = (lArray2[1] & 0xFFFFFFFFL) << 32 | lArray2[0] & 0xFFFFFFFFL;
                this.tweak[1] = l = lArray4[1] & 0xFFFFFFFF00000000L | lArray2[2] & 0xFFFFFFFFL;
            } else {
                long l;
                long[] lArray = this.tweak;
                lArray[0] = l = this.tweak[0] + (long)n;
                if (l > 9223372034707292160L) {
                    this.extendedPosition = true;
                }
            }
        }

        public long[] getWords() {
            return this.tweak;
        }

        public String toString() {
            return this.getType() + " first: " + this.isFirst() + ", final: " + this.isFinal();
        }
    }

    public static class Parameter {
        private int type;
        private byte[] value;

        public Parameter(int n, byte[] byArray) {
            this.type = n;
            this.value = byArray;
        }

        public int getType() {
            return this.type;
        }

        public byte[] getValue() {
            return this.value;
        }
    }

    public static class Configuration {
        private byte[] bytes;

        public Configuration(long l) {
            byte[] byArray = new byte[32];
            byte[] byArray2 = byArray;
            this.bytes = byArray2;
            byArray[0] = 83;
            byArray[1] = 72;
            byArray[2] = 65;
            byArray[3] = 51;
            byArray[4] = 1;
            byArray[5] = 0;
            ThreefishEngine.wordToBytes(l, byArray2, 8);
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

