/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.ECDecryptor;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.ECPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ECPrivateKeyParameters) {
            this.key = (ECPrivateKeyParameters)cipherParameters;
            return;
        }
        throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
    }

    @Override
    public ECPoint decrypt(ECPair eCPair) {
        ECPrivateKeyParameters eCPrivateKeyParameters = ((ECElGamalDecryptor)((Object)eCPoint)).key;
        if (eCPrivateKeyParameters != null) {
            ECCurve eCCurve = eCPrivateKeyParameters.getParameters().getCurve();
            ECPoint eCPoint = ECAlgorithms.cleanPoint(eCCurve, eCPair.getX()).multiply(((ECElGamalDecryptor)((Object)eCPoint)).key.getD());
            return ECAlgorithms.cleanPoint(eCCurve, eCPair.getY()).subtract(eCPoint).normalize();
        }
        throw new IllegalStateException("ECElGamalDecryptor not initialised");
    }
}

