/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.ECEncryptor;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.ECPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECElGamalEncryptor
implements ECEncryptor {
    private ECPublicKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(CipherParameters cipherParameters) {
        block5: {
            block4: {
                block2: {
                    block3: {
                        if (!(cipherParameters instanceof ParametersWithRandom)) break block2;
                        if (!(((ParametersWithRandom)(cipherParameters = (ParametersWithRandom)cipherParameters)).getParameters() instanceof ECPublicKeyParameters)) break block3;
                        this.key = (ECPublicKeyParameters)((ParametersWithRandom)cipherParameters).getParameters();
                        this.random = ((ParametersWithRandom)cipherParameters).getRandom();
                        break block4;
                    }
                    throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
                }
                if (!(cipherParameters instanceof ECPublicKeyParameters)) break block5;
                ECElGamalEncryptor eCElGamalEncryptor = this;
                eCElGamalEncryptor.key = (ECPublicKeyParameters)cipherParameters;
                eCElGamalEncryptor.random = CryptoServicesRegistrar.getSecureRandom();
            }
            return;
        }
        throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
    }

    @Override
    public ECPair encrypt(ECPoint eCPoint) {
        Object object = ((ECElGamalEncryptor)((Object)eCPoint2)).key;
        if (object != null) {
            object = ((ECKeyParameters)object).getParameters();
            BigInteger bigInteger = ECUtil.generateK(((ECDomainParameters)object).getN(), ((ECElGamalEncryptor)((Object)eCPoint2)).random);
            ECMultiplier eCMultiplier = ((ECElGamalEncryptor)((Object)eCPoint2)).createBasePointMultiplier();
            ECPoint[] eCPointArray = new ECPoint[2];
            ECPoint[] eCPointArray2 = eCPointArray;
            eCPointArray2[0] = eCMultiplier.multiply(((ECDomainParameters)object).getG(), bigInteger);
            eCPointArray[1] = ((ECElGamalEncryptor)((Object)eCPoint2)).key.getQ().multiply(bigInteger).add(ECAlgorithms.cleanPoint(((ECDomainParameters)object).getCurve(), eCPoint));
            ((ECDomainParameters)object).getCurve().normalizeAll(eCPointArray2);
            ECPoint eCPoint2 = eCPointArray2[0];
            return new ECPair(eCPoint2, eCPointArray2[1]);
        }
        throw new IllegalStateException("ECElGamalEncryptor not initialised");
    }

    public ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

