/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.ECPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.ECPairFactorTransform;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;

public class ECFixedTransform
implements ECPairFactorTransform {
    private ECPublicKeyParameters key;
    private BigInteger k;

    public ECFixedTransform(BigInteger bigInteger) {
        this.k = bigInteger;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ECPublicKeyParameters) {
            this.key = (ECPublicKeyParameters)cipherParameters;
            return;
        }
        throw new IllegalArgumentException("ECPublicKeyParameters are required for fixed transform.");
    }

    @Override
    public ECPair transform(ECPair eCPair) {
        Object object = ((ECFixedTransform)((Object)eCPoint)).key;
        if (object != null) {
            object = ((ECKeyParameters)object).getParameters();
            BigInteger bigInteger = ((ECDomainParameters)object).getN();
            ECMultiplier eCMultiplier = ((ECFixedTransform)((Object)eCPoint)).createBasePointMultiplier();
            bigInteger = ((ECFixedTransform)((Object)eCPoint)).k.mod(bigInteger);
            ECPoint[] eCPointArray = new ECPoint[2];
            ECPoint[] eCPointArray2 = eCPointArray;
            eCPointArray2[0] = eCMultiplier.multiply(((ECDomainParameters)object).getG(), bigInteger).add(ECAlgorithms.cleanPoint(((ECDomainParameters)object).getCurve(), eCPair.getX()));
            eCPointArray[1] = ((ECFixedTransform)((Object)eCPoint)).key.getQ().multiply(bigInteger).add(ECAlgorithms.cleanPoint(((ECDomainParameters)object).getCurve(), eCPair.getY()));
            ((ECDomainParameters)object).getCurve().normalizeAll(eCPointArray2);
            ECPoint eCPoint = eCPointArray2[0];
            return new ECPair(eCPoint, eCPointArray2[1]);
        }
        throw new IllegalStateException("ECFixedTransform not initialised");
    }

    @Override
    public BigInteger getTransformValue() {
        return this.k;
    }

    public ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

